/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.variable.VariableUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VariableValidationService {
    private static final Logger log = Logger.getLogger(VariableValidationService.class);
    private final SecretEncryptionService encryptionService;

    public VariableValidationService(@NotNull SecretEncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    void validateVariables(@NotNull List<VariableProperties> variables) throws IllegalArgumentException {
        for (VariableProperties variable : variables) {
            if (this.encryptionService.isEncrypted(variable.getValue())) {
                this.validateEncryptedVariable(variable.getName(), variable.getValue());
                continue;
            }
            if (VariableUtils.isValidSecretVariable((String)variable.getName(), (String)variable.getValue())) continue;
            throw new IllegalArgumentException(String.format("Secret variable '%s' can't be multiline", variable.getName()));
        }
    }

    private void validateEncryptedVariable(String name, String value) {
        String errorMessage = null;
        try {
            String decryptedValue = this.encryptionService.decrypt(value);
            if (!VariableUtils.isValidSecretVariable((String)name, (String)decryptedValue)) {
                errorMessage = String.format("Secret variable '%s' can't be multiline", name);
            }
        }
        catch (Exception e) {
            log.info((Object)("Can't decrypt variable" + e.getMessage()));
            errorMessage = String.format("Bamboo can't recognize the decrypted variable '%s' because it might be imported from another Bamboo instance.", name);
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

