/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.RssPermissionsService;
import com.atlassian.bamboo.deployments.specs.RssDeploymentProjectPermissionDao;
import com.atlassian.bamboo.specs.RssPermissionManager;
import com.atlassian.bamboo.specs.RssProjectPermissionDao;
import com.atlassian.bamboo.specs.RssRepositoryPermissionDao;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RssPermissionsServiceImpl
implements RssPermissionsService {
    @Inject
    private RssPermissionManager rssPermissionManager;
    @Inject
    private RssProjectPermissionDao rssProjectPermissionDao;
    @Inject
    private RssDeploymentProjectPermissionDao rssDeploymentProjectPermissionDao;
    @Inject
    private RssRepositoryPermissionDao rssRepositoryPermissionDao;

    @Override
    public RssPermissions buildRssPermissions(VcsRepositoryData repository) {
        long repositoryId = repository.getRootVcsRepositoryId();
        boolean allProjectsAccess = this.rssPermissionManager.isAllProjectsAccess(repositoryId);
        boolean allRepositoriesAccess = this.rssPermissionManager.isAllRepositoriesAccess(repositoryId);
        Set<String> projectKeys = this.rssProjectPermissionDao.findByRepositoryId(repositoryId).stream().map(permission -> permission.getProject().getKey()).collect(Collectors.toSet());
        Set<String> deploymentProjectKeys = this.rssDeploymentProjectPermissionDao.findByRepositoryId(repositoryId).stream().map(permission -> permission.getDeploymentProject().getKey().getKey()).collect(Collectors.toSet());
        HashSet<Long> repositoryIds = new HashSet<Long>();
        repositoryIds.add(repositoryId);
        this.rssRepositoryPermissionDao.findByRepositoryId(repositoryId).stream().map(permission -> permission.getTargetRepository().getId()).forEach(repositoryIds::add);
        String repositoryName = repository.getName();
        return new RssPermissionsImpl(allProjectsAccess, allRepositoriesAccess, projectKeys, deploymentProjectKeys, repositoryIds, repositoryName);
    }

    private static class RssPermissionsImpl
    implements RssPermissions {
        private final boolean allProjectsAccess;
        private final boolean allRepositoriesAccess;
        private final Set<String> projectKeys;
        private final Set<String> deploymentProjectKeys;
        private final Set<Long> repositoryIds;
        private final String repositoryName;

        public RssPermissionsImpl(boolean allProjectsAccess, boolean allRepositoriesAccess, Set<String> projectKeys, Set<String> deploymentProjectKeys, Set<Long> repositoryIds, String repositoryName) {
            this.allProjectsAccess = allProjectsAccess;
            this.allRepositoriesAccess = allRepositoriesAccess;
            this.projectKeys = projectKeys;
            this.deploymentProjectKeys = deploymentProjectKeys;
            this.repositoryIds = repositoryIds;
            this.repositoryName = repositoryName;
        }

        public boolean isAllProjectsAccess() {
            return this.allProjectsAccess;
        }

        public boolean isProjectAllowed(String projectKey) {
            return this.allProjectsAccess || this.projectKeys.contains(projectKey);
        }

        public boolean isDeploymentProjectAllowed(String projectKey) {
            return this.allProjectsAccess || this.deploymentProjectKeys.contains(projectKey);
        }

        public boolean isAllRepositoriesAccess() {
            return this.allRepositoriesAccess;
        }

        public boolean isRepositoryAllowed(long repositoryId) {
            return this.allRepositoriesAccess || this.repositoryIds.contains(repositoryId);
        }

        public String getSpecsRepositoryName() {
            return this.repositoryName;
        }
    }
}

