/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.build.LogEntryDateFormats;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.IOUtils;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Date;

public class RssExecutionOutputHandler
extends BaseOutputHandler {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final StringWriter stringWriter = new StringWriter();

    public String getOutput() {
        return this.stringWriter.toString();
    }

    public void complete() {
        IOUtils.closeQuietly((Closeable)this.stringWriter);
    }

    public void process(InputStream inputStream) throws ProcessException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.resetWatchdog();
                this.process(line);
            }
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public void process(String line) {
        this.stringWriter.write(LogEntryDateFormats.formatterInstanceLocaleUs().format(new Date()) + "\t" + line + LINE_SEPARATOR);
    }
}

