/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorCreatorService;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsService;
import com.atlassian.bamboo.configuration.external.RssDetectionService;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsConsumerFactory;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionFuture;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionQueue;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionRunnable;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionShutdownFuture;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionTriggerData;
import com.atlassian.bamboo.configuration.external.detection.RssDetectionWork;
import com.atlassian.bamboo.event.spi.EventLoggingThreadPoolExecutor;
import com.atlassian.bamboo.plan.ImmutableVcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RssDetectionServiceImpl
implements RssDetectionService {
    private static final Logger log = Logger.getLogger(RssDetectionServiceImpl.class);
    private static final String THREAD_NAME = "BAM::SpecsDetection";
    private static final int THREAD_COUNT = (int)SystemProperty.SPECS_DETECTION_THREADS.getTypedValue();
    private final RssDetectionQueue rssDetectionQueue;
    private final ExecutorService executorService;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AuthorCreatorService authorCreatorService;
    private final BambooSpecsManager bambooSpecsManager;
    private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    private final CustomVariableContext customVariableContext;
    private final ExtendedAuthorManager extendedAuthorManager;
    private final FeatureManager featureManager;
    private final I18nBean i18nBean;
    private final RepositoryStoredSpecsService repositoryStoredSpecsService;
    private final SpecsConsumerFactory specsConsumerFactory;
    private final VcsRepositoryManager vcsRepositoryManager;

    @Inject
    public RssDetectionServiceImpl(@NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull AuthorCreatorService authorCreatorService, @NotNull BambooSpecsManager bambooSpecsManager, @NotNull CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, @NotNull CustomVariableContext customVariableContext, @NotNull ExtendedAuthorManager extendedAuthorManager, @NotNull FeatureManager featureManager, @NotNull I18nBeanFactory i18nBeanFactory, @NotNull RepositoryStoredSpecsService repositoryStoredSpecsService, @NotNull SpecsConsumerFactory specsConsumerFactory, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this(new RssDetectionQueue(), (ExecutorService)new EventLoggingThreadPoolExecutor(THREAD_COUNT, THREAD_COUNT, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque(), (ThreadFactory)new SystemAuthorityThreadFactory(THREAD_NAME)), administrationConfigurationAccessor, authorCreatorService, bambooSpecsManager, cachedRepositoryDefinitionManager, customVariableContext, extendedAuthorManager, featureManager, i18nBeanFactory, repositoryStoredSpecsService, specsConsumerFactory, vcsRepositoryManager);
    }

    @VisibleForTesting
    RssDetectionServiceImpl(@NotNull RssDetectionQueue rssDetectionQueue, @NotNull ExecutorService executorService, @NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull AuthorCreatorService authorCreatorService, @NotNull BambooSpecsManager bambooSpecsManager, @NotNull CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, @NotNull CustomVariableContext customVariableContext, @NotNull ExtendedAuthorManager extendedAuthorManager, @NotNull FeatureManager featureManager, @NotNull I18nBeanFactory i18nBeanFactory, @NotNull RepositoryStoredSpecsService repositoryStoredSpecsService, @NotNull SpecsConsumerFactory specsConsumerFactory, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.rssDetectionQueue = rssDetectionQueue;
        this.executorService = executorService;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.authorCreatorService = authorCreatorService;
        this.bambooSpecsManager = bambooSpecsManager;
        this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
        this.customVariableContext = customVariableContext;
        this.extendedAuthorManager = extendedAuthorManager;
        this.featureManager = featureManager;
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.repositoryStoredSpecsService = repositoryStoredSpecsService;
        this.specsConsumerFactory = specsConsumerFactory;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @PostConstruct
    public void postConstruct() {
        for (int i = 0; i < THREAD_COUNT; ++i) {
            this.executorService.submit(new RssDetectionRunnable(this, this.rssDetectionQueue));
        }
    }

    @NotNull
    public Future<Boolean> enqueue(long repositoryId, @NotNull VcsBranch vcsBranch) {
        return this.enqueue(repositoryId, vcsBranch, false);
    }

    @NotNull
    public Future<Boolean> enqueue(long repositoryId, @NotNull VcsBranch vcsBranch, boolean force) {
        return this.enqueue(repositoryId, vcsBranch, force, this.specsConsumerFactory.createDefaultSpecsConsumer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<Boolean> enqueue(long repositoryId, @NotNull VcsBranch vcsBranch, boolean force, @NotNull SpecsConsumer specsConsumer) {
        RssDetectionQueue rssDetectionQueue = this.rssDetectionQueue;
        synchronized (rssDetectionQueue) {
            if (this.rssDetectionQueue.isShuttingDown()) {
                log.info((Object)("Bamboo Specs detection service is shutting down, can't enqueue repository: " + repositoryId));
                return ConcurrentUtils.constantFuture((Object)false);
            }
            if (log.isDebugEnabled()) {
                String repositoryName = Optional.ofNullable(this.cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryId)).map(repo -> repo.getName() + "(" + repo.getId() + ")").orElse(String.valueOf(repositoryId));
                log.debug((Object)("Enqueuing Bamboo Specs detection for repository: " + repositoryName));
            }
            RssDetectionWork detectionJob = this.rssDetectionQueue.enqueue(repositoryId, vcsBranch, force, specsConsumer);
            return new RssDetectionFuture(detectionJob);
        }
    }

    public boolean isInProgress(long repositoryId, @NotNull VcsBranch vcsBranch) {
        return this.rssDetectionQueue.isInProgress(repositoryId, vcsBranch);
    }

    public void cleanUnfinishedSpecsAndInitService() {
        try {
            this.repositoryStoredSpecsService.cleanUnfinishedSpecsScans();
        }
        finally {
            this.active.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getEnqueuedBranchesForRepository(long repositoryId) {
        RssDetectionQueue rssDetectionQueue = this.rssDetectionQueue;
        synchronized (rssDetectionQueue) {
            return this.rssDetectionQueue.peekAllQueued().stream().filter(rssDetectionWorkKey -> rssDetectionWorkKey.getRepositoryId() == repositoryId).map(rssDetectionWorkKey -> rssDetectionWorkKey.getVcsBranch().getName()).distinct().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<Boolean> shutdown() {
        List<RssDetectionWork> unfinishedWork;
        this.active.set(false);
        Object object = this.rssDetectionQueue;
        synchronized (object) {
            log.info((Object)"Bamboo Specs detection service shutdown requested.");
            unfinishedWork = this.rssDetectionQueue.shutdown();
        }
        object = unfinishedWork.iterator();
        while (object.hasNext()) {
            RssDetectionWork detectionWork;
            RssDetectionWork rssDetectionWork = detectionWork = (RssDetectionWork)object.next();
            synchronized (rssDetectionWork) {
                detectionWork.setCompleted(true);
                detectionWork.setSpecsExecuted(false);
                detectionWork.notifyAll();
            }
        }
        this.executorService.shutdown();
        return new RssDetectionShutdownFuture(this.executorService);
    }

    @NotNull
    public ErrorCollection canEnqueue(long repositoryId) {
        VcsRepositoryData vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        if (vcsRepositoryData == null || vcsRepositoryData.isMarkedForDeletion()) {
            return new SimpleErrorCollection(new String[]{String.format("Repository with ID %s not found.", repositoryId)});
        }
        return this.canEnqueue(vcsRepositoryData);
    }

    @NotNull
    public ErrorCollection canEnqueue(@NotNull VcsRepositoryData vcsRepositoryData) {
        if (!this.active.get()) {
            return new SimpleErrorCollection(new String[]{"RssDetectionService is not active"});
        }
        VcsBranchDefinition branch = vcsRepositoryData.getBranch();
        String branchName = Optional.ofNullable(branch).map(branchDefinition -> branchDefinition.getVcsBranch().getName()).orElse(null);
        if (branchName == null) {
            return new SimpleErrorCollection(new String[]{String.format("Repository '%s' doesn't have branch name configured.", vcsRepositoryData.getName())});
        }
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
        if (vcsRepositoryModuleDescriptor == null) {
            return new SimpleErrorCollection(new String[]{String.format("Repository '%s' is of unknown type.", vcsRepositoryData.getName())});
        }
        if (vcsRepositoryData.getParentId() != null) {
            return new SimpleErrorCollection(new String[]{String.format("Bamboo Specs can be processed only for top level repositories, repository (id=%d) has a parent (id=%d).", vcsRepositoryData.getId(), vcsRepositoryData.getParentId())});
        }
        if (!this.featureManager.isRepositoryStoredSpecsEnabled()) {
            return new SimpleErrorCollection(new String[]{"Repository-stored Bamboo Specs feature is disabled globally."});
        }
        if (!this.administrationConfigurationAccessor.getAdministrationConfiguration().getRssSecurityConfiguration().isEnabled()) {
            return new SimpleErrorCollection(new String[]{"Repository-stored Bamboo Specs scanning is disabled globally."});
        }
        VcsBambooSpecsDetectionOptions specsDetectionOptions = vcsRepositoryData.getBambooSpecsDetectionOptions();
        if (specsDetectionOptions == null || !specsDetectionOptions.isBambooSpecsDetectionEnabled()) {
            return new SimpleErrorCollection(new String[]{String.format("Bamboo Specs scanning hasn't been enabled for repository '%s'.", vcsRepositoryData.getName())});
        }
        BambooSpecsHandler bambooSpecsHandler = vcsRepositoryModuleDescriptor.getBambooSpecsHandler();
        if (bambooSpecsHandler == null) {
            return new SimpleErrorCollection(new String[]{String.format("Repository type '%s' doesn't support Bamboo Specs. Couldn't process repository '%s'.", vcsRepositoryModuleDescriptor.getName(), vcsRepositoryData.getName())});
        }
        return new SimpleErrorCollection();
    }

    @VisibleForTesting
    Either<RssTriggerError, RssDetectionTriggerData> getRssDetectionTriggerData(long repositoryId, @NotNull VcsBranch vcsBranch, boolean forced, @NotNull SpecsConsumer specsConsumer) throws RepositoryException {
        VcsRepositoryData vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        if (vcsRepositoryData == null || vcsRepositoryData.isMarkedForDeletion()) {
            return Either.left((Object)new RssTriggerError(this.i18nBean.getText("rss.import.missing.repository", Collections.singletonList(repositoryId))));
        }
        ErrorCollection validationErrors = this.canEnqueue(vcsRepositoryData);
        if (validationErrors.hasAnyErrors()) {
            return Either.left((Object)new RssTriggerError(String.join((CharSequence)" ", validationErrors.getAllErrorMessages())));
        }
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
        Preconditions.checkState((vcsRepositoryModuleDescriptor != null ? 1 : 0) != 0);
        BambooSpecsHandler bambooSpecsHandler = vcsRepositoryModuleDescriptor.getBambooSpecsHandler();
        Preconditions.checkState((bambooSpecsHandler != null ? 1 : 0) != 0);
        String branchName = vcsBranch.getName();
        long rootRepositoryId = vcsRepositoryData.getRootVcsRepositoryId();
        Optional previousSpecsState = this.bambooSpecsManager.findLatestState(rootRepositoryId, branchName);
        boolean shouldReportMissingSpecs = previousSpecsState.map(specsState -> !specsState.isSpecsNotFound()).orElse(true);
        Optional specsRevisionOptional = bambooSpecsHandler.detectSpecRevision(vcsRepositoryData, (Object)branchName);
        if (!specsRevisionOptional.isPresent()) {
            specsConsumer.onSpecsRevisionNotFound();
            String errorMessage = this.i18nBean.getText("rss.import.missing.specs.dir", Arrays.asList(vcsRepositoryData.getName(), branchName));
            return Either.left((Object)new RssTriggerError(errorMessage, true, shouldReportMissingSpecs));
        }
        String specsRevision = (String)specsRevisionOptional.get();
        log.debug((Object)("Detected specs revision: " + specsRevision));
        if (previousSpecsState.isPresent() && !forced && !bambooSpecsHandler.isNewer(vcsRepositoryData, specsRevision, ((VcsLocationBambooSpecsState)previousSpecsState.get()).getRevision())) {
            return Either.left((Object)new RssTriggerError(this.i18nBean.getText("rss.import.outdated.revision", Arrays.asList(specsRevision, ((VcsLocationBambooSpecsState)previousSpecsState.get()).getRevision(), vcsRepositoryData.getName()))));
        }
        String previousSpecsRevision = previousSpecsState.map(ImmutableVcsLocationBambooSpecsState::getRevision).orElse(specsRevision);
        List commits = bambooSpecsHandler.findCommitsToSpecs(vcsRepositoryData, previousSpecsRevision, specsRevision);
        VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState = new VcsLocationBambooSpecsStateImpl(rootRepositoryId, branchName, specsRevision);
        RssDetectionTriggerData specsTriggerData = new RssDetectionTriggerData(vcsRepositoryData, vcsRepositoryModuleDescriptor, (VcsLocationBambooSpecsState)vcsLocationBambooSpecsState, commits, shouldReportMissingSpecs);
        return Either.right((Object)specsTriggerData);
    }

    public boolean runRssDetection(long repositoryId, @NotNull VcsBranch vcsBranch, boolean forced, @NotNull SpecsConsumer specsConsumer) throws IOException, RepositoryException {
        Either<RssTriggerError, RssDetectionTriggerData> specsTriggerData = this.getRssDetectionTriggerData(repositoryId, vcsBranch, forced, specsConsumer);
        if (specsTriggerData.isLeft()) {
            RssTriggerError rssTriggerError = (RssTriggerError)specsTriggerData.left().get();
            String combinedErrorMessage = "Skipping Specs detection. " + rssTriggerError.error;
            log.info((Object)combinedErrorMessage);
            if (forced || rssTriggerError.shouldReportMissingSpecs) {
                this.reportFailedSpecsScan(repositoryId, vcsBranch, combinedErrorMessage, rssTriggerError.specsNotFound);
            }
            return false;
        }
        RssDetectionTriggerData triggerData = (RssDetectionTriggerData)specsTriggerData.right().get();
        log.debug((Object)String.format("Detected a possible Bamboo specs change in repository %s. Running update.", triggerData.getRepository().getName()));
        this.bambooSpecsManager.save(triggerData.getSpecsState());
        List<CommitContext> commits = this.updateCommitAuthors(triggerData.getSpecsCommits());
        this.repositoryStoredSpecsService.runBambooSpecs(specsConsumer, triggerData.getRepositoryDescriptor(), triggerData.getRepository(), vcsBranch, triggerData.getSpecsState(), commits, forced || triggerData.shouldReportMissingSpecs());
        return true;
    }

    public void reportFailedSpecsScan(long repositoryId, @NotNull VcsBranch vcsBranch, @NotNull String errorMessage, boolean specsNotFound) {
        VcsRepositoryData vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        if (vcsRepositoryData == null) {
            return;
        }
        this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext(), () -> {
            try {
                VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
                PartialVcsRepositoryDataImpl branchOverride = PartialVcsRepositoryDataImpl.createChildWithNewBranch((VcsRepositoryData)vcsRepositoryData, (VcsBranch)vcsBranch, (VcsBranchConfigurator)vcsRepositoryModuleDescriptor.getVcsBranchConfigurator());
                long rootRepositoryId = vcsRepositoryData.getRootVcsRepositoryId();
                CommitContext lastCommit = vcsRepositoryModuleDescriptor.getBranchDetector().getLastCommit(branchOverride.getCompleteData());
                VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState = new VcsLocationBambooSpecsStateImpl(rootRepositoryId, vcsBranch.getName(), lastCommit.getChangeSetId());
                vcsLocationBambooSpecsState.setSpecsNotFound(specsNotFound);
                this.repositoryStoredSpecsService.reportMissingSpecs((VcsLocationBambooSpecsState)vcsLocationBambooSpecsState, vcsRepositoryData, errorMessage, Collections.singletonList(lastCommit));
            }
            catch (Exception e) {
                log.debug((Object)"", (Throwable)e);
            }
        });
    }

    private List<CommitContext> updateCommitAuthors(List<CommitContext> commits) {
        List authors = commits.stream().map(CommitContext::getAuthorContext).collect(Collectors.toList());
        this.authorCreatorService.createMissingAuthors(authors);
        return commits.stream().map(specsCommit -> {
            String authorName = StringUtils.defaultString((String)specsCommit.getAuthorContext().getName()).trim();
            ExtendedAuthor author = this.extendedAuthorManager.getExtendedAuthorByName(authorName);
            return new CommitContextImpl((AuthorContext)author, specsCommit.getFiles(), specsCommit.getComment(), specsCommit.getDate(), specsCommit.getChangeSetId());
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    static class RssTriggerError {
        public final String error;
        public final boolean specsNotFound;
        public final boolean shouldReportMissingSpecs;

        public RssTriggerError(String error) {
            this(error, false, false);
        }

        public RssTriggerError(String error, boolean specsNotFound, boolean shouldReportMissingSpecs) {
            this.error = error;
            this.specsNotFound = specsNotFound;
            this.shouldReportMissingSpecs = shouldReportMissingSpecs;
        }
    }
}

