/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsService;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.RssPermissionsService;
import com.atlassian.bamboo.configuration.external.SpecsConsumer;
import com.atlassian.bamboo.configuration.external.SpecsNotFoundException;
import com.atlassian.bamboo.configuration.external.rss.JavaSpecsImportService;
import com.atlassian.bamboo.configuration.external.rss.RepositoryStoredSpecsResultHelper;
import com.atlassian.bamboo.configuration.external.rss.RssExecutionDirectoryManager;
import com.atlassian.bamboo.configuration.external.rss.YamlSpecsImportService;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.event.analytics.RssRunEvent;
import com.atlassian.bamboo.event.rss.RssErrorEvent;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.rss.PreRssExecutionAction;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooThrowables;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextImpl;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.CompleteVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.NoContextVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RepositoryStoredSpecsServiceImpl
implements RepositoryStoredSpecsService {
    private static final Logger log = Logger.getLogger(RepositoryStoredSpecsServiceImpl.class);
    @VisibleForTesting
    public static final String SUBDIR_CHECKOUT = "checkout";
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BambooSpecsManager bambooSpecsManager;
    private final CustomVariableContext customVariableContext;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nBean i18nBean;
    private final JavaSpecsImportService javaSpecsImportService;
    private final PluginAccessor pluginAccessor;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final RepositoryStoredSpecsLogService repositoryStoredSpecsLogService;
    private final RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService;
    private final RssExecutionDirectoryManager rssExecutionDirectoryManager;
    private final RssPermissionsService rssPermissionsService;
    private final YamlSpecsImportService yamlSpecsImportService;

    @Inject
    public RepositoryStoredSpecsServiceImpl(@NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull BambooSpecsManager bambooSpecsManager, @NotNull CustomVariableContext customVariableContext, @NotNull EventPublisher eventPublisher, @NotNull FeatureManager featureManager, @NotNull I18nBeanFactory i18nBeanFactory, @NotNull JavaSpecsImportService javaSpecsImportService, @NotNull PluginAccessor pluginAccessor, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull RepositoryStoredSpecsLogService repositoryStoredSpecsLogService, @NotNull RepositoryStoredSpecsResultHelper repositoryStoredSpecsResultService, @NotNull RssExecutionDirectoryManager rssExecutionDirectoryManager, @NotNull RssPermissionsService rssPermissionsService, @NotNull YamlSpecsImportService yamlSpecsImportService) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooSpecsManager = bambooSpecsManager;
        this.customVariableContext = customVariableContext;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.javaSpecsImportService = javaSpecsImportService;
        this.pluginAccessor = pluginAccessor;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.repositoryStoredSpecsLogService = repositoryStoredSpecsLogService;
        this.repositoryStoredSpecsResultService = repositoryStoredSpecsResultService;
        this.rssExecutionDirectoryManager = rssExecutionDirectoryManager;
        this.rssPermissionsService = rssPermissionsService;
        this.yamlSpecsImportService = yamlSpecsImportService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBambooSpecs(@NotNull SpecsConsumer specsConsumer, @NotNull VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, @NotNull VcsRepositoryData repository, @NotNull VcsBranch vcsBranch, @NotNull VcsLocationBambooSpecsState specsState, @NotNull List<CommitContext> commits, boolean shouldReportMissingSpecs) throws IOException {
        block26: {
            Preconditions.checkState((boolean)this.featureManager.isRepositoryStoredSpecsEnabled(), (Object)"Attempt to process Bamboo Specs although feature is disabled");
            RssSecurityConfiguration rssSecurityConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration().getRssSecurityConfiguration();
            Preconditions.checkState((boolean)rssSecurityConfiguration.isEnabled(), (Object)"Attempt to process Bamboo Specs although Specs processing was disabled");
            this.eventPublisher.publish((Object)new RssRunEvent(repository.getId()));
            NoContextVcsWorkingCopyManager workingCopyManager = (NoContextVcsWorkingCopyManager)Narrow.downTo((Object)vcsRepositoryModuleDescriptor.getWorkingCopyManager(), NoContextVcsWorkingCopyManager.class);
            Preconditions.checkNotNull((Object)workingCopyManager);
            Path repositoryDir = this.rssExecutionDirectoryManager.getRssExecutionDirectory(repository.getId(), vcsBranch.getName());
            log.debug((Object)String.format("RSS workdir is %s", repositoryDir));
            PartialVcsRepositoryDataImpl branchOverride = PartialVcsRepositoryDataImpl.createChildWithNewBranch((VcsRepositoryData)repository, (VcsBranch)vcsBranch, (VcsBranchConfigurator)vcsRepositoryModuleDescriptor.getVcsBranchConfigurator());
            CompleteVcsRepositoryData branchRepository = new CompleteVcsRepositoryData(repository, (PartialVcsRepositoryData)branchOverride);
            String logFilename = this.repositoryStoredSpecsLogService.generateFileName(commits);
            try (BambooFiles.QuietlyRemoved checkoutDir = BambooFiles.quietlyRemoved((Path)repositoryDir.resolve(SUBDIR_CHECKOUT));){
                BambooCallables.Throwing1 updateToLatestRevision = () -> {
                    log.debug((Object)String.format("Checking out repository %d and branch %s to %s", branchRepository.getRootVcsRepositoryId(), vcsBranch.getName(), checkoutDir));
                    return workingCopyManager.updateToLatestRevision((VcsRepositoryData)branchRepository, checkoutDir.getPath().toFile());
                };
                CacheAwareness.withValuesOlderThanTimestampReloaded((BambooCallables.ThrowingX)((BambooCallables.Throwing)() -> (VcsWorkingCopy)this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext(), (BambooCallables.ThrowingX)updateToLatestRevision)), (long)System.currentTimeMillis(), (CacheAwareness.CacheInfo[])new CacheAwareness.CacheInfo[]{CacheAwareness.CHANGE_DETECTION});
                RssExecutionOutputHandler stdout = new RssExecutionOutputHandler();
                Path bambooSpecsDir = checkoutDir.getPath().resolve(BambooSpecsHandler.BAMBOO_SPECS_DIRECTORY);
                log.debug((Object)("Looking for Bamboo Specs files at " + bambooSpecsDir));
                RssPermissions rssPermissions = this.rssPermissionsService.buildRssPermissions((VcsRepositoryData)branchRepository);
                if (Files.exists(bambooSpecsDir, new LinkOption[0])) {
                    boolean yamlProcessed = this.tryProcessYaml(specsConsumer, (VcsRepositoryData)branchRepository, (VcsLocationBambooSpecsStateImpl)specsState, repositoryDir, commits, stdout, bambooSpecsDir, rssPermissions, logFilename);
                    if (yamlProcessed) break block26;
                    log.debug((Object)"Yaml Specs weren't found. Trying to execute Java Specs.");
                    VcsBambooSpecsSourceImpl vcsBambooSpecsSource = VcsBambooSpecsSourceImpl.javaSpecsSource((VcsLocationBambooSpecsStateImpl)((VcsLocationBambooSpecsStateImpl)specsState));
                    this.bambooSpecsManager.save((VcsBambooSpecsSource)vcsBambooSpecsSource);
                    this.customPreRssAction((VcsRepositoryData)branchRepository, stdout, vcsBambooSpecsSource, logFilename);
                    boolean specsSuccessfulImported = false;
                    boolean writeLogAndSaveNeeded = true;
                    try {
                        specsSuccessfulImported = this.javaSpecsImportService.processSpecs(specsConsumer, (VcsRepositoryData)branchRepository, (VcsBambooSpecsSource)vcsBambooSpecsSource, repositoryDir, bambooSpecsDir, rssSecurityConfiguration, rssPermissions, commits, stdout, logFilename);
                        break block26;
                    }
                    catch (SpecsNotFoundException e) {
                        specsConsumer.onSpecsRevisionNotFound();
                        specsState.setSpecsNotFound(true);
                        String missingSpecsMessage = this.i18nBean.getText("rss.import.missing.specs", Collections.singletonList(repository.getName()));
                        if (shouldReportMissingSpecs) {
                            this.reportMissingSpecs(specsState, (VcsRepositoryData)branchRepository, missingSpecsMessage, commits);
                            writeLogAndSaveNeeded = false;
                        } else {
                            RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, missingSpecsMessage);
                        }
                        throw BambooThrowables.propagate((Throwable)e);
                    }
                    finally {
                        if (writeLogAndSaveNeeded) {
                            this.writeLogAndSaveReference((VcsRepositoryData)branchRepository, stdout, vcsBambooSpecsSource.getVcsLocationBambooSpecsState(), specsSuccessfulImported, logFilename);
                        }
                    }
                }
                log.debug((Object)("Can't find folder " + bambooSpecsDir));
                boolean specsSuccessfulImported = false;
                try {
                    specsSuccessfulImported = specsConsumer.processSpecsDirectoryRemoval((VcsRepositoryData)branchRepository, specsState, commits, rssPermissions, (OutputHandler)stdout, logFilename);
                }
                finally {
                    this.writeLogAndSaveReference((VcsRepositoryData)branchRepository, stdout, specsState, specsSuccessfulImported, logFilename);
                }
            }
            catch (RepositoryException e) {
                Path logPath = this.repositoryStoredSpecsLogService.createBambooSpecLogFile(branchRepository.getRootVcsRepositoryId(), logFilename);
                VariableContextImpl variableContext = new VariableContextImpl(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext().getVariableContexts());
                this.writeLog(PasswordMaskingUtils.maskPossiblePasswordValues((String)("Error during specs scan:\n" + ExceptionUtils.getStackTrace((Throwable)e)), (VariableContext)variableContext), logPath);
                this.bambooSpecsManager.updateAfterSpecsImport(specsState, VcsLocationBambooSpecsState.SpecsImportState.ERROR, logFilename);
                throw BambooThrowables.propagate((Throwable)e);
            }
        }
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.repository.stored.specs.success"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUnfinishedSpecsScans() {
        List unfinishedSpecsScans = this.bambooSpecsManager.getUnfinishedSpecsScans();
        for (VcsLocationBambooSpecsState unfinishedScan : unfinishedSpecsScans) {
            VcsRepositoryData repository = this.repositoryDefinitionManager.getVcsRepositoryData(unfinishedScan.getVcsLocationId());
            String logFilename = "";
            try {
                if (repository == null) continue;
                Optional latestState = this.bambooSpecsManager.findLatestState(unfinishedScan.getVcsLocationId(), unfinishedScan.getBranch());
                List<CommitContextImpl> commits = Collections.singletonList(CommitContextImpl.builder().changesetId(unfinishedScan.getRevision()).author("[unknown]").comment("Unknown commit").date(new Date()).build());
                if (latestState.isPresent() && ((VcsLocationBambooSpecsState)latestState.get()).getRevision().equals(unfinishedScan.getRevision())) {
                    Collection affectedPlans = this.bambooSpecsManager.findPlansInOtherStates(unfinishedScan);
                    this.repositoryStoredSpecsResultService.createSpecResultAndDisablePlans(affectedPlans, repository, commits, RssPermissions.FULL_ACCESS, false, unfinishedScan);
                }
                Path logPath = this.repositoryStoredSpecsLogService.createBambooSpecLogFile(repository.getRootVcsRepositoryId(), logFilename);
                this.writeLog("Specs scan has been interrupted by Bamboo Server restart", logPath);
                logFilename = logPath.getFileName().toString();
            }
            catch (Exception e) {
                log.error((Object)"Error while cleaning specs state:", (Throwable)e);
            }
            finally {
                this.bambooSpecsManager.updateAfterSpecsImport(unfinishedScan, VcsLocationBambooSpecsState.SpecsImportState.ERROR, logFilename);
            }
        }
    }

    @Override
    public void reportMissingSpecs(@NotNull VcsLocationBambooSpecsState vcsLocationBambooSpecsState, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull String errorMessage, @NotNull List<CommitContext> commits) {
        try {
            String logFilename = this.repositoryStoredSpecsLogService.generateFileName(commits);
            Path logPath = this.repositoryStoredSpecsLogService.createBambooSpecLogFile(vcsLocationBambooSpecsState.getVcsLocationId(), logFilename);
            this.writeLog(errorMessage, logPath);
            this.bambooSpecsManager.updateAfterSpecsImport(vcsLocationBambooSpecsState, VcsLocationBambooSpecsState.SpecsImportState.ERROR, logFilename);
            RssErrorEvent errorEvent = new RssErrorEvent((Object)this, vcsRepositoryData, errorMessage, commits, Collections.emptyList(), Collections.emptyList(), vcsLocationBambooSpecsState.getId(), logFilename);
            this.eventPublisher.publish((Object)errorEvent);
        }
        catch (IOException e) {
            log.warn((Object)"Error while recording specs error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryProcessYaml(SpecsConsumer specsConsumer, VcsRepositoryData repository, VcsLocationBambooSpecsStateImpl specsState, Path workingDir, List<CommitContext> commits, RssExecutionOutputHandler stdout, Path bambooSpecsDir, RssPermissions rssPermissions, String logFilename) throws IOException, RepositoryException {
        for (String bambooYamlFile : BambooSpecsHandler.BAMBOO_YAML_FILES) {
            Path bambooYamlPath = bambooSpecsDir.resolve(bambooYamlFile);
            if (Files.exists(bambooYamlPath, new LinkOption[0])) {
                log.debug((Object)("Processing file " + bambooYamlPath));
                VcsBambooSpecsSourceImpl vcsBambooSpecsSource = VcsBambooSpecsSourceImpl.yamlSpecsSource((VcsLocationBambooSpecsStateImpl)specsState, (String)(BambooSpecsHandler.BAMBOO_SPECS_DIRECTORY + "/" + bambooYamlFile));
                this.bambooSpecsManager.save((VcsBambooSpecsSource)vcsBambooSpecsSource);
                this.customPreRssAction(repository, stdout, vcsBambooSpecsSource, logFilename);
                boolean specsSuccessfulImported = false;
                try {
                    specsSuccessfulImported = this.yamlSpecsImportService.processSimplifiedYaml(specsConsumer, repository, (VcsBambooSpecsSource)vcsBambooSpecsSource, bambooYamlPath, workingDir, rssPermissions, commits, stdout, logFilename);
                }
                finally {
                    this.writeLogAndSaveReference(repository, stdout, vcsBambooSpecsSource.getVcsLocationBambooSpecsState(), specsSuccessfulImported, logFilename);
                }
                return true;
            }
            log.debug((Object)(bambooYamlPath + " not found"));
        }
        return false;
    }

    private void customPreRssAction(VcsRepositoryData repository, RssExecutionOutputHandler stdout, VcsBambooSpecsSourceImpl vcsBambooSpecsSource, String logFilename) throws IOException, RepositoryException {
        ErrorCollection errorCollection = this.customPreRssAction(repository);
        if (errorCollection.hasAnyErrors()) {
            String message = String.join((CharSequence)"\n", errorCollection.getAllErrorMessages());
            RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, message);
            this.writeLogAndSaveReference(repository, stdout, vcsBambooSpecsSource.getVcsLocationBambooSpecsState(), false, logFilename);
            throw new RepositoryException(message, repository.getId());
        }
    }

    @NotNull
    private ErrorCollection customPreRssAction(final VcsRepositoryData repository) {
        List actions = this.pluginAccessor.getEnabledModulesByClass(PreRssExecutionAction.class);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        for (final PreRssExecutionAction action : actions) {
            ErrorCollection errors = (ErrorCollection)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<ErrorCollection>("Failed to run PreRssAction"){

                @NotNull
                public ErrorCollection call() {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (int)1, (int)2, (int)3, (String)("PreRssExecutionAction: " + action.getClass()));
                    return action.execute(repository);
                }
            });
            if (errors == null) {
                errors = new SimpleErrorCollection();
                errors.addErrorMessage("One of the RSS pre execution actions threw an exception, please check bamboo server log.");
            }
            errorCollection.addErrorCollection(errors);
        }
        return errorCollection;
    }

    private void writeLogAndSaveReference(VcsRepositoryData repository, RssExecutionOutputHandler stdout, VcsLocationBambooSpecsState vcsLocationBambooSpecsState, boolean specsSuccessfulImported, String logFilename) throws IOException {
        Path logPath = this.repositoryStoredSpecsLogService.createBambooSpecLogFile(repository.getRootVcsRepositoryId(), logFilename);
        VcsLocationBambooSpecsState.SpecsImportState state = specsSuccessfulImported ? VcsLocationBambooSpecsState.SpecsImportState.SUCCESS : VcsLocationBambooSpecsState.SpecsImportState.ERROR;
        this.writeLog(stdout.getOutput(), logPath);
        this.bambooSpecsManager.updateAfterSpecsImport(vcsLocationBambooSpecsState, state, logPath.getFileName().toString());
    }

    private void writeLog(String data, Path logFile) {
        try {
            BambooPathUtils.writeStringToFile((Path)logFile, (String)data, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

