/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogUtils;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.specs.BambooSpecsStateDao;
import com.atlassian.bamboo.utils.EscapeChars;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryStoredSpecsLogServiceImpl
implements RepositoryStoredSpecsLogService {
    private static final Logger log = Logger.getLogger(RepositoryStoredSpecsLogServiceImpl.class);
    private static final String UNKNOWN_CHANGESET = "unknown_changeset";
    private final BootstrapManager bootstrapManager;
    private final ResultsSummaryManager resultsManager;
    private final BambooSpecsStateDao bambooSpecsStateDao;

    public RepositoryStoredSpecsLogServiceImpl(BootstrapManager bootstrapManager, ResultsSummaryManager resultsManager, BambooSpecsStateDao bambooSpecsStateDao) {
        this.bootstrapManager = bootstrapManager;
        this.resultsManager = resultsManager;
        this.bambooSpecsStateDao = bambooSpecsStateDao;
    }

    public Path createBambooSpecLogFile(long repositoryId, @NotNull String logFilename) {
        Path repositoryHomeFolder = this.getRepositoryLogsFolder(repositoryId);
        return repositoryHomeFolder.resolve(logFilename);
    }

    @Nullable
    public RepositoryStoredSpecsLogService.RepositoryStoredSpecsLogAccessor getBambooSpecsExecutionLogAccessor(@NotNull PlanResultKey planResultKey) throws IllegalStateException {
        ResultsSummary resultsSummary = this.resultsManager.getResultsSummary(planResultKey);
        if (resultsSummary == null) {
            return null;
        }
        Path logFile = this.findFile(resultsSummary);
        if (logFile == null) {
            return null;
        }
        return new RepositoryStoredSpecsLogAccessorImpl(logFile);
    }

    @Nullable
    public Path getBambooSpecsExecutionLogFile(@NotNull PlanResultKey planResultKey) {
        return Optional.ofNullable(this.resultsManager.getResultsSummary(planResultKey)).map(this::findFile).orElse(null);
    }

    @Nullable
    public Path getBambooSpecsExecutionLogFile(long repositoryId, @NotNull String changesetId) {
        Path repositoryLogsFolder = this.getRepositoryLogsFolder(repositoryId);
        return Optional.ofNullable(this.findFileName(repositoryLogsFolder, changesetId)).map(repositoryLogsFolder::resolve).orElse(null);
    }

    @Nullable
    public Path getBambooSpecsExecutionLogFile(@NotNull VcsLocationBambooSpecsState specsState) {
        Path repositoryLogsFolder = this.getRepositoryLogsFolder(specsState.getVcsLocationId());
        return repositoryLogsFolder.resolve(specsState.getLogFilename());
    }

    @Nullable
    private Path findFile(ResultsSummary chainResultSummary) {
        Optional specsLogById;
        String repositorySpecsLogId;
        if (chainResultSummary.getCustomBuildData().containsKey("specs.source.id") && NumberUtils.isCreatable((String)(repositorySpecsLogId = (String)chainResultSummary.getCustomBuildData().get("specs.source.id"))) && (specsLogById = this.bambooSpecsStateDao.findById(Long.parseLong(repositorySpecsLogId))).isPresent()) {
            return this.getRepositoryLogsFolder(((VcsLocationBambooSpecsState)specsLogById.get()).getVcsLocationId()).resolve(((VcsLocationBambooSpecsState)specsLogById.get()).getLogFilename());
        }
        ImmutableList commits = chainResultSummary.getCommits();
        Preconditions.checkState((!commits.isEmpty() ? 1 : 0) != 0, (String)"%s has empty commit list, can't detect log file", (Object)chainResultSummary.getPlanResultKey());
        return Optional.of(commits.get(0)).map(this::findRepositoryFolder).map(arg_0 -> this.lambda$findFile$0((List)commits, arg_0)).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @Nullable
    private String findFileName(Path repositoryLogsFolder, String changeSetId) {
        DirectoryStream.Filter<Path> fileFilter = path -> path.getFileName().toString().endsWith(String.format("%s.log", changeSetId));
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(repositoryLogsFolder, fileFilter);){
            Iterator<Path> iterator = directoryStream.iterator();
            if (iterator.hasNext()) {
                Path possibleResult = iterator.next();
                if (!iterator.hasNext()) {
                    String string = possibleResult.getFileName().toString();
                    return string;
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.warn((Object)("Can't find Bamboo Specs log file in folder " + repositoryLogsFolder.toString() + " for changeset " + changeSetId));
        return null;
    }

    private Path findRepositoryFolder(Commit commit) {
        return Optional.ofNullable(commit.getRepositoryChangeset()).map(RepositoryChangeset::getRepositoryData).map(BambooIdProvider::getId).map(this::getRepositoryLogsFolder).orElse(null);
    }

    private Path getRepositoryLogsFolder(long repositoryId) {
        Path repositoryHomeFolder = Paths.get(this.bootstrapManager.getRepositoryLogsDirectory(), new String[0]).resolve(String.valueOf(repositoryId));
        if (Files.notExists(repositoryHomeFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(repositoryHomeFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return repositoryHomeFolder;
    }

    @NotNull
    public String generateFileName(@NotNull List<? extends CommitContext> commits) {
        String changeSetId = this.getChangeSetForFilename(commits);
        return FastDateFormat.getInstance((String)"yyyy_MM_dd_HH_mm_ss_").format(new Date()) + changeSetId + ".log";
    }

    @NotNull
    public String getChangeSetForFilename(@NotNull List<? extends CommitContext> commits) {
        return commits.stream().filter(commitContext -> commitContext.getChangeSetId() != null).min(Comparator.comparing(CommitContext::getChangeSetId)).map(CommitContext::getChangeSetId).orElse(UNKNOWN_CHANGESET);
    }

    public String generateSpecsLogsUrl(long repositoryId, @NotNull String logFilename, @Nullable String referrer) {
        return "/spec-logs/" + repositoryId + "/" + EscapeChars.forUrl((String)logFilename) + (referrer == null ? "" : "?referrer=" + referrer);
    }

    private /* synthetic */ Path lambda$findFile$0(List commits, Path folder) {
        String fileName = this.findFileName(folder, this.getChangeSetForFilename(commits));
        if (fileName == null) {
            return null;
        }
        return folder.resolve(fileName);
    }

    private static class RepositoryStoredSpecsLogAccessorImpl
    implements RepositoryStoredSpecsLogService.RepositoryStoredSpecsLogAccessor {
        private static final String ENCODING = "UTF-8";
        private final Path file;
        private int totalLines = -1;

        private RepositoryStoredSpecsLogAccessorImpl(@NotNull Path file) {
            this.file = file;
        }

        public List<LogEntry> getLastN(int logLines) throws IOException {
            ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
            int totalLines = this.getNumberOfLinesInFile();
            if (totalLines > 0) {
                try (LineIterator lineIterator = FileUtils.lineIterator((File)this.file.toFile(), (String)ENCODING);){
                    BuildLogUtils.skipLines((int)logLines, (int)totalLines, (LineIterator)lineIterator);
                    while (lineIterator.hasNext()) {
                        String line = lineIterator.next();
                        logs.add(BuildLogUtils.convertSpecsLogToLogEntry((String)line));
                    }
                }
            }
            return logs;
        }

        public boolean isDatePresent() throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file.toFile()), ENCODING));){
                String[] split = BuildLogUtils.splitSpecsLogEntry((String)reader.readLine());
                boolean bl = BuildLogUtils.isSpecsLogEntryWithDate((String[])split);
                return bl;
            }
        }

        private int getNumberOfLinesInFile() throws IOException {
            this.calculateNumberOfLines();
            return this.totalLines;
        }

        private synchronized void calculateNumberOfLines() throws IOException {
            if (this.totalLines == -1 && Files.exists(this.file, new LinkOption[0])) {
                this.totalLines = 0;
                try (BufferedReader reader = new BufferedReader(new FileReader(this.file.toFile()));){
                    String line = reader.readLine();
                    while (line != null) {
                        ++this.totalLines;
                        line = reader.readLine();
                    }
                }
            }
        }
    }
}

