/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.helpers.PermissionHelper;
import com.atlassian.bamboo.configuration.external.helpers.PlanImportHelper;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.configuration.external.util.PropertiesValidator;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanPermissionsService;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.permission.PlanPermissions;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.user.BambooUserManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class PlanPermissionServiceImpl
implements PlanPermissionService {
    @VisibleForTesting
    static final ValidationContext ROOT_VALIDATION_CONTEXT = ValidationContext.of((String)"Plan permissions");
    @Autowired
    private TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private PlanManager planManager;
    @Autowired
    private HibernateMutableAclService aclService;
    @Autowired
    private BambooPermissionManager bambooPermissionManager;
    @Autowired
    private PlanPermissionsService planPermissionsService;
    @Autowired
    private BambooUserManager userManager;

    @Override
    @NotNull
    public PlanPermissionsProperties convertYamlToPlanPermission(@NotNull String yaml) throws PropertiesValidationException, YamlValidationException {
        PlanPermissionsProperties PlanPermissionsProperties2 = YamlHelper.parse(yaml, PlanPermissionsProperties.class);
        PropertiesValidator.validate((EntityProperties)PlanPermissionsProperties2);
        return PlanPermissionsProperties2;
    }

    @Override
    public void importPlanPermission(PlanPermissionsProperties planPermissionsProperties, RssPermissions rssPermissions) throws PropertiesValidationException, UnauthorisedException {
        Optional<TopLevelPlan> topLevelPlan = PlanImportHelper.findExistingPlanByOidOrKey(planPermissionsProperties.getPlanIdentifier(), this.planManager, TopLevelPlan.class);
        if (!topLevelPlan.isPresent()) {
            throw new PropertiesValidationException(String.format("Trying to import plan permission with plan permission for non-existing plan: %s", planPermissionsProperties.getPlanIdentifier()));
        }
        this.importPlanPermission((ImmutablePlan)topLevelPlan.get(), planPermissionsProperties.getPermissions(), rssPermissions);
    }

    @Override
    public PlanPermissionsProperties exportPlanPermission(PlanIdentifierProperties planIdentifier) {
        Optional<TopLevelPlan> topLevelPlan = PlanImportHelper.findExistingPlanByOidOrKey(planIdentifier, this.planManager, TopLevelPlan.class);
        if (topLevelPlan.isPresent()) {
            return this.exportPlanPermission((ImmutablePlan)topLevelPlan.get());
        }
        throw new PropertiesValidationException(String.format("Trying to export plan permission with plan permission for non-existing plan: %s", planIdentifier));
    }

    private void importPlanPermission(ImmutablePlan plan, PermissionsProperties permissionProperties, RssPermissions rssPermissions) {
        this.bambooTransactionHibernateTemplate.execute(status -> {
            if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION) && !this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, plan)) {
                throw new UnauthorisedException(String.format("You don't have ADMIN permission to import plan permission for plan: %s", plan.getKey()));
            }
            if (!rssPermissions.isProjectAllowed(plan.getProject().getKey())) {
                throw new UnauthorisedException(String.format("The specs stored in the repository '%s' don't have permission to import plan permissions for plan '%s'", rssPermissions.getSpecsRepositoryName(), plan.getKey()));
            }
            ValidationContext userValidationContext = ROOT_VALIDATION_CONTEXT.with("Users");
            ValidationContext groupsValidationContext = ROOT_VALIDATION_CONTEXT.with("Groups");
            this.validateUsers(userValidationContext, permissionProperties.getUserPermissions());
            this.validateGroups(groupsValidationContext, permissionProperties.getGroupPermissions());
            MutableAcl acl = this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)plan));
            ArrayList<String> permissions = new ArrayList<String>();
            Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier = arg_0 -> ((PlanPermissionsService)this.planPermissionsService).permissionDependencies(arg_0);
            permissions.addAll(PermissionHelper.createPermissionsForUsers(permissionDependenciesSupplier, permissionProperties.getUserPermissions()));
            permissions.addAll(PermissionHelper.createPermissionsForGroups(permissionDependenciesSupplier, permissionProperties.getGroupPermissions()));
            permissions.addAll(PermissionHelper.createPermissionsForLoggedInUser(permissionDependenciesSupplier, permissionProperties.getLoggedInUserPermissions()));
            permissions.addAll(PermissionHelper.createPermissionsForAnonymousUser(permissionDependenciesSupplier, permissionProperties.getAnonymousUserPermissions()));
            this.aclService.updateAclAces(acl, permissions);
            return null;
        });
    }

    private PlanPermissionsProperties exportPlanPermission(ImmutablePlan plan) {
        return (PlanPermissionsProperties)this.bambooTransactionHibernateTemplate.execute(status -> {
            if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION) && !this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, plan)) {
                throw new UnauthorisedException("You don't have ADMIN permission to export plan permission for plan: " + plan.getKey());
            }
            PlanPermissions planPermission = new PlanPermissions(new PlanIdentifier(plan.getProject().getKey(), plan.getBuildKey())).permissions(PermissionHelper.createFromAcl(this.aclService.readAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)plan))));
            return (PlanPermissionsProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)planPermission);
        });
    }

    private void validateUsers(@NotNull ValidationContext validationContext, @NotNull List<UserPermissionProperties> userPermissions) throws PropertiesValidationException {
        List nonExistingUserNames = userPermissions.stream().map(UserPermissionProperties::getUsername).filter(userName -> this.userManager.getUser(userName) == null).collect(Collectors.toList());
        ImporterUtils.checkArgument((ValidationContext)validationContext, (boolean)nonExistingUserNames.isEmpty(), (Object)("Cannot set permission for non existing users: " + nonExistingUserNames));
    }

    private void validateGroups(@NotNull ValidationContext validationContext, @NotNull List<GroupPermissionProperties> groupPermissionProperties) throws PropertiesValidationException {
        List nonExistingGroupNames = groupPermissionProperties.stream().map(GroupPermissionProperties::getGroup).filter(groupName -> this.userManager.getGroup(groupName) == null).collect(Collectors.toList());
        ImporterUtils.checkArgument((ValidationContext)validationContext, (boolean)nonExistingGroupNames.isEmpty(), (Object)("Cannot set permission for non existing groups: " + nonExistingGroupNames));
    }
}

