/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.VariableValidationService;
import com.atlassian.bamboo.configuration.external.helpers.DockerPipelineExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.JobImportHelper;
import com.atlassian.bamboo.configuration.external.helpers.PlanImportHelper;
import com.atlassian.bamboo.configuration.external.helpers.PlanRepositoryValidator;
import com.atlassian.bamboo.configuration.external.helpers.TaskDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.util.PropertiesValidator;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.exception.RssPermissionException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.CreatePlanBranchesProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.EmptyDependenciesListProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlanConfigImportValidationService {
    static final ValidationContext PLAN_BRANCH_WORKFLOW_VALIDATION_CONTEXT = ValidationContext.of((String)"Plan branch / workflow");
    private static final String CHANGE_OF_KEY_NOT_SUPPORTED_MSG = "Changing keys of plans and jobs is not supported during import. Old key '%s', new key '%s'";
    private static final String CREATE_REMOVE_KEY_CONFLICT_MSG = "Removing job and creating another with the same key is not supported";
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BambooPermissionManager bambooPermissionManager;
    private final CachedPlanManager cachedPlanManager;
    private final PlanManager planManager;
    private final PlanRepositoryValidator planRepositoryValidator;
    private final TaskDefinitionExportHelper taskDefinitionExportHelper;
    private final TextProvider textProvider;
    private final TriggerDefinitionExportHelper triggerDefinitionExportHelper;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final VariableValidationService variableValidationService;

    PlanConfigImportValidationService(@NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull CachedPlanManager cachedPlanManager, @NotNull SecretEncryptionService encryptionService, @NotNull PlanManager planManager, @NotNull PlanRepositoryValidator planRepositoryValidator, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull TextProvider textProvider, @NotNull TaskDefinitionExportHelper taskDefinitionExportHelper, @NotNull TriggerDefinitionExportHelper triggerDefinitionExportHelper, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooPermissionManager = bambooPermissionManager;
        this.cachedPlanManager = cachedPlanManager;
        this.planManager = planManager;
        this.planRepositoryValidator = planRepositoryValidator;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.taskDefinitionExportHelper = taskDefinitionExportHelper;
        this.textProvider = textProvider;
        this.triggerDefinitionExportHelper = triggerDefinitionExportHelper;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.variableValidationService = new VariableValidationService(encryptionService);
    }

    void validatePlanProperties(PlanProperties planProperties, RssPermissions rssPermissions, @Nullable VcsBranch importedBranch) {
        PropertiesValidator.validate((EntityProperties)planProperties);
        this.taskDefinitionExportHelper.validateTaskProperties(planProperties, rssPermissions, importedBranch);
        this.triggerDefinitionExportHelper.validateTriggerProperties(planProperties, rssPermissions);
        DockerPipelineExportHelper.validateDockerConfiguration(planProperties);
        if (importedBranch != null) {
            this.validatePlanBranchRepositories(planProperties);
        } else {
            this.validatePlanRepositoryPermissions(planProperties);
        }
    }

    void validateStageNamesUnique(PlanProperties planProperties) {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> notUniqueNames = new HashSet<String>();
        for (StageProperties stageProperties : planProperties.getStages()) {
            if (names.contains(stageProperties.getName())) {
                notUniqueNames.add(stageProperties.getName());
            }
            names.add(stageProperties.getName());
        }
        if (!notUniqueNames.isEmpty()) {
            throw new IllegalArgumentException("Duplicate stage names: " + Joiner.on((String)", ").join(notUniqueNames));
        }
    }

    void validateRepositorySupportsPlanBranchWorkflow(PluginKeyProvider planRepositoryDefinition, PlanBranchWorkflow workflow) {
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor;
        if (planRepositoryDefinition != null && (repositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey())) != null) {
            switch (workflow) {
                case BRANCH_WORKFLOW: {
                    if (repositoryModuleDescriptor.supportsBranchDetection()) break;
                    ValidationProblem validationProblem = new ValidationProblem(PLAN_BRANCH_WORKFLOW_VALIDATION_CONTEXT, "Default plan repository doesn't support '" + CreatePlanBranchesProperties.Trigger.BRANCH.name() + "' workflow. Don't use this setting or choose another repository as default");
                    throw new PropertiesValidationException(Collections.singletonList(validationProblem));
                }
                case PULL_REQUEST_WORKFLOW: {
                    if (repositoryModuleDescriptor.supportsPullRequestDetection()) break;
                    ValidationProblem validationProblem = new ValidationProblem(PLAN_BRANCH_WORKFLOW_VALIDATION_CONTEXT, "Default plan repository doesn't support '" + CreatePlanBranchesProperties.Trigger.PULL_REQUEST.name() + "' workflow. Don't use this setting or choose another repository as default");
                    throw new PropertiesValidationException(Collections.singletonList(validationProblem));
                }
            }
        }
    }

    void validateJobKeysAndNames(PlanKey newChainKey, PlanProperties planProperties) {
        HashSet<PlanKey> savedKeys = new HashSet<PlanKey>();
        HashSet<String> names = new HashSet<String>();
        for (StageProperties stageProperties : planProperties.getStages()) {
            for (JobProperties jobProperties : stageProperties.getJobs()) {
                PlanKey savedKey = PlanKeys.getJobKey((PlanKey)newChainKey, (String)jobProperties.getKey().getKey());
                boolean validationFailed = false;
                String message = "";
                if (savedKeys.contains(savedKey)) {
                    validationFailed = true;
                    message = message + "Duplicate job key [" + savedKey + "]. ";
                }
                if (names.contains(jobProperties.getName())) {
                    validationFailed = true;
                    message = message + "Duplicate job name [" + jobProperties.getName() + "].";
                }
                if (validationFailed) {
                    throw new IllegalArgumentException(message);
                }
                savedKeys.add(savedKey);
                names.add(jobProperties.getName());
            }
        }
    }

    void validatePlanAndJobKeys(TopLevelPlan existingPlan, PlanKey newChainKey, PlanProperties planProperties) {
        if (!existingPlan.getPlanKey().equals((Object)newChainKey)) {
            throw new UnsupportedOperationException(String.format(CHANGE_OF_KEY_NOT_SUPPORTED_MSG, existingPlan.getPlanKey(), newChainKey));
        }
        this.validateJobKeysAndNames(newChainKey, planProperties);
        HashSet<PlanKey> savedKeys = new HashSet<PlanKey>();
        HashSet<Long> notDeletedJobs = new HashSet<Long>();
        for (StageProperties stageProperties : planProperties.getStages()) {
            for (JobProperties jobProperties : stageProperties.getJobs()) {
                Optional existingJob = JobImportHelper.findPlanByKey(existingPlan.getAllJobs(), jobProperties.toPlanIdentifier());
                if (existingJob.isPresent()) {
                    Job job = (Job)existingJob.get();
                    if (jobProperties.getKey() != null && !job.getPlanKey().getPartialKey().equals(jobProperties.getKey().getKey())) {
                        throw new UnsupportedOperationException(String.format(CHANGE_OF_KEY_NOT_SUPPORTED_MSG, job.getPlanKey().getPartialKey(), jobProperties.getKey().getKey()));
                    }
                    notDeletedJobs.add(job.getId());
                }
                PlanKey savedKey = PlanKeys.getJobKey((PlanKey)newChainKey, (String)jobProperties.getKey().getKey());
                savedKeys.add(savedKey);
            }
        }
        for (Job job : existingPlan.getAllJobs()) {
            if (notDeletedJobs.contains(job.getId()) || !savedKeys.contains(job.getPlanKey())) continue;
            throw new UnsupportedOperationException(CREATE_REMOVE_KEY_CONFLICT_MSG);
        }
    }

    void validateForceStopBuild(@NotNull PlanProperties planProperties, PlanKey chainKey, @Nullable Boolean forceStopHungBuilds) {
        if (forceStopHungBuilds != null && planProperties.getForceStopHungBuilds().booleanValue() && this.administrationConfigurationAccessor.getAdministrationConfiguration().getBuildHangingConfig().isDisabled()) {
            throw new IllegalArgumentException("Build monitoring is disabled globally, can't enable force stop feature for chain " + chainKey);
        }
    }

    void validatePlanVariables(@NotNull List<VariableProperties> variables) throws IllegalArgumentException {
        this.variableValidationService.validateVariables(variables);
    }

    void validateChangingRepositoryOrder(@NotNull Plan plan, @Nullable PlanRepositoryDefinition existingDefaultRepository, @NotNull PartialVcsRepositoryData newDefaultRepository) throws PropertiesValidationException {
        if (existingDefaultRepository == null) {
            return;
        }
        boolean brokenCompatibility = false;
        if (newDefaultRepository.getParentId() != null && newDefaultRepository.getRootVcsRepositoryId() != existingDefaultRepository.getRootVcsRepositoryId()) {
            brokenCompatibility = true;
        }
        if (!newDefaultRepository.getPluginKey().equals(existingDefaultRepository.getPluginKey())) {
            brokenCompatibility = true;
        }
        if (brokenCompatibility && !this.planRepositoryValidator.canChangeDefaultRepository((ImmutablePlan)plan)) {
            ValidationProblem validationProblem = new ValidationProblem(PLAN_BRANCH_WORKFLOW_VALIDATION_CONTEXT, "You can't change the default repository because automatic branch management for this plan is dependent on pull request  and PR plan branches exist for this build.Update plan's branching configuration or delete existing pull request plans to enable switching the default repository.");
            throw new PropertiesValidationException(Collections.singletonList(validationProblem));
        }
    }

    @VisibleForTesting
    void validatePlanRepositoryPermissions(PlanProperties planProperties) throws PropertiesValidationException {
        if (!planProperties.getRepositories().isEmpty()) {
            List linkedRepositories;
            List planRepositories;
            Optional<TopLevelPlan> existingPlan = PlanImportHelper.findExistingPlanByOidOrKey(planProperties, this.planManager, TopLevelPlan.class);
            List<PlanRepositoryDefinition> existingPlanRepositoryDefinitions = existingPlan.map(ImmutableChain::getPlanRepositoryDefinitions).orElse(Collections.emptyList());
            if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY) && !(planRepositories = planProperties.getRepositories().stream().filter(repository -> !repository.getRepositoryDefinition().hasParent()).collect(Collectors.toList())).isEmpty()) {
                if (!existingPlan.isPresent()) {
                    throw new PropertiesValidationException(ValidationContext.of((String)"Plan repository"), this.textProvider.getText("rest.import.plan.repository.no.create.permissions"));
                }
                boolean hasNewRepositories = planRepositories.stream().anyMatch(repo -> !this.repositoryExists(repo.getRepositoryDefinition(), existingPlanRepositoryDefinitions));
                if (hasNewRepositories) {
                    throw new PropertiesValidationException(ValidationContext.of((String)"Plan repository"), this.textProvider.getText("rest.import.plan.repository.no.create.permissions"));
                }
            }
            if ((linkedRepositories = planProperties.getRepositories().stream().filter(repository -> repository.getRepositoryDefinition().hasParent()).collect(Collectors.toList())).isEmpty()) {
                return;
            }
            for (PlanRepositoryLinkProperties linkedRepository : linkedRepositories) {
                VcsRepositoryData linkedRepositoryData = this.getLinkedRepository(linkedRepository.getRepositoryDefinition().getParent());
                if (linkedRepositoryData == null) {
                    throw new PropertiesValidationException(ValidationContext.of((String)"Plan repository"), this.textProvider.getText("rest.import.plan.repository.linked.repository.not.exist", Collections.singletonList(linkedRepository.getRepositoryDefinition().getParent())));
                }
                if (this.alreadyLinked(linkedRepositoryData, existingPlanRepositoryDefinitions) || this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)linkedRepositoryData, null)) continue;
                throw new PropertiesValidationException(ValidationContext.of((String)"Plan repository"), this.textProvider.getText("rest.import.plan.repository.linked.no.permission", Collections.singletonList(linkedRepository.getRepositoryDefinition().getParent())));
            }
        }
    }

    @VisibleForTesting
    void validatePlanBranchRepositories(PlanProperties planProperties) throws PropertiesValidationException {
        if (!planProperties.getRepositories().isEmpty()) {
            Optional<TopLevelPlan> existingPlan = PlanImportHelper.findExistingPlanByOidOrKey(planProperties, this.planManager, TopLevelPlan.class);
            List existingPlanRepositoryDefinitions = existingPlan.map(ImmutableChain::getPlanRepositoryDefinitions).orElseThrow(() -> new PropertiesValidationException(ValidationContext.of((String)"Plan repository"), this.textProvider.getText("rest.import.plan.branch.no.parent.plan")));
            boolean hasNewRepositories = planProperties.getRepositories().stream().anyMatch(repo -> !this.branchedRepoExistsInPlan(repo.getRepositoryDefinition(), existingPlanRepositoryDefinitions));
            if (hasNewRepositories) {
                throw new PropertiesValidationException(ValidationContext.of((String)"Plan repository"), this.textProvider.getText("rest.import.plan.branch.no.parent.repo"));
            }
        }
    }

    private boolean branchedRepoExistsInPlan(VcsRepositoryProperties repository, List<PlanRepositoryDefinition> existingRepositories) {
        if (repository.getOid() != null) {
            BambooOidProperties oid = repository.getOid();
            return existingRepositories.stream().anyMatch(repo -> repo.getOid().toExternalValue().equals(oid.getOid()));
        }
        String name = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{repository.getName(), repository.getParentName()});
        return existingRepositories.stream().anyMatch(repo -> repo.getName().equals(name));
    }

    private boolean alreadyLinked(VcsRepositoryData linkedRepositoryData, List<PlanRepositoryDefinition> existingPlanRepositoryDefinitions) {
        return existingPlanRepositoryDefinitions.stream().anyMatch(r -> r.getRootVcsRepositoryId() == linkedRepositoryData.getId());
    }

    private boolean repositoryExists(VcsRepositoryProperties repository, List<PlanRepositoryDefinition> existingRepositories) {
        if (repository.getOid() != null) {
            BambooOidProperties oid = repository.getOid();
            return existingRepositories.stream().anyMatch(repo -> !repo.isLinked() && repo.getOid().toExternalValue().equals(oid.getOid()));
        }
        String name = repository.getName();
        return existingRepositories.stream().anyMatch(repo -> !repo.isLinked() && repo.getName().equals(name));
    }

    private VcsRepositoryData getLinkedRepository(@NotNull String parentName) throws PropertiesValidationException {
        return this.repositoryDefinitionManager.getLinkedRepositoryByName(parentName);
    }

    @VisibleForTesting
    void validateRssPermissionsForPlan(@NotNull String targetProjectKey, @NotNull PlanProperties planProperties, @NotNull RssPermissions rssPermissions, @NotNull TextProvider textProvider) {
        Set<String> forbiddenLinkedRepositories;
        List<String> parameters;
        HashSet<String> forbiddenDependentProjects = new HashSet<String>();
        Optional<Object> firstMissingPermission = Optional.empty();
        if (!rssPermissions.isProjectAllowed(targetProjectKey)) {
            parameters = Arrays.asList(rssPermissions.getSpecsRepositoryName(), targetProjectKey);
            firstMissingPermission = Optional.of(textProvider.getText("rss.import.plan.insufficient.project.permissions", parameters));
            forbiddenDependentProjects.add(targetProjectKey);
        }
        forbiddenDependentProjects.addAll(this.getForbiddenPlanDependenciesProjectKeys(planProperties, rssPermissions));
        if (!forbiddenDependentProjects.isEmpty() && !firstMissingPermission.isPresent()) {
            parameters = Arrays.asList(rssPermissions.getSpecsRepositoryName(), StringUtils.join(forbiddenDependentProjects, (String)", "));
            firstMissingPermission = Optional.of(textProvider.getText("rss.import.plan.add.dependency.insufficient.permissions", parameters));
        }
        if (!(forbiddenLinkedRepositories = this.getForbiddenRepositoryNames(planProperties, rssPermissions)).isEmpty() && !firstMissingPermission.isPresent()) {
            List<String> parameters2 = Arrays.asList(rssPermissions.getSpecsRepositoryName(), StringUtils.join(forbiddenLinkedRepositories, (String)", "));
            firstMissingPermission = Optional.of(textProvider.getText("rss.import.plan.repository.insufficient.permissions", parameters2));
        }
        if (firstMissingPermission.isPresent()) {
            throw new RssPermissionException((String)firstMissingPermission.get(), forbiddenDependentProjects, forbiddenLinkedRepositories);
        }
    }

    @VisibleForTesting
    Set<String> getForbiddenPlanDependenciesProjectKeys(@NotNull PlanProperties planProperties, @NotNull RssPermissions rssPermissions) {
        if (planProperties.getDependenciesProperties() instanceof EmptyDependenciesListProperties) {
            return Collections.emptySet();
        }
        return planProperties.getDependenciesProperties().getChildPlans().stream().filter(PlanIdentifierProperties::isFullKeyDefined).filter(childPlan -> this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)childPlan.getProjectKey().getKey(), (String)childPlan.getKey().getKey())) != null).map(childPlan -> childPlan.getProjectKey().getKey()).filter(projectKey -> !rssPermissions.isProjectAllowed(projectKey)).collect(Collectors.toSet());
    }

    private Set<String> getForbiddenRepositoryNames(PlanProperties planProperties, RssPermissions permissions) {
        if (permissions.isAllRepositoriesAccess()) {
            return Collections.emptySet();
        }
        return planProperties.getRepositories().stream().map(planRepositoryLinkProperties -> planRepositoryLinkProperties.getRepositoryDefinition().getParent()).filter(Objects::nonNull).filter(this.repositoryIsForbidden(permissions)).collect(Collectors.toSet());
    }

    @NotNull
    private Predicate<String> repositoryIsForbidden(RssPermissions permissions) {
        return linkedRepositoryName -> {
            VcsRepositoryData linkedRepository = this.repositoryDefinitionManager.getLinkedRepositoryByName(linkedRepositoryName);
            return linkedRepository != null && !permissions.isRepositoryAllowed(linkedRepository.getId());
        };
    }
}

