/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.DarkFeatureService;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.DefaultBuildDefinition;
import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.build.docker.DockerPipelineValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.PlanConfigImportService;
import com.atlassian.bamboo.configuration.external.PlanConfigImportValidationService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.exporters.ChainDependenciesExporter;
import com.atlassian.bamboo.configuration.external.exporters.HierarchicalConfigurationExporter;
import com.atlassian.bamboo.configuration.external.exporters.NotificationExporter;
import com.atlassian.bamboo.configuration.external.exporters.RepositoryExporter;
import com.atlassian.bamboo.configuration.external.helpers.BuildConfigurationPluginsExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.DockerPipelineExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.JobImportHelper;
import com.atlassian.bamboo.configuration.external.helpers.LicenseValidator;
import com.atlassian.bamboo.configuration.external.helpers.PlanImportHelper;
import com.atlassian.bamboo.configuration.external.helpers.PlanRepositoryValidator;
import com.atlassian.bamboo.configuration.external.helpers.RequirementsExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TaskDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.configuration.external.rss.DivergentBranchDataBean;
import com.atlassian.bamboo.configuration.external.util.ValidationProblemUtils;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.ChainBranchConfigUpdatedEvent;
import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.event.SpecsExplicitDeletionEvent;
import com.atlassian.bamboo.event.analytics.BambooSpecPlanEvent;
import com.atlassian.bamboo.event.artifact.PlanSharedArtifactDefinitionListModified;
import com.atlassian.bamboo.event.branch.PlanBranchResetToLightweight;
import com.atlassian.bamboo.exception.RssPermissionException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.jira.issuelink.JiraBranchLinkingService;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.plan.branch.BranchCreationFacade;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPoint;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPointImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchTriggeringOption;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateAcl;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.label.EmptyLabelsList;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.repository.PlanRepositoryLink;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryBranch;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.label.EmptyLabelsListProperties;
import com.atlassian.bamboo.specs.api.model.label.LabelProperties;
import com.atlassian.bamboo.specs.api.model.plan.AbstractPlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.AbstractPlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanBranchIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.CreatePlanBranchesProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.AllOtherPluginsConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryBranchProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.ImportExportAwarePlugin;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContext;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContextImpl;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.util.concurrent.Lazy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class PlanConfigImportServiceImpl
implements PlanConfigImportService {
    private static final Logger log = Logger.getLogger(PlanConfigImportServiceImpl.class);
    @Inject
    private BambooSpecsManager bambooSpecsManager;
    @Autowired
    private BambooPermissionManager bambooPermissionManager;
    @Autowired
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Autowired
    private RepositoryExporter repositoryExporter;
    @Autowired
    private TaskDefinitionExportHelper taskDefinitionExportHelper;
    @Autowired
    private TriggerDefinitionExportHelper triggerDefinitionExportHelper;
    @Autowired
    private BambooLicenseManager bambooLicenseManager;
    @Autowired
    private PlanManager planManager;
    @Autowired
    private CachedPlanManager cachedPlanManager;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private ProjectConfigurationService projectConfigurationService;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    private PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    @Autowired
    private BranchCreationFacade branchCreationFacade;
    @Autowired
    private PlanScheduler planScheduler;
    @Autowired
    private BuildDefinitionConverter buildDefinitionConverter;
    @Autowired
    private ScopedExclusionService scopedExclusionService;
    @Autowired
    private VariableConfigurationService variableConfigurationService;
    @Autowired
    private ArtifactDefinitionDao artifactDefinitionDao;
    @Autowired
    private TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;
    @Autowired
    private VcsRepositoryConfigurationService repositoryConfigurationService;
    @Autowired
    private BuildDefinitionManager buildDefinitionManager;
    @Autowired
    private ChainBranchManager chainBranchManager;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    private VariableSubstitutorFactory variableSubstitutorFactory;
    @Autowired
    private CustomVariableContext customVariableContext;
    @Autowired
    private DeletionService deletionService;
    @Autowired
    private BambooAclUpdateHelper aclUpdateHelper;
    @Autowired
    private HibernateMutableAclService aclService;
    @Autowired
    private BuildNumberGeneratorService buildNumberGeneratorService;
    @Autowired
    private HierarchicalConfigurationExporter hierarchicalConfigurationExporter;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    private PlanRepositoryValidator planRepositoryValidator;
    @Autowired
    private PluginAccessor pluginAccessor;
    @Autowired
    private NotificationExporter notificationExporter;
    @Autowired
    private ChainDependenciesExporter chainDependenciesExporter;
    @Autowired
    private TextProvider textProvider;
    @Autowired
    private VariableDefinitionManager variableDefinitionManager;
    @Autowired
    private SecretEncryptionService encryptionService;
    @Autowired
    private DockerPipelineValidationService dockerPipelineValidationService;
    @Autowired
    private DarkFeatureService darkFeatureService;
    @Autowired
    private VcsBranchManager vcsBranchManager;
    @Autowired
    private JiraBranchLinkingService jiraBranchLinkingService;
    @Autowired
    private LabelManager labelManager;
    private PlanConfigImportValidationService validationService;

    @PostConstruct
    @VisibleForTesting
    void setUp() {
        this.validationService = new PlanConfigImportValidationService(this.administrationConfigurationAccessor, this.bambooPermissionManager, this.cachedPlanManager, this.encryptionService, this.planManager, this.planRepositoryValidator, this.repositoryDefinitionManager, this.textProvider, this.taskDefinitionExportHelper, this.triggerDefinitionExportHelper, this.vcsRepositoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PlanProperties convertYamlToPlan(@NotNull String yaml) throws PropertiesValidationException, YamlValidationException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)new PluginsClassLoader(old, this.pluginAccessor, (PluginEventManager)new DefaultPluginEventManager()));
            PlanProperties planProperties = YamlHelper.parse(yaml, PlanProperties.class);
            return planProperties;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public void validatePlanProperties(@NotNull PlanProperties planProperties, @NotNull RssPermissions rssPermissions) throws PropertiesValidationException, RssPermissionException {
        this.validationService.validatePlanProperties(planProperties, rssPermissions, null);
    }

    @Override
    public void validatePlanBranchProperties(@NotNull PlanProperties planProperties, @NotNull RssPermissions rssPermissions, @NotNull VcsBranch vcsBranch) throws PropertiesValidationException, RssPermissionException {
        this.validationService.validatePlanProperties(planProperties, rssPermissions, vcsBranch);
    }

    @Override
    @NotNull
    public PlanConfigImportService.ImportResult importPlan(@NotNull PlanProperties planProperties, @Nullable User userForCreation, @NotNull RssPermissions rssPermissions) {
        return this.importPlan(planProperties, userForCreation, rssPermissions, false, false);
    }

    @Override
    @NotNull
    public PlanConfigImportService.ImportResult importPlan(@NotNull PlanProperties planProperties, @Nullable User userForCreation, @NotNull RssPermissions rssPermissions, boolean deferEvents, boolean noChangesInProperties) throws PropertiesValidationException, RssPermissionException {
        this.findOrCreateProject(planProperties.getProject());
        Pair plan = (Pair)this.bambooTransactionHibernateTemplate.execute(status -> {
            Optional<DefaultChain> existingPlan = PlanImportHelper.findExistingPlanByOidOrKey(planProperties, this.planManager, DefaultChain.class);
            Project targetProject = this.findProject(planProperties.getProject());
            if (targetProject == null) {
                throw new IllegalStateException(this.textProvider.getText("rest.import.plan.project.not.found", Collections.singletonList(this.toString(planProperties.getProject()))));
            }
            this.validationService.validateRssPermissionsForPlan(targetProject.getKey(), planProperties, rssPermissions, this.textProvider);
            if (existingPlan.isPresent()) {
                boolean movingPlan;
                if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)existingPlan.get(), null)) {
                    throw new UnauthorisedException(this.textProvider.getText("rest.import.plan.no.edit.permission", Collections.emptyList()));
                }
                boolean bl = movingPlan = !Objects.equals(existingPlan.get().getProject().getKey(), targetProject.getKey());
                if (movingPlan && !this.bambooPermissionManager.canCreatePlanInProject(targetProject)) {
                    throw new UnauthorisedException(this.textProvider.getText("rest.import.plan.insufficient.project.permissions", Collections.singletonList(targetProject.getKey())));
                }
                return Pair.make(this.modifyExistingTopLevelPlan(planProperties, targetProject, existingPlan.get(), noChangesInProperties), (Object)false);
            }
            if (!this.bambooPermissionManager.canCreatePlanInProject(targetProject)) {
                throw new UnauthorisedException(this.textProvider.getText("rest.import.plan.insufficient.project.permissions", Collections.singletonList(targetProject.getKey())));
            }
            return Pair.make(new ChainChanges((ImmutableChain)this.createNewTopLevelPlan(planProperties, targetProject, userForCreation), false, null), (Object)true);
        });
        if (!deferEvents && !noChangesInProperties) {
            if (((Boolean)plan.getSecond()).booleanValue()) {
                this.sendCreateEventsAndScheduleTriggers((ImmutableChain)((ChainChanges)plan.getFirst()).getChain());
            } else {
                this.sendUpdateEventsAndScheduleTriggers((ImmutableChain)((ChainChanges)plan.getFirst()).getChain());
            }
        }
        return new PlanConfigImportService.ImportResult((ImmutableChain)((ChainChanges)plan.getFirst()).getChain(), (Boolean)plan.getSecond(), deferEvents && !noChangesInProperties, ((ChainChanges)plan.getFirst()).getNoChangesInProperties());
    }

    @NotNull
    private ChainChanges<TopLevelPlan> modifyExistingTopLevelPlan(@NotNull PlanProperties planProperties, @NotNull Project newProject, @NotNull DefaultChain existingPlan, boolean noChangesInPlanProperties) {
        boolean updateOnlyRssData;
        ScopedExclusionService.ExclusiveFunction<PlanKey, TopLevelPlan, RuntimeException> planUpdateFunction;
        PlanKey newPlanKey = planProperties.getKey() != null ? PlanKeys.getPlanKey((String)newProject.getKey(), (String)planProperties.getKey().getKey()) : PlanKeys.getPlanKey((String)newProject.getKey(), (String)existingPlan.getPlanKey().getPartialKey());
        Either result = this.scopedExclusionService.tryWithLock((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)newPlanKey, planUpdateFunction = (updateOnlyRssData = noChangesInPlanProperties && existingPlan.getVcsBambooSpecsSource() != null) ? this.updateOnlySpecsData(planProperties, existingPlan) : this.modifyTopLevelPlanFunction(planProperties, newProject, newPlanKey, (TopLevelPlan)existingPlan));
        if (result.isRight()) {
            Preconditions.checkState((boolean)((Optional)result.right().get()).isPresent());
            TopLevelPlan plan = (TopLevelPlan)((Optional)result.right().get()).get();
            this.eventPublisher.publish((Object)new BambooSpecPlanEvent(plan.getPlanKey().getKey().hashCode(), false));
            return new ChainChanges<TopLevelPlan>((ImmutableChain)plan, !updateOnlyRssData, null);
        }
        throw new IllegalStateException(String.format("Could not update chain with key %s as it's being modified in another thread.", newPlanKey));
    }

    private ScopedExclusionService.ExclusiveFunction<PlanKey, TopLevelPlan, RuntimeException> updateOnlySpecsData(@NotNull PlanProperties planProperties, @NotNull DefaultChain existingPlan) {
        return planKey -> {
            this.setBambooSpecsData(planProperties, (AbstractChain)existingPlan);
            this.planManager.savePlan((com.atlassian.bamboo.plan.Plan)existingPlan);
            return existingPlan;
        };
    }

    @NotNull
    private ScopedExclusionService.ExclusiveFunction<PlanKey, TopLevelPlan, RuntimeException> modifyTopLevelPlanFunction(@NotNull PlanProperties planProperties, Project project, PlanKey chainKey, TopLevelPlan existingPlan) {
        return key -> {
            boolean validationFailed = false;
            String message = "";
            if (this.planManager.isPlanKeyConflicting(chainKey, existingPlan.getId())) {
                validationFailed = true;
                message = message + "Duplicate chain key [" + chainKey + "]. ";
            }
            if (this.planManager.isChainNameConflicting(project.getKey(), existingPlan.getId(), planProperties.getName())) {
                validationFailed = true;
                message = message + "Duplicate chain name [" + planProperties.getName() + "].";
            }
            if (validationFailed) {
                throw new IllegalArgumentException(message);
            }
            this.validationService.validateStageNamesUnique(planProperties);
            this.validationService.validatePlanAndJobKeys(existingPlan, chainKey, planProperties);
            this.validationService.validatePlanVariables(planProperties.getVariables());
            this.validationService.validateForceStopBuild(planProperties, chainKey, planProperties.getForceStopHungBuilds());
            LicenseValidator.validateJobsLimit(existingPlan, planProperties, this.bambooLicenseManager.getAllowedNumberOfPlans(), this.planManager.getPlanCount(Buildable.class));
            this.chainDependenciesExporter.validateDependencies((DefaultChain)existingPlan, planProperties.getDependenciesProperties());
            this.planScheduler.removeAllScheduledJobs((Triggerable)existingPlan);
            OperationsRegister operations = new OperationsRegister();
            operations.getPlanKeyChanges().put(existingPlan.getPlanKey(), chainKey);
            DefaultChain topLevelPlan = (DefaultChain)existingPlan;
            topLevelPlan.setProject(project);
            topLevelPlan.setBuildName(planProperties.getName());
            topLevelPlan.setPlanKey(chainKey);
            topLevelPlan.setBuildKey(planProperties.getKey().getKey());
            topLevelPlan.setDescription(planProperties.getDescription());
            topLevelPlan.setSuspendedFromBuilding(!planProperties.isEnabled());
            this.updateNotificationSet((AbstractChain)topLevelPlan, planProperties);
            this.setBambooSpecsData(planProperties, (AbstractChain)topLevelPlan);
            try {
                this.modifyStagesAndJobs((Chain)topLevelPlan, planProperties, operations);
            }
            catch (PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
            BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((com.atlassian.bamboo.plan.Plan)topLevelPlan);
            boolean branchDetectionOnBeforeUpdate = buildDefinition.getBranchMonitoringConfiguration().getPlanBranchWorkflow() == PlanBranchWorkflow.BRANCH_WORKFLOW;
            buildDefinition.getCustomConfiguration().clear();
            buildDefinition.getConfigObjects().clear();
            this.addForceStopBuildConfiguration(planProperties, buildDefinition);
            this.chainDependenciesExporter.importDependencies(topLevelPlan, buildDefinition, planProperties.getDependenciesProperties());
            BuildDefinitionForBuild buildDefinitionForBuild = topLevelPlan.getBuildDefinitionXml();
            BuildConfiguration hierarchicalConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
            this.addBuildConfiguration((com.atlassian.bamboo.plan.Plan)topLevelPlan, hierarchicalConfiguration, (AbstractPlanProperties)planProperties);
            buildDefinitionForBuild.setXmlData(hierarchicalConfiguration.asXml());
            topLevelPlan.setBuildDefinitionXml(buildDefinitionForBuild);
            List<PartialVcsRepositoryData> planRepositories = this.validateAndCreateRepositoryObjects((com.atlassian.bamboo.plan.Plan)topLevelPlan, planProperties.getRepositories(), planProperties.getRepositoryBranches());
            this.deletionService.deletePlansIgnoringBranches(operations.getJobsToRemove());
            this.deletionService.deleteStagesIgnoringBranchesAndJobs(operations.getStagesToRemove());
            this.planManager.savePlan((com.atlassian.bamboo.plan.Plan)topLevelPlan);
            this.variableConfigurationService.setPlanVariables((Chain)topLevelPlan, planProperties.getVariables());
            this.createAndUpdateArtifactDefinitions((AbstractChain)topLevelPlan, planProperties);
            this.createPlanRepositories((com.atlassian.bamboo.plan.Plan)topLevelPlan, planRepositories);
            this.createTasks((AbstractChain)topLevelPlan, planProperties, null);
            this.createTriggers((AbstractChain)topLevelPlan, planProperties);
            this.createAndUpdateLabels((Chain)topLevelPlan, planProperties);
            this.addBranchMonitoringOptions((TopLevelPlan)topLevelPlan, planProperties.getPlanBranchManagementProperties());
            this.scheduleBranchDetectionIfRequired(topLevelPlan, branchDetectionOnBeforeUpdate);
            return topLevelPlan;
        };
    }

    @Override
    @NotNull
    public PlanConfigImportService.ImportResult importPlanBranch(@NotNull PlanProperties planProperties, @NotNull VcsBranch vcsBranch, @Nullable User user, @NotNull RssPermissions rssPermissions) {
        return this.importPlanBranch(planProperties, null, vcsBranch, user, rssPermissions, null, false, false, false);
    }

    @Override
    @NotNull
    public PlanConfigImportService.ImportResult updatePlanBranch(@NotNull PlanProperties planProperties, @NotNull VcsBranch vcsBranch, @Nullable User user, @NotNull RssPermissions rssPermissions, @NotNull DivergentBranchDataBean branchCreationData, boolean deferEvents, boolean noChangesInProperties) {
        DivergentBranchCreationData branchData = branchCreationData.getCreationData().map(cd -> {
            if (cd.getPlanBranchWorkflow() == PlanBranchWorkflow.MANUAL_WORKFLOW) {
                return new DivergentBranchCreationData(cd.getEnablePlan() == PlanCreationService.EnablePlan.ENABLED);
            }
            return new DivergentBranchCreationData(planProperties.isEnabled());
        }).orElse(null);
        return this.importPlanBranch(planProperties, branchCreationData.getPlanBranchKey(), vcsBranch, user, rssPermissions, branchData, deferEvents, noChangesInProperties, true);
    }

    private PlanConfigImportService.ImportResult importPlanBranch(@NotNull PlanProperties planProperties, @Nullable PlanKey planBranchKey, @NotNull VcsBranch vcsBranch, @Nullable User user, @NotNull RssPermissions rssPermissions, @Nullable DivergentBranchCreationData branchCreationData, boolean deferEvents, boolean aNoChangesInProperties, boolean failIfNotFound) {
        boolean isNewBranch = branchCreationData != null;
        boolean noChangesInProperties = !isNewBranch && aNoChangesInProperties;
        Pair plan = (Pair)this.bambooTransactionHibernateTemplate.execute(status -> {
            boolean movingPlan;
            Optional<DefaultChain> existingPlan = PlanImportHelper.findExistingPlanByOidOrKey(planProperties, this.planManager, DefaultChain.class);
            if (!existingPlan.isPresent()) {
                throw new PropertiesValidationException(this.textProvider.getText("rest.import.plan.branch.no.parent.plan"));
            }
            Project targetProject = this.findProject(planProperties.getProject());
            if (targetProject == null) {
                throw new IllegalStateException(this.textProvider.getText("rest.import.plan.project.not.found", Collections.singletonList(this.toString(planProperties.getProject()))));
            }
            this.validationService.validateRssPermissionsForPlan(targetProject.getKey(), planProperties, rssPermissions, this.textProvider);
            if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)existingPlan.get(), null)) {
                throw new UnauthorisedException(this.textProvider.getText("rest.import.plan.no.edit.permission", Collections.emptyList()));
            }
            boolean bl = movingPlan = !Objects.equals(existingPlan.get().getProject().getKey(), targetProject.getKey());
            if (movingPlan && !this.bambooPermissionManager.canCreatePlanInProject(targetProject)) {
                throw new UnauthorisedException(this.textProvider.getText("rest.import.plan.insufficient.project.permissions", Collections.singletonList(targetProject.getKey())));
            }
            if (planBranchKey != null && !planBranchKey.getKey().startsWith(existingPlan.get().getPlanKey().getKey())) {
                throw new PropertiesValidationException("Plan branch key must start with a chain key");
            }
            Optional<ChainBranch> existingBranch = this.findChainBranchForVcsBranch((ImmutablePlan)existingPlan.get(), planBranchKey, vcsBranch);
            if (existingBranch.isPresent()) {
                ChainChanges<ChainBranch> chainBranchChainChanges = this.modifyExistingPlanBranch(planProperties, existingPlan.get(), existingBranch.get(), vcsBranch, branchCreationData, noChangesInProperties);
                return Pair.make(chainBranchChainChanges, (Object)isNewBranch);
            }
            if (failIfNotFound) {
                throw new PropertiesValidationException("Plan branch with key " + planBranchKey + " not found.");
            }
            return Pair.make(this.createPlanBranch(planProperties, (TopLevelPlan)existingPlan.get(), planBranchKey, vcsBranch), (Object)true);
        });
        if (!deferEvents && !noChangesInProperties) {
            if (((Boolean)plan.getSecond()).booleanValue()) {
                this.sendCreateEventsAndScheduleTriggersForBranch((ImmutableChain)((ChainChanges)plan.getFirst()).getChain(), user);
            } else {
                this.sendUpdateEventsAndScheduleTriggers((ImmutableChain)((ChainChanges)plan.getFirst()).getChain());
            }
        }
        return new PlanConfigImportService.ImportResult((ImmutableChain)((ChainChanges)plan.getFirst()).getChain(), (Boolean)plan.getSecond(), deferEvents && !noChangesInProperties, ((ChainChanges)plan.getFirst()).getNoChangesInProperties());
    }

    private ChainChanges<ChainBranch> modifyExistingPlanBranch(@NotNull PlanProperties planProperties, @NotNull DefaultChain defaultChain, @NotNull ChainBranch chainBranch, @NotNull VcsBranch vcsBranch, @Nullable DivergentBranchCreationData branchData, boolean noChangesInProperties) {
        Either result;
        ScopedExclusionService.ExclusiveFunction updateBranchFunction = this.modifyDivergentPlanBranchFunction(planProperties, vcsBranch, (Chain)defaultChain, chainBranch, branchData);
        if (noChangesInProperties) {
            ChainBranchImpl aChainBranch = (ChainBranchImpl)Narrow.downTo((Object)chainBranch, ChainBranchImpl.class);
            updateBranchFunction = planKey -> {
                this.setBambooSpecsData(planProperties, (AbstractChain)aChainBranch);
                this.planManager.savePlan((com.atlassian.bamboo.plan.Plan)aChainBranch);
                return aChainBranch;
            };
            log.info((Object)String.format("No changes in %s. Skipping plan import...", chainBranch.getPlanKey().toString()));
        }
        if ((result = this.scopedExclusionService.tryWithLock((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)chainBranch.getPlanKey(), updateBranchFunction)).isRight()) {
            return new ChainChanges<ChainBranch>((ImmutableChain)((Optional)result.right().get()).get(), noChangesInProperties, null);
        }
        throw new IllegalStateException(String.format("Could not update chain branch with key %s as it's being modified in another thread.", chainBranch.getPlanKey()));
    }

    private ChainChanges<ChainBranch> createPlanBranch(@NotNull PlanProperties planProperties, @NotNull TopLevelPlan topLevelPlan, @Nullable PlanKey planBranchKey, @NotNull VcsBranch vcsBranch) throws PropertiesValidationException {
        return new ChainChanges<ImmutableChain>((ImmutableChain)this.scopedExclusionService.withNewLockedObject((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)topLevelPlan.getProject().getKey(), null, this.uniquePlanKeyGenerator((ImmutablePlan)topLevelPlan, planBranchKey), this.withUniquePlanKey(planProperties, topLevelPlan, vcsBranch)));
    }

    private ScopedExclusionService.ExclusiveFunction<String, ChainBranch, RuntimeException> withUniquePlanKey(@NotNull PlanProperties planProperties, @NotNull TopLevelPlan masterChain, @NotNull VcsBranch vcsBranch) {
        return uniquePlanKey -> (ChainBranch)this.scopedExclusionService.withNewLockedObject((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_BRANCH_NAME, (Object)masterChain.getPlanKey().toString(), null, this.uniqueChainBranchNameGenerator(vcsBranch.getName(), (PlanIdentifier)masterChain), this.createDivergentPlanBranchFunction(planProperties, vcsBranch, (Chain)masterChain, PlanKeys.getPlanKey((String)masterChain.getProject().getKey(), (String)uniquePlanKey)));
    }

    private ScopedExclusionService.GeneratorCallable<String, IncorrectPlanTypeException> uniquePlanKeyGenerator(ImmutablePlan chain, PlanKey planBranchKey) {
        return () -> {
            long i = this.chainBranchManager.getNextBranchKeyNumber(chain);
            if (planBranchKey != null && !this.planManager.isPlanKeyConflicting(planBranchKey)) {
                long branchNumber = Long.parseLong(planBranchKey.getPartialKey().substring(chain.getPlanKey().getPartialKey().length()));
                if (branchNumber >= i) {
                    this.chainBranchManager.updateNextBranchKeyNumber(chain, branchNumber + 1L);
                }
                return planBranchKey.getPartialKey();
            }
            while (true) {
                String candidateKey = chain.getBuildKey() + i;
                if (!this.planManager.isPlanKeyConflicting(PlanKeys.getPlanKey((String)chain.getProject().getKey(), (String)candidateKey))) {
                    this.chainBranchManager.updateNextBranchKeyNumber(chain, i + 1L);
                    return candidateKey;
                }
                ++i;
            }
        };
    }

    private ScopedExclusionService.GeneratorCallable<String, RuntimeException> uniqueChainBranchNameGenerator(String planBranchName, PlanIdentifier chain) {
        Supplier existingPlanNamesRef = Lazy.supplier(() -> {
            Set existingPlanNames = this.chainBranchManager.getBranchIdentifiersForChain(chain).stream().map(PlanIdentifier::getBuildName).collect(Collectors.toCollection(HashSet::new));
            existingPlanNames.add(chain.getBuildName());
            return existingPlanNames;
        });
        return () -> PlanConfigImportServiceImpl.lambda$uniqueChainBranchNameGenerator$9(planBranchName, (Supplier)existingPlanNamesRef);
    }

    @NotNull
    private ScopedExclusionService.ExclusiveFunction<String, ChainBranch, RuntimeException> createDivergentPlanBranchFunction(@NotNull PlanProperties planProperties, @NotNull VcsBranch vcsBranch, @NotNull Chain existingChain, @NotNull PlanKey branchKey) {
        return name -> {
            PlanKey chainKey = branchKey;
            this.validationService.validateStageNamesUnique(planProperties);
            this.validationService.validateJobKeysAndNames(chainKey, planProperties);
            LicenseValidator.validateJobsLimit(null, planProperties, this.bambooLicenseManager.getAllowedNumberOfPlans(), this.planManager.getPlanCount(Buildable.class));
            this.validationService.validatePlanVariables(planProperties.getVariables());
            ChainBranchImpl chainBranch = new ChainBranchImpl();
            chainBranch.setProject(existingChain.getProject());
            chainBranch.setMaster((com.atlassian.bamboo.plan.Plan)existingChain);
            chainBranch.setBuildName(name);
            chainBranch.setPlanKey(chainKey);
            chainBranch.setBuildKey(PlanKeys.getShortKeyFromPlanKey((PlanKey)chainKey));
            chainBranch.setDescription(planProperties.getDescription());
            chainBranch.setSuspendedFromBuilding(!planProperties.isEnabled());
            chainBranch.setBuildDefinitionManager(this.buildDefinitionManager);
            chainBranch.setVariableDefinitionManager(this.variableDefinitionManager);
            chainBranch.setRepositoryDefinitionManager(this.repositoryDefinitionManager);
            chainBranch.setDivergent(true);
            this.setBambooSpecsData(planProperties, (AbstractChain)chainBranch);
            try {
                for (StageProperties stageProperties : planProperties.getStages()) {
                    this.createAndAppendStage((Chain)chainBranch, stageProperties);
                }
            }
            catch (PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
            DefaultBuildDefinition buildDefinition = new DefaultBuildDefinition(false);
            this.setBranchSpecificConfiguration(planProperties, existingChain, (ChainBranch)chainBranch, (BuildDefinition)buildDefinition);
            BuildConfiguration configuration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
            DefaultBuildDefinitionForBuild buildDefinitionForBuild = new DefaultBuildDefinitionForBuild(false);
            buildDefinitionForBuild.setXmlData(ConfigUtils.asXmlString((HierarchicalConfiguration)configuration));
            chainBranch.setBuildDefinitionXml((BuildDefinitionForBuild)buildDefinitionForBuild);
            List<PartialVcsRepositoryData> planRepositories = this.validateAndCreateBranchRepositories(existingChain, (ChainBranch)chainBranch, vcsBranch, planProperties.getRepositories(), planProperties.getRepositoryBranches());
            this.planManager.createPlan((com.atlassian.bamboo.plan.Plan)chainBranch);
            this.variableConfigurationService.setPlanVariables((Chain)chainBranch, planProperties.getVariables());
            this.createAndUpdateArtifactDefinitions((AbstractChain)chainBranch, planProperties);
            this.createPlanRepositories((com.atlassian.bamboo.plan.Plan)chainBranch, planRepositories);
            this.createTasks((AbstractChain)chainBranch, planProperties, vcsBranch);
            this.createTriggers((AbstractChain)chainBranch, planProperties);
            this.createAndUpdateLabels((Chain)chainBranch, planProperties);
            this.vcsBranchManager.createAll((ImmutableChain)existingChain, Collections.singleton(vcsBranch));
            this.performPostCreationActions((AbstractChain)chainBranch);
            return chainBranch;
        };
    }

    @NotNull
    private ScopedExclusionService.ExclusiveFunction<PlanKey, ChainBranch, RuntimeException> modifyDivergentPlanBranchFunction(@NotNull PlanProperties planProperties, @NotNull VcsBranch vcsBranch, @NotNull Chain existingChain, @NotNull ChainBranch aChainBranch, @Nullable DivergentBranchCreationData branchData) {
        return chainKey -> {
            this.validationService.validateStageNamesUnique(planProperties);
            this.validationService.validateJobKeysAndNames((PlanKey)chainKey, planProperties);
            LicenseValidator.validateJobsLimit(null, planProperties, this.bambooLicenseManager.getAllowedNumberOfPlans(), this.planManager.getPlanCount(Buildable.class));
            this.validationService.validatePlanVariables(planProperties.getVariables());
            this.planScheduler.removeAllScheduledJobs((Triggerable)aChainBranch);
            OperationsRegister operations = new OperationsRegister();
            operations.getPlanKeyChanges().put(aChainBranch.getPlanKey(), (PlanKey)chainKey);
            ChainBranchImpl chainBranch = (ChainBranchImpl)Narrow.downTo((Object)aChainBranch, ChainBranchImpl.class);
            chainBranch.setProject(existingChain.getProject());
            chainBranch.setMaster((com.atlassian.bamboo.plan.Plan)existingChain);
            chainBranch.setPlanKey(chainKey);
            chainBranch.setDescription(planProperties.getDescription());
            chainBranch.setSuspendedFromBuilding(branchData != null ? !branchData.enablePlan : !planProperties.isEnabled());
            chainBranch.setBuildDefinitionManager(this.buildDefinitionManager);
            chainBranch.setVariableDefinitionManager(this.variableDefinitionManager);
            chainBranch.setRepositoryDefinitionManager(this.repositoryDefinitionManager);
            chainBranch.setDivergent(true);
            this.updateNotificationSet((AbstractChain)chainBranch, planProperties);
            this.setBambooSpecsData(planProperties, (AbstractChain)chainBranch);
            try {
                this.modifyStagesAndJobs((Chain)chainBranch, planProperties, operations);
            }
            catch (PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
            BuildDefinition buildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(chainBranch.getPlanKey());
            this.setBranchSpecificConfiguration(planProperties, existingChain, aChainBranch, buildDefinition);
            BuildDefinitionForBuild buildDefinitionForBuild = chainBranch.getBuildDefinitionXml();
            BuildConfiguration hierarchicalConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
            this.addBuildConfiguration((com.atlassian.bamboo.plan.Plan)chainBranch, hierarchicalConfiguration, (AbstractPlanProperties)planProperties);
            buildDefinitionForBuild.setXmlData(hierarchicalConfiguration.asXml());
            chainBranch.setBuildDefinitionXml(buildDefinitionForBuild);
            List<PartialVcsRepositoryData> planRepositories = this.validateAndCreateBranchRepositories(existingChain, (ChainBranch)chainBranch, vcsBranch, planProperties.getRepositories(), planProperties.getRepositoryBranches());
            this.deletionService.deletePlansIgnoringBranches(operations.getJobsToRemove());
            this.deletionService.deleteStagesIgnoringBranchesAndJobs(operations.getStagesToRemove());
            this.planManager.savePlan((com.atlassian.bamboo.plan.Plan)chainBranch);
            this.variableConfigurationService.setPlanVariables((Chain)chainBranch, planProperties.getVariables());
            this.createAndUpdateArtifactDefinitions((AbstractChain)chainBranch, planProperties);
            this.createPlanRepositories((com.atlassian.bamboo.plan.Plan)chainBranch, planRepositories);
            this.createTasks((AbstractChain)chainBranch, planProperties, vcsBranch);
            this.createTriggers((AbstractChain)chainBranch, planProperties);
            this.createAndUpdateLabels((Chain)chainBranch, planProperties);
            return chainBranch;
        };
    }

    private void setBranchSpecificConfiguration(@NotNull PlanProperties planProperties, @NotNull Chain topLevelChain, @NotNull ChainBranch chainBranch, BuildDefinition buildDefinition) {
        BranchIntegrationProperties branchIntegrationProperties;
        PlanBranchConfigurationProperties planBranchConfiguration = planProperties.getPlanBranchConfiguration();
        BranchIntegrationProperties branchIntegrationProperties2 = branchIntegrationProperties = planBranchConfiguration != null ? planBranchConfiguration.getBranchIntegrationProperties() : null;
        if (branchIntegrationProperties != null) {
            Object branchIntegrationConfiguration = branchIntegrationProperties.isEnabled() ? this.getBranchIntegrationConfiguration(chainBranch.getPlanKey(), topLevelChain, buildDefinition.getBranchSpecificConfiguration().getPlanBranchWorkflow(), branchIntegrationProperties, false) : new BranchIntegrationConfigurationImpl();
            buildDefinition.setBranchIntegrationConfiguration((BranchIntegrationConfiguration)branchIntegrationConfiguration);
        }
        buildDefinition.getBranchSpecificConfiguration().setBranchCleanupDisabled(planBranchConfiguration != null ? !planBranchConfiguration.isCleanupEnabled() : false);
        buildDefinition.getBranchSpecificConfiguration().setIgnoreSpecs(false);
    }

    private void addForceStopBuildConfiguration(@NotNull PlanProperties planProperties, BuildDefinition buildDefinition) {
        Map customConfiguration = buildDefinition.getCustomConfiguration();
        if (planProperties.getForceStopHungBuilds() == null) {
            customConfiguration.remove("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled");
        } else {
            customConfiguration.put("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", Boolean.toString(planProperties.getForceStopHungBuilds()));
        }
        buildDefinition.setCustomConfiguration(customConfiguration);
    }

    private void setBambooSpecsData(PlanProperties planProperties, AbstractChain chain) {
        RepositoryStoredSpecsData repositoryStoredSpecsData = planProperties.getRepositoryStoredSpecsData();
        if (repositoryStoredSpecsData == null) {
            if (chain.getVcsBambooSpecsSource() != null) {
                log.info((Object)("Detaching RSS-managed plan " + chain.getPlanKey() + " from RSS"));
            }
            chain.setVcsBambooSpecsSource(null);
            return;
        }
        Optional maybeCurrentSpecsSource = this.bambooSpecsManager.findSourceById(repositoryStoredSpecsData.getSpecsSourceId());
        if (!maybeCurrentSpecsSource.isPresent()) {
            throw new IllegalStateException("Specs source " + repositoryStoredSpecsData.getSpecsSourceId() + " not found");
        }
        chain.setVcsBambooSpecsSource((VcsBambooSpecsSourceImpl)maybeCurrentSpecsSource.get());
    }

    private void modifyStagesAndJobs(Chain chainOrBranch, PlanProperties planProperties, OperationsRegister operations) throws PropertiesValidationException {
        List originalStages = chainOrBranch.getStages();
        List originalJobs = chainOrBranch.getAllJobs();
        HashSet<Long> notDeletedJobs = new HashSet<Long>();
        HashSet<Long> notDeletedStages = new HashSet<Long>();
        ArrayList<ChainStage> newStagesList = new ArrayList<ChainStage>();
        for (StageProperties stageProperties : planProperties.getStages()) {
            Optional<ChainStage> existingStage = this.findStageByOidOrName(originalStages, stageProperties);
            if (existingStage.isPresent()) {
                ChainStage stage = existingStage.get();
                this.setStageProperties(stageProperties, stage);
                newStagesList.add(stage);
                notDeletedStages.add(stage.getId());
                this.updateJobList(chainOrBranch, originalJobs, notDeletedJobs, stageProperties, stage, operations);
                continue;
            }
            ChainStage newStage = this.createStageInstance(chainOrBranch, stageProperties);
            newStagesList.add(newStage);
            this.updateJobList(chainOrBranch, originalJobs, notDeletedJobs, stageProperties, newStage, operations);
        }
        originalJobs.stream().filter(j -> !notDeletedJobs.contains(j.getId())).forEach(j -> operations.getJobsToRemove().add((Job)j));
        chainOrBranch.removeStagesIf(chainStage -> !chainStage.isMarkedForDeletion());
        newStagesList.forEach(arg_0 -> ((Chain)chainOrBranch).addStage(arg_0));
        originalStages.stream().filter(s -> !notDeletedStages.contains(s.getId())).forEach(s -> {
            operations.getStagesToRemove().add((ChainStage)s);
            chainOrBranch.addStage(s);
        });
    }

    private void setStageProperties(StageProperties stageProperties, ChainStage stage) {
        stage.setName(stageProperties.getName());
        stage.setDescription(stageProperties.getDescription());
        stage.setFinal(stageProperties.isFinalStage());
        stage.setManual(stageProperties.isManual());
    }

    private void updateJobList(Chain topLevelPlan, List<Job> originalJobs, Set<Long> notDeletedJobs, StageProperties stageProperties, ChainStage stage, OperationsRegister operations) throws PropertiesValidationException {
        for (JobProperties jobProperties : stageProperties.getJobs()) {
            Optional<Job> existingJob = JobImportHelper.findPlanByKey(originalJobs, jobProperties.toPlanIdentifier());
            if (existingJob.isPresent()) {
                Job job = existingJob.get();
                operations.getPlanKeyChanges().put(job.getPlanKey(), PlanKeys.getJobKey((PlanKey)topLevelPlan.getPlanKey(), (String)jobProperties.getKey().getKey()));
                notDeletedJobs.add(job.getId());
                job.getStage().removeJob(job);
                job.setStage(stage);
                stage.addJob(job);
                this.modifyJob(topLevelPlan, job, jobProperties);
                continue;
            }
            this.createJob(topLevelPlan, stage, jobProperties);
        }
    }

    @NotNull
    private TopLevelPlan createNewTopLevelPlan(@NotNull PlanProperties planProperties, Project project, User userForCreation) {
        PlanKey chainKey = PlanKeys.getPlanKey((String)project.getKey(), (String)planProperties.getKey().getKey());
        Either result = this.scopedExclusionService.tryWithLock((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)chainKey, this.createTopLevelPlanFunction(planProperties, project, chainKey, userForCreation));
        if (result.isRight()) {
            Preconditions.checkState((boolean)((Optional)result.right().get()).isPresent());
            TopLevelPlan plan = (TopLevelPlan)((Optional)result.right().get()).get();
            this.eventPublisher.publish((Object)new BambooSpecPlanEvent(plan.getPlanKey().getKey().hashCode(), true));
            return plan;
        }
        throw new IllegalStateException("Could not create chain with key " + chainKey + " as it is already being created");
    }

    @NotNull
    private ScopedExclusionService.ExclusiveFunction<PlanKey, TopLevelPlan, RuntimeException> createTopLevelPlanFunction(@NotNull PlanProperties planProperties, Project project, PlanKey chainKey, User userForCreation) {
        return key -> {
            boolean validationFailed = false;
            String message = "";
            if (this.planManager.isPlanKeyConflicting(chainKey)) {
                validationFailed = true;
                message = message + "Duplicate chain key" + chainKey + ". ";
            }
            if (this.planManager.isChainNameConflicting(project.getKey(), -1L, planProperties.getName())) {
                validationFailed = true;
                message = message + "Duplicate chain name " + planProperties.getName() + ".";
            }
            if (validationFailed) {
                throw new IllegalArgumentException(message);
            }
            this.validationService.validateStageNamesUnique(planProperties);
            this.validationService.validateJobKeysAndNames(chainKey, planProperties);
            LicenseValidator.validateJobsLimit(null, planProperties, this.bambooLicenseManager.getAllowedNumberOfPlans(), this.planManager.getPlanCount(Buildable.class));
            this.validationService.validatePlanVariables(planProperties.getVariables());
            this.validationService.validateForceStopBuild(planProperties, chainKey, planProperties.getForceStopHungBuilds());
            DefaultChain topLevelPlan = new DefaultChain();
            topLevelPlan.setProject(project);
            if (planProperties.getOid() != null) {
                topLevelPlan.setOid(BambooEntityOid.createFromExternalValue((String)planProperties.getOid().getOid()));
            }
            topLevelPlan.setBuildName(planProperties.getName());
            topLevelPlan.setPlanKey(chainKey);
            topLevelPlan.setBuildKey(planProperties.getKey().getKey());
            topLevelPlan.setDescription(planProperties.getDescription());
            topLevelPlan.setSuspendedFromBuilding(!planProperties.isEnabled());
            topLevelPlan.setBuildDefinitionManager(this.buildDefinitionManager);
            topLevelPlan.setVariableDefinitionManager(this.variableDefinitionManager);
            topLevelPlan.setRepositoryDefinitionManager(this.repositoryDefinitionManager);
            this.updateNotificationSet((AbstractChain)topLevelPlan, planProperties);
            this.setBambooSpecsData(planProperties, (AbstractChain)topLevelPlan);
            try {
                for (StageProperties stageProperties : planProperties.getStages()) {
                    this.createAndAppendStage((Chain)topLevelPlan, stageProperties);
                }
            }
            catch (PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
            DefaultBuildDefinition buildDefinition = new DefaultBuildDefinition(false);
            this.addForceStopBuildConfiguration(planProperties, (BuildDefinition)buildDefinition);
            this.chainDependenciesExporter.validateDependencies(topLevelPlan, planProperties.getDependenciesProperties());
            this.chainDependenciesExporter.importDependenciesConfiguration((BuildDefinition)buildDefinition, planProperties.getDependenciesProperties());
            DefaultBuildDefinitionForBuild buildDefinitionForBuild = new DefaultBuildDefinitionForBuild(false);
            BuildConfiguration configuration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
            this.addBuildConfiguration((com.atlassian.bamboo.plan.Plan)topLevelPlan, configuration, (AbstractPlanProperties)planProperties);
            buildDefinitionForBuild.setXmlData(configuration.asXml());
            topLevelPlan.setBuildDefinitionXml((BuildDefinitionForBuild)buildDefinitionForBuild);
            MutableAcl acl = this.getDefaultPermissionsForPlan(userForCreation);
            List<PartialVcsRepositoryData> planRepositories = this.validateAndCreateRepositoryObjects((com.atlassian.bamboo.plan.Plan)topLevelPlan, planProperties.getRepositories(), planProperties.getRepositoryBranches());
            this.planManager.createPlan((com.atlassian.bamboo.plan.Plan)topLevelPlan);
            ((HibernateAcl)acl).setObjectIdentity((ObjectIdentity)new HibernateObjectIdentityImpl((Object)topLevelPlan));
            this.aclService.updateAcl(acl);
            this.variableConfigurationService.setPlanVariables((Chain)topLevelPlan, planProperties.getVariables());
            this.createAndUpdateArtifactDefinitions((AbstractChain)topLevelPlan, planProperties);
            this.createPlanRepositories((com.atlassian.bamboo.plan.Plan)topLevelPlan, planRepositories);
            this.createTasks((AbstractChain)topLevelPlan, planProperties, null);
            this.createTriggers((AbstractChain)topLevelPlan, planProperties);
            this.createAndUpdateLabels((Chain)topLevelPlan, planProperties);
            this.addBranchMonitoringOptions((TopLevelPlan)topLevelPlan, planProperties.getPlanBranchManagementProperties());
            this.chainDependenciesExporter.importDependencies(topLevelPlan, (BuildDefinition)buildDefinition, planProperties.getDependenciesProperties());
            this.performPostCreationActions((AbstractChain)topLevelPlan);
            return topLevelPlan;
        };
    }

    private void updateNotificationSet(@NotNull AbstractChain chain, @NotNull PlanProperties planProperties) {
        NotificationSet notificationSet = chain.getNotificationSet() != null ? chain.getNotificationSet() : new NotificationSetImpl();
        chain.setNotificationSet(notificationSet);
        this.notificationExporter.updateNotificationSet(notificationSet, planProperties.getNotifications(), (EntityProperties)planProperties);
    }

    private void createTriggers(AbstractChain topLevelPlan, PlanProperties planProperties) {
        ArrayList<TriggerDefinition> triggerDefinitions = new ArrayList<TriggerDefinition>();
        for (TriggerProperties triggerProperty : planProperties.getTriggers()) {
            TriggerDefinition triggerDefinition = this.triggerDefinitionExportHelper.importTriggerDefinition(triggerDefinitions.size() + 1, (Triggerable)topLevelPlan, triggerProperty);
            triggerDefinitions.add(triggerDefinition);
        }
        BuildDefinition buildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(topLevelPlan.getPlanKey());
        buildDefinition.setTriggerDefinitions(triggerDefinitions);
        this.buildDefinitionManager.savePlanAndDefinition((com.atlassian.bamboo.plan.Plan)topLevelPlan, buildDefinition, false);
    }

    private void createAndUpdateLabels(@NotNull Chain chain, @NotNull PlanProperties planProperties) {
        List labels = planProperties.getLabels();
        if (!labels.isEmpty()) {
            if (labels.size() == 1 && labels.get(0) instanceof EmptyLabelsListProperties) {
                this.eventPublisher.publish((Object)new SpecsExplicitDeletionEvent(EmptyLabelsList.class.getSimpleName()));
                this.labelManager.getPlanLabels((ImmutablePlan)chain).forEach(label -> this.labelManager.removeLabel(label.getName(), chain.getPlanKey(), null));
            } else {
                Set expectedLabels = labels.stream().map(LabelProperties::getName).collect(Collectors.toSet());
                Set currentLabels = this.labelManager.getPlanLabels((ImmutablePlan)chain).stream().map(Label::getName).collect(Collectors.toSet());
                Sets.SetView labelsToDelete = Sets.difference(currentLabels, expectedLabels);
                Sets.SetView labelsToAdd = Sets.difference(expectedLabels, currentLabels);
                labelsToDelete.forEach(label -> this.labelManager.removeLabel(label, chain.getPlanKey(), null));
                labelsToAdd.forEach(label -> this.labelManager.addLabel(label, chain.getPlanKey(), null));
            }
        }
    }

    private List<PartialVcsRepositoryData> validateAndCreateRepositoryObjects(@NotNull com.atlassian.bamboo.plan.Plan plan, @NotNull List<PlanRepositoryLinkProperties> repositoryPropertiesList, @NotNull List<VcsRepositoryBranchProperties> repositoryBranches) {
        Map branchOverrides = repositoryBranches.stream().collect(Collectors.toMap(VcsRepositoryBranchProperties::getRepositoryName, UnaryOperator.identity()));
        VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForPlan((ImmutablePlan)plan);
        return (List)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
            try {
                ArrayList<PartialVcsRepositoryData> planRepositoryDataList = new ArrayList<PartialVcsRepositoryData>();
                for (PlanRepositoryLinkProperties repositoryProperties : repositoryPropertiesList) {
                    VcsRepositoryData existingRepositoryData = this.getExistingVcsRepositoryData(plan, repositoryProperties.getRepositoryDefinition());
                    VcsRepositoryContext repositoryContext = VcsRepositoryContextImpl.builder().withOwnerPlan((ImmutablePlan)plan).build();
                    PartialVcsRepositoryData repositoryData = this.repositoryExporter.importRepository(repositoryProperties.getRepositoryDefinition(), existingRepositoryData, null, false, (VcsRepositoryBranchProperties)branchOverrides.get(this.getRepositoryName(repositoryProperties)), repositoryContext);
                    this.repositoryConfigurationService.validatePlanRepository(plan, repositoryData);
                    planRepositoryDataList.add(repositoryData);
                }
                if (!planRepositoryDataList.isEmpty()) {
                    PartialVcsRepositoryData defaultRepository = (PartialVcsRepositoryData)planRepositoryDataList.get(0);
                    PlanBranchWorkflow planBranchWorkflow = plan.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow();
                    this.validationService.validateRepositorySupportsPlanBranchWorkflow((PluginKeyProvider)defaultRepository, planBranchWorkflow);
                    this.validationService.validateChangingRepositoryOrder(plan, PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)plan), defaultRepository);
                }
                return planRepositoryDataList;
            }
            catch (YamlValidationException | PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    private List<PartialVcsRepositoryData> validateAndCreateBranchRepositories(@NotNull Chain masterPlan, @NotNull ChainBranch branch, @NotNull VcsBranch vcsBranch, @NotNull List<PlanRepositoryLinkProperties> repositoryPropertiesList, @NotNull List<VcsRepositoryBranchProperties> repositoryBranches) {
        Map branchOverrides = repositoryBranches.stream().collect(Collectors.toMap(VcsRepositoryBranchProperties::getRepositoryName, UnaryOperator.identity()));
        Map planRepositoryPropertiesMap = repositoryPropertiesList.stream().collect(Collectors.toMap(this::getRepositoryName, UnaryOperator.identity()));
        VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForPlan((ImmutablePlan)branch);
        return (List)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
            try {
                PartialVcsRepositoryData repositoryData;
                VcsRepositoryContext repositoryContext;
                VcsRepositoryData existingRepositoryData;
                List planRepositoryDefinitions = this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)masterPlan);
                ArrayList<PartialVcsRepositoryData> planRepositoryDataList = new ArrayList<PartialVcsRepositoryData>();
                if (!planRepositoryDefinitions.isEmpty()) {
                    PlanRepositoryDefinition firstRepo = (PlanRepositoryDefinition)planRepositoryDefinitions.get(0);
                    String repositoryName = firstRepo.getName();
                    planRepositoryPropertiesMap.remove(repositoryName);
                    branchOverrides.remove(repositoryName);
                    PlanRepositoryLinkProperties repositoryProperties = (PlanRepositoryLinkProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)PlanRepositoryLink.linkToGlobalRepository((VcsRepositoryIdentifier)new VcsRepositoryIdentifier(repositoryName)));
                    VcsRepositoryBranchProperties branchProperties = (VcsRepositoryBranchProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new VcsRepositoryBranch(repositoryName, vcsBranch.getName()).branchDisplayName(vcsBranch.getDisplayName() != null ? vcsBranch.getDisplayName() : vcsBranch.getName()));
                    existingRepositoryData = this.getExistingVcsRepositoryData((com.atlassian.bamboo.plan.Plan)branch, repositoryName);
                    repositoryContext = VcsRepositoryContextImpl.builder().withOwnerPlan((ImmutablePlan)masterPlan).build();
                    repositoryData = this.repositoryExporter.importRepository(repositoryProperties.getRepositoryDefinition(), existingRepositoryData, (VcsRepositoryData)firstRepo, false, branchProperties, repositoryContext);
                    this.repositoryConfigurationService.validatePlanRepository((com.atlassian.bamboo.plan.Plan)branch, repositoryData);
                    planRepositoryDataList.add(repositoryData);
                }
                for (PlanRepositoryDefinition repositoryOfMaster : Iterables.skip((Iterable)planRepositoryDefinitions, (int)1)) {
                    String repositoryName = repositoryOfMaster.getName();
                    PlanRepositoryLinkProperties repositoryProperties = planRepositoryPropertiesMap.containsKey(repositoryName) ? (PlanRepositoryLinkProperties)planRepositoryPropertiesMap.remove(repositoryName) : (PlanRepositoryLinkProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)PlanRepositoryLink.linkToGlobalRepository((VcsRepositoryIdentifier)new VcsRepositoryIdentifier(repositoryName)));
                    existingRepositoryData = this.getExistingVcsRepositoryData((com.atlassian.bamboo.plan.Plan)branch, repositoryName);
                    repositoryContext = VcsRepositoryContextImpl.builder().withOwnerPlan((ImmutablePlan)masterPlan).build();
                    repositoryData = this.repositoryExporter.importRepository(repositoryProperties.getRepositoryDefinition(), existingRepositoryData, (VcsRepositoryData)repositoryOfMaster, false, (VcsRepositoryBranchProperties)branchOverrides.remove(this.getRepositoryName(repositoryProperties)), repositoryContext);
                    this.repositoryConfigurationService.validatePlanRepository((com.atlassian.bamboo.plan.Plan)branch, repositoryData);
                    planRepositoryDataList.add(repositoryData);
                }
                if (!planRepositoryPropertiesMap.isEmpty()) {
                    throw new IllegalArgumentException("Found repository definitions that are not existent on master plan");
                }
                if (!branchOverrides.isEmpty()) {
                    throw new IllegalArgumentException("Found branch overrides for repositories that are not linked to master plan");
                }
                return planRepositoryDataList;
            }
            catch (YamlValidationException | PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    @NotNull
    private String getRepositoryName(PlanRepositoryLinkProperties repositoryProperties) {
        return BambooStringUtils.firstNotBlank((String[])new String[]{repositoryProperties.getRepositoryDefinition().getName(), repositoryProperties.getRepositoryDefinition().getParentName()});
    }

    private VcsRepositoryData getExistingVcsRepositoryData(com.atlassian.bamboo.plan.Plan plan, String repositoryName) {
        List existingPlanRepositories = this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)plan);
        return existingPlanRepositories.stream().filter(r -> r.getName().equals(repositoryName)).findFirst().orElse(null);
    }

    private VcsRepositoryData getExistingVcsRepositoryData(com.atlassian.bamboo.plan.Plan plan, VcsRepositoryProperties repositoryProperties) {
        List existingPlanRepositories = this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)plan);
        if (repositoryProperties.getOid() != null) {
            BambooEntityOid oid = repositoryProperties.getOid() != null ? BambooEntityOid.createFromExternalValue((String)repositoryProperties.getOid().getOid()) : null;
            return existingPlanRepositories.stream().filter(r -> r.getOid().equals((Object)oid)).findFirst().orElse(null);
        }
        return existingPlanRepositories.stream().filter(r -> r.getName().equals(repositoryProperties.getName()) || r.getName().equals(repositoryProperties.getParentName())).findFirst().orElse(null);
    }

    private void createPlanRepositories(@NotNull com.atlassian.bamboo.plan.Plan plan, @NotNull List<PartialVcsRepositoryData> planRepositoryDataList) {
        this.repositoryConfigurationService.mergePlanRepositories(plan, planRepositoryDataList);
    }

    private void createAndUpdateArtifactDefinitions(AbstractChain topLevelPlan, PlanProperties planProperties) {
        this.createAndUpdateArtifactDefinitions(topLevelPlan, planProperties, true);
    }

    private void createAndUpdateArtifactDefinitions(AbstractChain topLevelPlan, PlanProperties planProperties, boolean fireEvent) {
        HashMap sharedArtifacts = new HashMap();
        for (StageProperties stage : planProperties.getStages()) {
            for (JobProperties jobProperties : stage.getJobs()) {
                Job job = JobImportHelper.findJobByKeyExpectingSuccess(topLevelPlan, jobProperties.toPlanIdentifier());
                Map existingArtifacts = (Map)this.artifactDefinitionDao.findByProducer((ImmutablePlan)job).stream().collect(BambooCollectors.toHashMap(ImmutableArtifactDefinitionBase::getName));
                ArrayList<ArtifactDefinitionImpl> artifactDefinitions = new ArrayList<ArtifactDefinitionImpl>();
                if (!CollectionUtils.isEmpty((Collection)jobProperties.getArtifacts())) {
                    for (ArtifactProperties a : jobProperties.getArtifacts()) {
                        ArtifactDefinitionImpl artifactDefinition;
                        if (existingArtifacts.containsKey(a.getName())) {
                            artifactDefinition = (ArtifactDefinitionImpl)existingArtifacts.get(a.getName());
                            existingArtifacts.remove(a.getName());
                            artifactDefinition.setLocation(a.getLocation());
                            artifactDefinition.setCopyPattern(a.getCopyPattern());
                        } else {
                            artifactDefinition = new ArtifactDefinitionImpl(job, a.getName(), a.getLocation(), a.getCopyPattern());
                        }
                        artifactDefinition.setSharedArtifact(a.isShared());
                        artifactDefinition.setRequired(a.isRequired());
                        artifactDefinitions.add(artifactDefinition);
                        List<ArtifactSubscription> artifactSubscriptions = this.createSubscriptions(topLevelPlan, planProperties, artifactDefinition);
                        artifactDefinition.getSubscriptions().clear();
                        if (!artifactDefinition.isSharedArtifact()) continue;
                        artifactDefinition.getSubscriptions().addAll(artifactSubscriptions);
                    }
                }
                this.artifactDefinitionDao.deleteAll(existingArtifacts.values());
                if (!artifactDefinitions.isEmpty()) {
                    this.artifactDefinitionDao.saveAll(artifactDefinitions);
                }
                artifactDefinitions.stream().filter(ImmutableArtifactDefinitionBase::isSharedArtifact).forEach(sa -> sharedArtifacts.put(sa.getId(), sa));
            }
        }
        if (fireEvent) {
            this.eventPublisher.publish((Object)new PlanSharedArtifactDefinitionListModified((Object)this, topLevelPlan.getPlanKey(), sharedArtifacts));
        }
    }

    @NotNull
    private List<ArtifactSubscription> createSubscriptions(AbstractChain topLevelPlan, PlanProperties planProperties, ArtifactDefinitionImpl artifactDefinition) {
        ArrayList<ArtifactSubscription> artifactSubscriptions = new ArrayList<ArtifactSubscription>();
        for (StageProperties stage : planProperties.getStages()) {
            for (JobProperties jobProperties : stage.getJobs()) {
                jobProperties.getArtifactSubscriptions().stream().filter(asp -> asp.getArtifactName().equals(artifactDefinition.getName())).forEach(asp -> {
                    Job consumerJob = JobImportHelper.findJobByKeyExpectingSuccess(topLevelPlan, jobProperties.toPlanIdentifier());
                    ArtifactSubscriptionImpl artifactSubscription = new ArtifactSubscriptionImpl((ArtifactDefinition)artifactDefinition, consumerJob, asp.getDestination());
                    artifactSubscriptions.add((ArtifactSubscription)artifactSubscription);
                });
            }
        }
        return artifactSubscriptions;
    }

    private void createTasks(AbstractChain topLevelPlan, PlanProperties planProperties, VcsBranch importedBranch) {
        for (StageProperties stageProperties : planProperties.getStages()) {
            for (JobProperties jobProperties : stageProperties.getJobs()) {
                DefaultJob job = (DefaultJob)JobImportHelper.findJobByKeyExpectingSuccess(topLevelPlan, jobProperties.toPlanIdentifier());
                ArrayList taskDefinitions = new ArrayList();
                BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((com.atlassian.bamboo.plan.Plan)job);
                jobProperties.getTasks().forEach(taskProperties -> this.importTaskProperties(job, taskDefinitions, (TaskProperties)taskProperties, importedBranch, false));
                jobProperties.getFinalTasks().forEach(taskProperties -> this.importTaskProperties(job, taskDefinitions, (TaskProperties)taskProperties, importedBranch, true));
                buildDefinition.setTaskDefinitions(taskDefinitions);
                BuildDefinitionForBuild buildDefinitionForBuild = job.getBuildDefinitionXml();
                buildDefinitionForBuild.setXmlData(ConfigUtils.asXmlString((XMLConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition)));
                job.setBuildDefinitionXml(buildDefinitionForBuild);
                this.planManager.savePlan((com.atlassian.bamboo.plan.Plan)job);
            }
        }
    }

    private void importTaskProperties(DefaultJob job, List<TaskDefinition> taskDefinitions, TaskProperties taskProperties, VcsBranch importedBranch, boolean finalTask) {
        try {
            TaskDefinition taskDefinition = this.taskDefinitionExportHelper.importTaskDefinition(taskDefinitions.size() + 1, (TaskContainer)job, taskDefinitions, taskProperties, importedBranch, finalTask);
            taskDefinitions.add(taskDefinition);
            this.taskManager.calculateRequirementsForTaskDefinition((Job)job, taskDefinition);
        }
        catch (PropertiesValidationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private Optional<ChainStage> findStageByOidOrName(List<ChainStage> stages, StageProperties stageProperties) {
        return stages.stream().filter(s -> s.getName().equals(stageProperties.getName())).findFirst();
    }

    private void addBuildConfiguration(com.atlassian.bamboo.plan.Plan plan, BuildConfiguration buildConfiguration, AbstractPlanProperties planProperties) {
        List pluginConfigurations = planProperties.getPluginConfigurations();
        if (plan instanceof ImmutableChainBranch) {
            buildConfiguration.setProperty("branchConfiguration.awating.specs.execution", (Object)false);
        }
        for (PluginConfigurationProperties pluginConfigurationProperties : pluginConfigurations) {
            String moduleKey = pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey();
            if ("com.atlassian.bamboo:#allotherplugins".equals(moduleKey)) {
                AllOtherPluginsConfigurationProperties allOtherPluginsConfigurationProperties = (AllOtherPluginsConfigurationProperties)Narrow.downTo((Object)pluginConfigurationProperties, AllOtherPluginsConfigurationProperties.class);
                this.hierarchicalConfigurationExporter.addDataMapToConfiguration((HierarchicalConfiguration)buildConfiguration, allOtherPluginsConfigurationProperties.getConfiguration());
                continue;
            }
            ModuleDescriptor plugin = this.pluginAccessor.getEnabledPluginModule(moduleKey);
            if (plugin == null) {
                throw new PropertiesValidationException("Plugin " + moduleKey + " is not installed or is disabled");
            }
            ImportExportAwarePlugin importExportAwarePlugin = (ImportExportAwarePlugin)Narrow.downTo((Object)plugin.getModule(), ImportExportAwarePlugin.class);
            if (importExportAwarePlugin == null) {
                throw new PropertiesValidationException("Plugin " + moduleKey + " does not support import");
            }
            importExportAwarePlugin.addToBuildConfiguration(pluginConfigurationProperties, (HierarchicalConfiguration)buildConfiguration);
        }
        BuildConfigurationPluginsExportHelper.addDefaultValues(this.pluginAccessor, plan, buildConfiguration);
    }

    private void addBuildConfiguration(Job job, BuildConfiguration buildConfiguration, JobProperties jobProperties) {
        this.addBuildConfiguration((com.atlassian.bamboo.plan.Plan)job, buildConfiguration, (AbstractPlanProperties)jobProperties);
        buildConfiguration.setProperty("cleanWorkingDirectory", (Object)jobProperties.isCleanWorkingDirectory());
        DockerPipelineConfiguration dockerPipelineConfiguration = DockerPipelineExportHelper.fromSpecsEntity(jobProperties.getDockerConfiguration());
        ErrorCollection dockerErrors = this.dockerPipelineValidationService.validateDockerPipelineConfiguration(dockerPipelineConfiguration);
        ImporterUtils.checkNoErrors(ValidationProblemUtils.fromErrorCollection(dockerErrors));
        buildConfiguration.clearTree(DockerPipelineConfigurationImpl.CONFIG_FIELD_PREFIX);
        ConfigUtils.copyNodes((HierarchicalConfiguration)dockerPipelineConfiguration.toConfiguration(), (HierarchicalConfiguration)buildConfiguration.getProjectConfig());
    }

    private void addBranchMonitoringOptions(TopLevelPlan topLevelPlan, PlanBranchManagementProperties planBranchManagementProperties) {
        PlanBranchWorkflow planBranchWorkflow;
        BranchMonitoringConfigurationImpl branchMonitoringConfiguration = new BranchMonitoringConfigurationImpl();
        CreatePlanBranchesProperties.Trigger trigger = planBranchManagementProperties.getCreatePlanBranch().getTrigger();
        switch (trigger) {
            case BRANCH: {
                planBranchWorkflow = PlanBranchWorkflow.BRANCH_WORKFLOW;
                break;
            }
            case MANUAL: {
                planBranchWorkflow = PlanBranchWorkflow.MANUAL_WORKFLOW;
                break;
            }
            case PULL_REQUEST: {
                planBranchWorkflow = PlanBranchWorkflow.PULL_REQUEST_WORKFLOW;
                break;
            }
            default: {
                planBranchWorkflow = PlanBranchWorkflow.defaultValue();
            }
        }
        branchMonitoringConfiguration.setPlanBranchWorkflow(planBranchWorkflow);
        branchMonitoringConfiguration.setMatchingPattern(planBranchManagementProperties.getCreatePlanBranch().getMatchingPattern());
        branchMonitoringConfiguration.setInactiveBranchCleanUpEnabled(planBranchManagementProperties.getDeletePlanBranch().isRemoveInactiveInRepository());
        branchMonitoringConfiguration.setInactiveBranchCleanUpPeriodInDays((int)planBranchManagementProperties.getDeletePlanBranch().getRemoveInactiveInRepositoryPeriod().toDays());
        branchMonitoringConfiguration.setRemovedBranchCleanUpEnabled(planBranchManagementProperties.getDeletePlanBranch().isRemoveDeletedFromRepository());
        branchMonitoringConfiguration.setRemovedBranchCleanUpPeriodInDays((int)planBranchManagementProperties.getDeletePlanBranch().getRemoveDeletedFromRepositoryPeriod().toDays());
        branchMonitoringConfiguration.setBranchTriggeringOption(BranchTriggeringOption.fromSpecsConstant((PlanBranchManagementProperties.TriggeringOption)planBranchManagementProperties.getTriggeringOption()));
        if (planBranchManagementProperties.getDefaultTrigger() != null) {
            branchMonitoringConfiguration.setDefaultTrigger(this.triggerDefinitionExportHelper.importTriggerDefinition(1L, (Triggerable)topLevelPlan, planBranchManagementProperties.getDefaultTrigger()));
        }
        branchMonitoringConfiguration.setDefaultBranchNotificationStrategy(BranchNotificationStrategy.fromSpecsConstant((PlanBranchManagementProperties.NotificationStrategy)planBranchManagementProperties.getNotificationStrategy()));
        branchMonitoringConfiguration.setRemoteJiraBranchLinkingEnabled(planBranchManagementProperties.isIssueLinkingEnabled());
        BranchIntegrationProperties branchIntegrationProperties = planBranchManagementProperties.getBranchIntegrationProperties();
        if (branchIntegrationProperties != null && branchIntegrationProperties.isEnabled()) {
            BranchIntegrationConfiguration branchIntegrationConfiguration = this.getBranchIntegrationConfiguration(null, (Chain)topLevelPlan, planBranchWorkflow, branchIntegrationProperties, true);
            branchMonitoringConfiguration.setDefaultBranchIntegrationConfiguration(branchIntegrationConfiguration);
        }
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((com.atlassian.bamboo.plan.Plan)topLevelPlan);
        buildDefinition.setBranchMonitoringConfiguration((BranchMonitoringConfiguration)branchMonitoringConfiguration);
        this.buildDefinitionManager.savePlanAndDefinition((com.atlassian.bamboo.plan.Plan)topLevelPlan, buildDefinition, false);
    }

    @NotNull
    private BranchIntegrationConfiguration getBranchIntegrationConfiguration(@Nullable PlanKey chainBranchKey, Chain topLevelPlan, PlanBranchWorkflow planBranchWorkflow, BranchIntegrationProperties branchIntegrationProperties, boolean isDefaultConfiguration) {
        BranchIntegrationPointImpl branchIntegrationPoint;
        switch (planBranchWorkflow) {
            case BRANCH_WORKFLOW: 
            case MANUAL_WORKFLOW: {
                List existingChainBranches = this.chainBranchManager.getBranchesForChain((ImmutableChain)topLevelPlan);
                Optional<PlanKey> integrationBranchKey = this.findIntegrationBranchKey(branchIntegrationProperties.getIntegrationBranch(), topLevelPlan, existingChainBranches);
                if (integrationBranchKey.isPresent()) {
                    PlanKey branchKey = integrationBranchKey.get();
                    if (Objects.equals(chainBranchKey, branchKey)) {
                        branchIntegrationPoint = BranchIntegrationPointImpl.forPlanBranch((PlanKey)topLevelPlan.getPlanKey());
                        break;
                    }
                    branchIntegrationPoint = BranchIntegrationPointImpl.forPlanBranch((PlanKey)branchKey);
                    break;
                }
                throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(PlanConfigImportValidationService.PLAN_BRANCH_WORKFLOW_VALIDATION_CONTEXT, "Integration branch not found. Can't enable integration configuration.")));
            }
            case PULL_REQUEST_WORKFLOW: {
                branchIntegrationPoint = BranchIntegrationPointImpl.forPlanBranch((PlanKey)topLevelPlan.getPlanKey());
                break;
            }
            default: {
                throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(PlanConfigImportValidationService.PLAN_BRANCH_WORKFLOW_VALIDATION_CONTEXT, "Unknown plan branch workflow: " + planBranchWorkflow)));
            }
        }
        return new BranchIntegrationConfigurationImpl(true, branchIntegrationProperties.isGatekeeper() ? BranchIntegrationStrategy.GATE_KEEPER : BranchIntegrationStrategy.BRANCH_UPDATER, (BranchIntegrationPoint)branchIntegrationPoint, branchIntegrationProperties.isPushOn(), isDefaultConfiguration);
    }

    private Optional<PlanKey> findIntegrationBranchKey(PlanBranchIdentifierProperties integrationBranch, Chain topLevelPlan, List<ChainBranch> existingChainBranches) {
        if (integrationBranch == null) {
            return Optional.of(topLevelPlan.getPlanKey());
        }
        BambooOidProperties integrationBranchOid = integrationBranch.getOid();
        if (integrationBranchOid != null && integrationBranchOid.getOid().equals(topLevelPlan.getOid().toExternalValue())) {
            return Optional.of(topLevelPlan.getPlanKey());
        }
        if (integrationBranch.isKeyDefined() && topLevelPlan.getBuildKey().equals(integrationBranch.getKey().getKey())) {
            return Optional.of(topLevelPlan.getPlanKey());
        }
        return JobImportHelper.findPlanByOidOrKey(existingChainBranches, (AbstractPlanIdentifierProperties)integrationBranch).map(PlanIdentifier::getPlanKey);
    }

    private void performPostCreationActions(AbstractChain plan) {
        BranchMonitoringConfiguration monitoringConfiguration;
        this.buildNumberGeneratorService.initBuildNumbers((PlanIdentifier)plan);
        this.planVcsRevisionHistoryService.clearRevisionHistoryForPlan(plan.getPlanKey());
        if (plan instanceof TopLevelPlan && PlanBranchWorkflow.BRANCH_WORKFLOW == (monitoringConfiguration = plan.getBuildDefinition().getBranchMonitoringConfiguration()).getPlanBranchWorkflow()) {
            this.branchCreationFacade.scheduleBranchListInitialisation((Chain)plan);
        }
    }

    @Override
    public void sendEventsAndScheduleTriggersIfRequired(@NotNull PlanConfigImportService.ImportResult importResult) {
        if (!importResult.isEventsDeferred()) {
            return;
        }
        if (importResult.isNewPlan()) {
            this.sendCreateEventsAndScheduleTriggers(importResult.getPlan());
        } else {
            this.sendUpdateEventsAndScheduleTriggers(importResult.getPlan());
        }
    }

    @Override
    public void sendEventsAndScheduleTriggersForBranchIfRequired(@NotNull PlanConfigImportService.ImportResult importResult, @Nullable User user) {
        if (!importResult.isEventsDeferred()) {
            return;
        }
        if (importResult.isNewPlan()) {
            this.sendCreateEventsAndScheduleTriggersForBranch(importResult.getPlan(), user);
        } else {
            this.sendUpdateEventsAndScheduleTriggers(importResult.getPlan());
        }
    }

    private void sendCreateEventsAndScheduleTriggers(ImmutableChain topLevelPlan) {
        this.eventPublisher.publish((Object)new ChainCreatedEvent((Object)this, topLevelPlan.getPlanKey()));
        this.eventPublisher.publish((Object)new ChainBranchConfigUpdatedEvent((Object)this, topLevelPlan.getPlanKey(), topLevelPlan.getBuildDefinition().getBranchMonitoringConfiguration()));
        this.auditLogService.log("Plan has been created.", (Key)topLevelPlan.getPlanKey(), AuditLogEntityType.PLAN);
        this.auditLogService.log("New Plan created", null, topLevelPlan.getPlanKey().toString(), null);
        this.planScheduler.scheduleTasksForPlan((ImmutablePlan)topLevelPlan);
    }

    private void sendCreateEventsAndScheduleTriggersForBranch(ImmutableChain planBranch, User user) {
        this.jiraBranchLinkingService.linkBranchToIssueIfRequiredAsync(planBranch.getPlanKey(), user != null ? user.getName() : null);
        this.eventPublisher.publish((Object)new ChainCreatedEvent((Object)this, planBranch.getPlanKey()));
        this.auditLogService.log("Plan branch has been created.", (Key)planBranch.getPlanKey(), AuditLogEntityType.PLAN);
        this.auditLogService.log("New Plan branch created", null, planBranch.getPlanKey().toString(), null);
        this.planScheduler.scheduleTasksForPlan((ImmutablePlan)planBranch);
    }

    private void scheduleBranchDetectionIfRequired(DefaultChain topLevelPlan, boolean branchDetectionOnBeforeUpdate) {
        BranchMonitoringConfiguration monitoringConfiguration = topLevelPlan.getBuildDefinition().getBranchMonitoringConfiguration();
        if (!branchDetectionOnBeforeUpdate && monitoringConfiguration.getPlanBranchWorkflow() == PlanBranchWorkflow.BRANCH_WORKFLOW) {
            this.branchCreationFacade.scheduleBranchListInitialisation((Chain)topLevelPlan);
        }
    }

    private void sendUpdateEventsAndScheduleTriggers(ImmutableChain topLevelPlan) {
        this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, topLevelPlan.getPlanKey()));
        if (!(topLevelPlan instanceof ChainBranch)) {
            this.eventPublisher.publish((Object)new ChainBranchConfigUpdatedEvent((Object)this, topLevelPlan.getPlanKey(), topLevelPlan.getBuildDefinition().getBranchMonitoringConfiguration()));
            for (ChainBranch branch : this.chainBranchManager.getBranchesForChain(topLevelPlan)) {
                this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, branch.getPlanKey()));
            }
        }
        this.planScheduler.scheduleTasksForPlanAndBranches((ImmutablePlan)topLevelPlan);
    }

    private ChainStage createStageInstance(Chain topLevelPlan, StageProperties stageProperties) {
        return new ChainStageImpl(topLevelPlan, stageProperties.getName(), stageProperties.getDescription(), stageProperties.isManual(), stageProperties.isFinalStage());
    }

    private void createAndAppendStage(Chain chainOrBranch, StageProperties stageProperties) throws PropertiesValidationException {
        ChainStage stage = this.createStageInstance(chainOrBranch, stageProperties);
        chainOrBranch.addStage(stage);
        for (JobProperties jobProperties : stageProperties.getJobs()) {
            this.createJob(chainOrBranch, stage, jobProperties);
        }
    }

    private void modifyJob(Chain chainOrBranch, Job job, JobProperties jobProperties) throws PropertiesValidationException {
        job.setPlanKey(PlanKeys.getJobKey((PlanKey)chainOrBranch.getPlanKey(), (String)jobProperties.getKey().getKey()));
        if (jobProperties.getKey() != null) {
            job.setBuildKey(jobProperties.getKey().getKey());
        }
        job.setBuildName(jobProperties.getName());
        job.setDescription(jobProperties.getDescription());
        job.setProject(chainOrBranch.getProject());
        job.setSuspendedFromBuilding(!jobProperties.isEnabled());
        RequirementSet requirementSet = job.getRequirementSet();
        requirementSet.getRequirements().clear();
        RequirementsExportHelper.addCustomRequirements(requirementSet, jobProperties.getRequirements());
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((com.atlassian.bamboo.plan.Plan)job);
        buildDefinition.getCustomConfiguration().clear();
        buildDefinition.getConfigObjects().clear();
        BuildDefinitionForBuild buildDefinitionForBuild = job.getBuildDefinitionXml();
        BuildConfiguration hierarchicalConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
        this.addBuildConfiguration(job, hierarchicalConfiguration, jobProperties);
        buildDefinitionForBuild.setXmlData(hierarchicalConfiguration.asXml());
        job.setBuildDefinitionXml(buildDefinitionForBuild);
    }

    private boolean definitionIsDefault(com.atlassian.bamboo.plan.Plan plan, BuildDefinition buildDefinition) {
        BuildConfiguration defaultHierarchicalConfiguration = new BuildConfiguration();
        BuildConfigurationPluginsExportHelper.addDefaultValues(this.pluginAccessor, plan, defaultHierarchicalConfiguration);
        Map<String, Object> defaultMap = this.hierarchicalConfigurationExporter.generateDataMap((HierarchicalConfiguration)defaultHierarchicalConfiguration);
        BuildConfiguration actualHierarchicalConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
        BuildConfigurationPluginsExportHelper.addDefaultValues(this.pluginAccessor, plan, actualHierarchicalConfiguration);
        Map<String, Object> actualMap = this.hierarchicalConfigurationExporter.generateDataMap((HierarchicalConfiguration)actualHierarchicalConfiguration);
        actualMap.remove("cleanWorkingDirectory");
        return defaultMap.equals(actualMap);
    }

    private void createJob(Chain chainOrBranch, ChainStage stage, JobProperties jobProperties) throws PropertiesValidationException {
        DefaultJob job = new DefaultJob();
        if (jobProperties.getOid() != null && !(chainOrBranch instanceof ChainBranch)) {
            job.setOid(BambooEntityOid.createFromExternalValue((String)jobProperties.getOid().getOid()));
        }
        job.setBuildDefinitionXml((BuildDefinitionForBuild)new DefaultBuildDefinitionForBuild(false));
        job.setBuildDefinitionManager(this.buildDefinitionManager);
        this.modifyJob(chainOrBranch, (Job)job, jobProperties);
        job.setStage(stage);
        stage.addJob((Job)job);
    }

    private Project findOrCreateProject(@NotNull ProjectProperties projectProperties) {
        return (Project)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.PROJECT_DATA, (Object)projectProperties.getKey().getKey(), this.findOrCreateProjectFunction(projectProperties));
    }

    private ScopedExclusionService.ExclusiveFunction<String, Project, RuntimeException> findOrCreateProjectFunction(ProjectProperties projectProperties) {
        return s -> {
            Project project = this.findProject(projectProperties);
            if (project == null) {
                Preconditions.checkArgument((projectProperties.getKey() != null ? 1 : 0) != 0, (Object)"Undefined project key");
                if (!this.bambooPermissionManager.canCreateProject()) {
                    throw new UnauthorisedException(this.textProvider.getText("rest.import.plan.no.create.permission", Collections.emptyList()));
                }
                try {
                    project = this.projectConfigurationService.createProject(projectProperties.getKey().getKey(), projectProperties.getName(), projectProperties.getDescription(), true);
                }
                catch (WebValidationException e) {
                    String errorMessage = String.join((CharSequence)", ", e.getErrorCollection().getAllErrorMessages());
                    throw new IllegalStateException(errorMessage);
                }
            }
            return project;
        };
    }

    @Nullable
    private Project findProject(ProjectProperties projectProperties) {
        Project project = null;
        if (projectProperties.getOid() != null) {
            project = this.projectManager.getProjectByOid(BambooEntityOid.createFromExternalValue((String)projectProperties.getOid().getOid()));
            if (project != null && projectProperties.getKey() != null && !project.getKey().equals(projectProperties.getKey().getKey())) {
                log.warn((Object)("Project key " + project.getKey() + " doesn't match the provided project key: " + projectProperties.getKey()));
            }
        } else if (projectProperties.getKey() != null) {
            project = this.projectManager.getProjectByKey(projectProperties.getKey().getKey());
        }
        return project;
    }

    private String toString(@NotNull ProjectProperties project) {
        if (project.getKey() != null) {
            return project.getKey().getKey();
        }
        if (project.getOid() != null) {
            return project.getOid().getOid();
        }
        return project.getName();
    }

    @NotNull
    private MutableAcl getDefaultPermissionsForPlan(@Nullable User user) {
        return this.aclUpdateHelper.createNewDefaultAcl(user, Chain.class, true);
    }

    @NotNull
    Optional<ChainBranch> findChainBranchForVcsBranch(@NotNull ImmutablePlan chain, @Nullable PlanKey planBranchKey, @NotNull VcsBranch vcsBranch) {
        if (planBranchKey != null) {
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planBranchKey);
            ImmutableChainBranch chainBranch = (ImmutableChainBranch)Narrow.downTo((Object)plan, ImmutableChainBranch.class);
            if (plan != null && chainBranch == null || chainBranch.getMaster().getId() != chain.getId()) {
                throw new PropertiesValidationException(String.format("Plan %s is not plan branch of %s", planBranchKey, chain.getPlanKey()));
            }
            return Optional.ofNullable(this.planManager.getPlanByKey(planBranchKey, ChainBranch.class));
        }
        List matchingChainBranches = this.cachedPlanManager.getBranchesOfChain(chain.getPlanKey()).filter(cb -> vcsBranch.getName().equals(ChainBranchUtils.getSubstitutedVcsBranchName((CustomVariableContext)this.customVariableContext, (ImmutablePlan)cb))).collect(Collectors.toList());
        if (matchingChainBranches.size() > 1) {
            throw new PropertiesValidationException(String.format("Ambiguous branch specification (chain key %s, branch %s)", chain.getPlanKey(), vcsBranch.getName()));
        }
        return Optional.ofNullable(Iterables.getFirst(matchingChainBranches, null)).map(cb -> (ChainBranch)this.planManager.getPlanByKey(cb.getPlanKey(), ChainBranch.class));
    }

    @Override
    @NotNull
    public PlanConfigImportService.ImportResult switchToLightweightBranch(@NotNull PlanKey planBranchKey) {
        ChainBranch chainBranch = (ChainBranch)this.planManager.getPlanByKey(planBranchKey, ChainBranch.class);
        Preconditions.checkState((chainBranch != null ? 1 : 0) != 0, (Object)("Plan " + planBranchKey + " does not exist or is not a branch"));
        if (!chainBranch.isDivergent()) {
            return new PlanConfigImportService.ImportResult((ImmutableChain)chainBranch, false, false);
        }
        Either result = this.scopedExclusionService.tryWithLock((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)chainBranch.getPlanKey(), this.switchToLightweightBranchFunction(chainBranch));
        if (result.isRight()) {
            return new PlanConfigImportService.ImportResult((ImmutableChain)((Optional)result.right().get()).get(), false, true);
        }
        throw new IllegalStateException(String.format("Could not update chain branch with key %s as it's being modified in another thread.", chainBranch.getPlanKey()));
    }

    @NotNull
    private ScopedExclusionService.ExclusiveFunction<PlanKey, ChainBranch, RuntimeException> switchToLightweightBranchFunction(@NotNull ChainBranch aChainBranch) {
        return chainKey -> {
            this.planScheduler.removeAllScheduledJobs((Triggerable)aChainBranch);
            OperationsRegister operations = new OperationsRegister();
            operations.getPlanKeyChanges().put(aChainBranch.getPlanKey(), (PlanKey)chainKey);
            ChainBranchImpl chainBranch = (ChainBranchImpl)Narrow.downTo((Object)aChainBranch, ChainBranchImpl.class);
            chainBranch.setDivergent(false);
            chainBranch.setBuildDefinitionManager(this.buildDefinitionManager);
            chainBranch.setVariableDefinitionManager(this.variableDefinitionManager);
            chainBranch.setRepositoryDefinitionManager(this.repositoryDefinitionManager);
            chainBranch.setVcsBambooSpecsSource(null);
            PlanProperties emptyProperties = (PlanProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new Plan(new com.atlassian.bamboo.specs.api.builders.project.Project().name(aChainBranch.getProject().getName()).key(aChainBranch.getProject().getKey()), aChainBranch.getBuildName(), aChainBranch.getBuildKey()));
            try {
                this.modifyStagesAndJobs((Chain)chainBranch, emptyProperties, operations);
            }
            catch (PropertiesValidationException e) {
                throw new IllegalArgumentException(e);
            }
            BuildDefinition buildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(chainBranch.getPlanKey());
            BuildDefinitionForBuild buildDefinitionForBuild = chainBranch.getBuildDefinitionXml();
            BuildConfiguration hierarchicalConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
            this.addBuildConfiguration((com.atlassian.bamboo.plan.Plan)chainBranch, hierarchicalConfiguration, (AbstractPlanProperties)emptyProperties);
            buildDefinitionForBuild.setXmlData(hierarchicalConfiguration.asXml());
            chainBranch.setBuildDefinitionXml(buildDefinitionForBuild);
            this.deletionService.deletePlansIgnoringBranches(operations.getJobsToRemove());
            this.deletionService.deleteStagesIgnoringBranchesAndJobs(operations.getStagesToRemove());
            this.planManager.savePlan((com.atlassian.bamboo.plan.Plan)chainBranch);
            this.createAndUpdateArtifactDefinitions((AbstractChain)chainBranch, emptyProperties, false);
            this.createTasks((AbstractChain)chainBranch, emptyProperties, null);
            this.eventPublisher.publish((Object)new PlanBranchResetToLightweight((Object)this, chainBranch.getPlanKey()));
            return chainBranch;
        };
    }

    private static /* synthetic */ String lambda$uniqueChainBranchNameGenerator$9(String planBranchName, Supplier existingPlanNamesRef) throws RuntimeException {
        String name = ChainBranchUtils.getValidChainBranchName((String)planBranchName);
        int i = 1;
        while (((Set)existingPlanNamesRef.get()).contains(name)) {
            name = planBranchName + " " + i++;
        }
        return name;
    }

    private static class ChainChanges<T extends ImmutableChain> {
        private final T chain;
        private final Boolean noChangesInProperties;

        private ChainChanges(T chain, Boolean noChangesInProperties) {
            this.chain = chain;
            this.noChangesInProperties = noChangesInProperties;
        }

        public ChainChanges(T chain) {
            this.chain = chain;
            this.noChangesInProperties = false;
        }

        public T getChain() {
            return this.chain;
        }

        public Boolean getNoChangesInProperties() {
            return this.noChangesInProperties;
        }

        /* synthetic */ ChainChanges(ImmutableChain x0, Boolean x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class DivergentBranchCreationData {
        final boolean enablePlan;

        DivergentBranchCreationData(boolean enablePlan) {
            this.enablePlan = enablePlan;
        }
    }

    private static class OperationsRegister {
        private final Map<PlanKey, PlanKey> planKeyChanges = new HashMap<PlanKey, PlanKey>();
        private final List<Job> jobsToRemove = new ArrayList<Job>();
        private final List<ChainStage> stagesToRemove = new ArrayList<ChainStage>();

        private OperationsRegister() {
        }

        Map<PlanKey, PlanKey> getPlanKeyChanges() {
            return this.planKeyChanges;
        }

        List<Job> getJobsToRemove() {
            return this.jobsToRemove;
        }

        List<ChainStage> getStagesToRemove() {
            return this.stagesToRemove;
        }
    }
}

