/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.rss.DivergentBranchDataBean;
import com.atlassian.bamboo.exception.RssPermissionException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
public interface PlanConfigImportService {
    @NotNull
    public PlanProperties convertYamlToPlan(@NotNull String var1) throws PropertiesValidationException, YamlValidationException;

    public void validatePlanProperties(@NotNull PlanProperties var1, @NotNull RssPermissions var2) throws PropertiesValidationException, YamlValidationException, RssPermissionException;

    public void validatePlanBranchProperties(@NotNull PlanProperties var1, @NotNull RssPermissions var2, @NotNull VcsBranch var3) throws PropertiesValidationException, YamlValidationException, RssPermissionException;

    @NotNull
    public ImportResult importPlan(@NotNull PlanProperties var1, @Nullable User var2, @NotNull RssPermissions var3);

    @NotNull
    public ImportResult importPlan(@NotNull PlanProperties var1, @Nullable User var2, @NotNull RssPermissions var3, boolean var4, boolean var5) throws PropertiesValidationException, UnauthorisedException, RssPermissionException;

    public void sendEventsAndScheduleTriggersIfRequired(@NotNull ImportResult var1);

    public void sendEventsAndScheduleTriggersForBranchIfRequired(@NotNull ImportResult var1, @Nullable User var2);

    @NotNull
    public ImportResult importPlanBranch(@NotNull PlanProperties var1, @NotNull VcsBranch var2, @Nullable User var3, @NotNull RssPermissions var4);

    @NotNull
    public ImportResult updatePlanBranch(@NotNull PlanProperties var1, @NotNull VcsBranch var2, @Nullable User var3, @NotNull RssPermissions var4, @NotNull DivergentBranchDataBean var5, boolean var6, boolean var7);

    @NotNull
    public ImportResult switchToLightweightBranch(@NotNull PlanKey var1);

    public static class ImportResult {
        private final ImmutableChain plan;
        private final boolean newPlan;
        private final boolean eventsDeferred;
        private final boolean noChangesInProperties;

        @VisibleForTesting
        public ImportResult(ImmutableChain plan, boolean newPlan, boolean eventsDeferred) {
            this.plan = plan;
            this.newPlan = newPlan;
            this.eventsDeferred = eventsDeferred;
            this.noChangesInProperties = false;
        }

        public ImportResult(ImmutableChain plan, boolean newPlan, boolean eventsDeferred, boolean noChangesInProperties) {
            this.plan = plan;
            this.newPlan = newPlan;
            this.eventsDeferred = eventsDeferred;
            this.noChangesInProperties = noChangesInProperties;
        }

        @NotNull
        public ImmutableChain getPlan() {
            return this.plan;
        }

        public boolean isNewPlan() {
            return this.newPlan;
        }

        public boolean isEventsDeferred() {
            return this.eventsDeferred;
        }

        public boolean isNoChangesInProperties() {
            return this.noChangesInProperties;
        }
    }
}

