/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.configuration.external.CredentialsExportService;
import com.atlassian.bamboo.configuration.external.ExportablePluginModule;
import com.atlassian.bamboo.configuration.external.LinkedRepositoryExportService;
import com.atlassian.bamboo.configuration.external.PlanConfigExportService;
import com.atlassian.bamboo.configuration.external.exporters.ArtifactExporter;
import com.atlassian.bamboo.configuration.external.exporters.ChainBranchExporter;
import com.atlassian.bamboo.configuration.external.exporters.ChainDependenciesExporter;
import com.atlassian.bamboo.configuration.external.exporters.HierarchicalConfigurationExporter;
import com.atlassian.bamboo.configuration.external.exporters.NotificationExporter;
import com.atlassian.bamboo.configuration.external.exporters.RepositoryExporter;
import com.atlassian.bamboo.configuration.external.exporters.VariableExporter;
import com.atlassian.bamboo.configuration.external.helpers.DockerPipelineExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.RequirementsExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TaskDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.specs.api.builders.notification.Notification;
import com.atlassian.bamboo.specs.api.builders.plan.Job;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.plan.Stage;
import com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact;
import com.atlassian.bamboo.specs.api.builders.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.AllOtherPluginsConfiguration;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryBranch;
import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildConfigurationAwarePlugin;
import com.atlassian.bamboo.v2.build.ImportExportAwarePlugin;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContext;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContextImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class PlanConfigExportServiceImpl
implements PlanConfigExportService {
    private static Logger log = Logger.getLogger(PlanConfigExportServiceImpl.class);
    private static final String PLANS_DIR = "plans";
    @Autowired
    private ArtifactExporter artifactExporter;
    @Autowired
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Autowired
    private BuildDefinitionConverter buildDefinitionConverter;
    @Autowired
    private CachedPlanManager cachedPlanManager;
    @Autowired
    private ChainBranchExporter chainBranchExporter;
    @Autowired
    private ChainDependenciesExporter chainDependenciesExporter;
    @Autowired
    private HierarchicalConfigurationExporter hierarchicalConfigurationExporter;
    @Autowired
    private NotificationExporter notificationExporter;
    @Autowired
    private PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    private RepositoryExporter repositoryExporter;
    @Autowired
    private LinkedRepositoryExportService linkedRepositoryExportService;
    @Autowired
    private VariableExporter variableExporter;
    @Autowired
    private EncryptedVariableDefinitionAccessor variableDefinitionAccessor;
    @Autowired
    private TriggerDefinitionExportHelper triggerDefinitionExportHelper;
    @Autowired
    private TaskDefinitionExportHelper taskDefinitionExportHelper;
    @Autowired
    private CredentialsExportService credentialsExportService;
    @Autowired
    private PluginAccessor pluginAccessor;
    @Autowired
    private LabelManager labelManager;

    @Override
    @NotNull
    public Iterable<Path> exportAllPlans() {
        List<ExportablePluginModule> exportableModules = this.getExportablePluginModules();
        File planDir = new File(SystemDirectory.getConfigurationExportsDirectory(), PLANS_DIR);
        planDir.mkdirs();
        Stream<Path> planPaths = this.cachedPlanManager.getPlansUnrestricted().stream().map(topLevelPlan -> this.exportSinglePlan((ImmutableTopLevelPlan)topLevelPlan, exportableModules, planDir));
        Stream repositoryPaths = BambooIterables.stream(this.linkedRepositoryExportService.exportAllLinkedRepositories());
        Stream credentialsPaths = BambooIterables.stream(this.credentialsExportService.exportAllCredentials());
        return Stream.concat(Stream.concat(planPaths, repositoryPaths), credentialsPaths).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Iterable<Path> exportPlan(@NotNull ImmutableTopLevelPlan topLevelPlan) {
        List<ExportablePluginModule> exportableModules = this.getExportablePluginModules();
        File planDir = new File(SystemDirectory.getConfigurationExportsDirectory(), PLANS_DIR);
        planDir.mkdirs();
        Path exportFilePath = this.exportSinglePlan(topLevelPlan, exportableModules, planDir);
        return Collections.singleton(exportFilePath);
    }

    @Override
    public Plan exportPlanToSpecs(@NotNull ImmutableTopLevelPlan plan) {
        List<ExportablePluginModule> exportableModules = this.getExportablePluginModules();
        return this.generateTopLevelPlanProperties(plan, exportableModules);
    }

    private List<ExportablePluginModule> getExportablePluginModules() {
        Collection exportableModuleDescriptors = this.pluginAccessor.getModuleDescriptors(descriptor -> descriptor.getModuleClass() != null && ImportExportAwarePlugin.class.isAssignableFrom(descriptor.getModuleClass()));
        return exportableModuleDescriptors.stream().map(descriptor -> new ExportablePluginModule(descriptor.getCompleteKey(), (ImportExportAwarePlugin)descriptor.getModule())).collect(Collectors.toList());
    }

    @VisibleForTesting
    protected void exportBuildConfiguration(ImmutablePlan immutablePlan, Consumer<PluginConfiguration<? extends PluginConfigurationProperties>> pluginConfigurationConsumer, Consumer<Map<String, Object>> customConfigurationConsumer, List<ExportablePluginModule> exportableModules) {
        BuildConfiguration buildConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)immutablePlan.getBuildDefinition()));
        for (ExportablePluginModule exportableModule : exportableModules) {
            ImportExportAwarePlugin module = exportableModule.getModule();
            if (!this.planConfigurationUIPluginHelper.isPluginApplicableTo((BuildConfigurationAwarePlugin)module, immutablePlan) || module.isConfigurationMissing((HierarchicalConfiguration)buildConfiguration) || module.getConfigurationKeys().isEmpty()) continue;
            try {
                PluginConfiguration pluginConfiguration = module.toSpecsEntity((HierarchicalConfiguration)buildConfiguration);
                pluginConfigurationConsumer.accept((PluginConfiguration<? extends PluginConfigurationProperties>)pluginConfiguration);
                module.getConfigurationKeys().forEach(arg_0 -> ((BuildConfiguration)buildConfiguration).clearProperty(arg_0));
            }
            catch (AbstractMethodError e) {
                log.error((Object)e.toString());
                log.debug(null, (Throwable)e);
            }
        }
        buildConfiguration.clearProperty("cleanWorkingDirectory");
        buildConfiguration.clearProperty("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled");
        if (immutablePlan instanceof ImmutableChain) {
            buildConfiguration.clearProperty("repositoryDefiningWorkingDirectory");
        }
        customConfigurationConsumer.accept(this.hierarchicalConfigurationExporter.generateDataMap((HierarchicalConfiguration)buildConfiguration));
    }

    private Plan generateTopLevelPlanProperties(ImmutableTopLevelPlan topLevelPlan, List<ExportablePluginModule> exportableModules) {
        com.atlassian.bamboo.project.Project topLevelProject = topLevelPlan.getProject();
        Project project = new Project().key(topLevelProject.getKey()).oid(topLevelProject.getOid().toExternalValue()).name(topLevelProject.getName()).description(topLevelProject.getDescription());
        Plan builder = new Plan(project, topLevelPlan.getBuildName(), topLevelPlan.getPlanKey().getPartialKey());
        builder.enabled(!topLevelPlan.isSuspendedFromBuilding()).oid(topLevelPlan.getOid().toExternalValue()).description(topLevelPlan.getDescription());
        LinkedHashMap planRepositories = PlanHelper.getPlanRepositoryDefinitionMap((ImmutablePlan)topLevelPlan);
        VcsRepositoryContext repositoryContext = VcsRepositoryContextImpl.builder().withOwnerPlan((ImmutablePlan)topLevelPlan).build();
        List repositoriesAndBranches = this.repositoryDefinitionManager.getPlanRepositoriesForExport((PlanIdentifier)topLevelPlan).stream().map(r -> this.repositoryExporter.toSpecsEntityAndBranchOverride((PartialVcsRepositoryData)r, repositoryContext)).collect(Collectors.toList());
        repositoriesAndBranches.stream().map(Pair::getFirst).forEach(xva$0 -> builder.planRepositories(new VcsRepository[]{xva$0}));
        repositoriesAndBranches.stream().map(Pair::getSecond).filter(Objects::nonNull).forEach(xva$0 -> builder.repositoryBranches(new VcsRepositoryBranch[]{xva$0}));
        topLevelPlan.getTriggerDefinitions().stream().map(triggerDefinition -> this.triggerDefinitionExportHelper.toSpecsEntity(planRepositories.keySet(), (TriggerDefinition)triggerDefinition, (Triggerable)topLevelPlan)).forEach(xva$0 -> builder.triggers(new Trigger[]{xva$0}));
        builder.planBranchManagement(this.chainBranchExporter.exportPlanBranchManagement(topLevelPlan));
        builder.dependencies(this.chainDependenciesExporter.toSpecsEntity(topLevelPlan));
        this.notificationExporter.exportNotificationSet(topLevelPlan.getNotificationSet()).forEach(xva$0 -> builder.notifications(new Notification[]{xva$0}));
        this.variableExporter.toSpecsEntities((ImmutablePlan)topLevelPlan, this.variableDefinitionAccessor.getPlanVariables((PlanIdentifier)topLevelPlan)).forEach(xva$0 -> builder.variables(new Variable[]{xva$0}));
        this.labelManager.getPlanLabels((ImmutablePlan)topLevelPlan).stream().map(Label::getName).forEach(xva$0 -> builder.labels(new String[]{xva$0}));
        this.generateStages(topLevelPlan, exportableModules).forEach(xva$0 -> builder.stages(new Stage[]{xva$0}));
        HashMap customConfiguration = new HashMap();
        this.exportForceStopHungBuildConfiguration(topLevelPlan, builder);
        this.exportBuildConfiguration((ImmutablePlan)topLevelPlan, xva$0 -> builder.pluginConfigurations(new PluginConfiguration[]{xva$0}), customConfiguration::putAll, exportableModules);
        if (!customConfiguration.isEmpty()) {
            AllOtherPluginsConfiguration others = new AllOtherPluginsConfiguration();
            others.configuration(customConfiguration);
            builder.pluginConfigurations(new PluginConfiguration[]{others});
        }
        return builder;
    }

    private void exportForceStopHungBuildConfiguration(ImmutableTopLevelPlan topLevelPlan, Plan builder) {
        if (topLevelPlan.getBuildDefinition().getCustomConfiguration().containsKey("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled")) {
            boolean enabled = Boolean.parseBoolean(topLevelPlan.getBuildDefinition().getCustomConfiguration().getOrDefault("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", "false"));
            if (enabled) {
                builder.forceStopHungBuilds();
            } else {
                builder.ignoreHungBuilds();
            }
        }
    }

    private List<Stage> generateStages(ImmutableTopLevelPlan topLevelPlan, List<ExportablePluginModule> exportableModules) {
        return topLevelPlan.getAllStages().stream().map(s -> {
            Stage stageBuilder = new Stage(s.getName()).description(s.getDescription()).finalStage(s.isFinal()).manual(s.isManual());
            this.generateJobs((ImmutableChainStage)s, exportableModules).forEach(xva$0 -> stageBuilder.jobs(new Job[]{xva$0}));
            return stageBuilder;
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    @NotNull
    List<Job> generateJobs(ImmutableChainStage stage, List<ExportablePluginModule> exportableModules) {
        return stage.getJobs().stream().map(j -> {
            Job job = new Job(j.getBuildName(), j.getPlanKey().getPartialKey()).description(j.getDescription()).enabled(!j.isSuspendedFromBuilding());
            j.getTaskDefinitions().stream().filter(t -> !t.isFinalising()).map(t -> this.taskDefinitionExportHelper.toSpecsEntity((TaskContainer)j, (TaskDefinition)t)).forEach(xva$0 -> job.tasks(new Task[]{xva$0}));
            j.getTaskDefinitions().stream().filter(TaskIdentifier::isFinalising).map(t -> this.taskDefinitionExportHelper.toSpecsEntity((TaskContainer)j, (TaskDefinition)t)).forEach(xva$0 -> job.finalTasks(new Task[]{xva$0}));
            j.getArtifactDefinitions().stream().map(this.artifactExporter::toSpecsEntity).forEach(xva$0 -> job.artifacts(new Artifact[]{xva$0}));
            j.getEffectiveRequirementSet().getRequirements().stream().filter(r -> r.isReadonly() == false).map(RequirementsExportHelper::toSpecsEntity).forEach(xva$0 -> job.requirements(new Requirement[]{xva$0}));
            job.dockerConfiguration(DockerPipelineExportHelper.toSpecsEntity(j.getBuildDefinition().getDockerPipelineConfiguration()));
            this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)j).stream().map(this.artifactExporter::toSpecsEntity).forEach(xva$0 -> job.artifactSubscriptions(new ArtifactSubscription[]{xva$0}));
            job.cleanWorkingDirectory(j.getBuildDefinition().isCleanWorkingDirectory().booleanValue());
            HashMap customConfiguration = new HashMap();
            this.exportBuildConfiguration((ImmutablePlan)j, xva$0 -> job.pluginConfigurations(new PluginConfiguration[]{xva$0}), customConfiguration::putAll, exportableModules);
            if (!customConfiguration.isEmpty()) {
                AllOtherPluginsConfiguration others = new AllOtherPluginsConfiguration();
                others.configuration(customConfiguration);
                job.pluginConfigurations(new PluginConfiguration[]{others});
            }
            return job;
        }).collect(Collectors.toList());
    }

    private Path exportSinglePlan(ImmutableTopLevelPlan topLevelPlan, List<ExportablePluginModule> exportableModules, File planDir) {
        try {
            Plan plan = this.generateTopLevelPlanProperties(topLevelPlan, exportableModules);
            return YamlHelper.dumpToYmlFile((EntityPropertiesBuilder)plan, planDir, topLevelPlan.getPlanKey().getKey());
        }
        catch (Exception e) {
            log.error((Object)("Exporting plan: " + topLevelPlan.getPlanKey() + " failed: "), (Throwable)e);
            throw e;
        }
    }
}

