/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.configuration.external.MavenSanitizer;
import com.atlassian.bamboo.configuration.external.PomProcessingException;
import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.atlassian.utils.process.ProcessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenSanitizerImpl
implements MavenSanitizer {
    private static final Logger log = Logger.getLogger(MavenSanitizerImpl.class);
    private static final String DEPENDENCIES_XPATH = "//dependencies";
    private static final String PARENT_TAG = "parent";
    private static final String PROVIDED_SPECS_POM = "bamboo-specs-pom.xml";

    @Override
    public File sanitize(@NotNull File sourcePom, @NotNull RssExecutionOutputHandler stdout) throws PomProcessingException {
        try {
            File pom = File.createTempFile("specs", ".xml", sourcePom.getParentFile());
            this.saveXml(pom, this.getPomToExecute(sourcePom));
            this.logPomModification(stdout, pom);
            return pom;
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PomProcessingException(e.getMessage(), e);
        }
    }

    private Document getPomToExecute(File sourcePom) throws IOException, SAXException, ParserConfigurationException, PomProcessingException {
        Document sourcePomXml = this.getDocument(sourcePom);
        Document destinationPomXml = this.getBambooProvidedPomAsDocument();
        this.updateParentVersion(destinationPomXml);
        this.copyDependenciesFromSourcePom(destinationPomXml, sourcePomXml);
        return destinationPomXml;
    }

    private void updateParentVersion(Document xml) throws PomProcessingException {
        NodeList parentNodes = xml.getElementsByTagName(PARENT_TAG);
        Node parentNode = parentNodes.item(0);
        List<Node> versions = this.findChildrenByName(parentNode, "version");
        MavenSanitizerImpl.checkPomState(versions.size() == 1, "Missing parent/version tag. Invalid POM configuration.");
        Node version = (Node)versions.iterator().next();
        String modelVersion = BambooSpecVersion.getModelVersion();
        if (!Objects.equals(modelVersion, version.getTextContent())) {
            version.setTextContent(modelVersion);
        }
    }

    private void copyDependenciesFromSourcePom(Document destinationPomXml, Document sourcePomXml) throws PomProcessingException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            Node existingDependencies = (Node)xPath.evaluate(DEPENDENCIES_XPATH, destinationPomXml, XPathConstants.NODE);
            Node sourceDependencies = (Node)xPath.evaluate(DEPENDENCIES_XPATH, sourcePomXml, XPathConstants.NODE);
            if (sourceDependencies != null) {
                destinationPomXml.getDocumentElement().replaceChild(destinationPomXml.importNode(sourceDependencies, true), existingDependencies);
            } else {
                destinationPomXml.getDocumentElement().removeChild(existingDependencies);
            }
        }
        catch (XPathExpressionException e) {
            throw new PomProcessingException("Exception while copying dependencies from source POM", e);
        }
    }

    private void logPomModification(@NotNull RssExecutionOutputHandler stdout, File fileReader) {
        try {
            this.logMessage("Content of pom.xml used:\n" + FileUtils.readFileToString((File)fileReader) + "\n", stdout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void logMessage(String message, @NotNull RssExecutionOutputHandler stdout) {
        try {
            stdout.process((InputStream)new StringInputStream(message));
        }
        catch (ProcessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private Document getBambooProvidedPomAsDocument() throws IOException, ParserConfigurationException, SAXException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(PROVIDED_SPECS_POM);){
            Document document = this.getDocument(is);
            return document;
        }
    }

    @NotNull
    private Document getDocument(File source) throws ParserConfigurationException, SAXException, IOException {
        try (FileInputStream is = new FileInputStream(source);){
            Document document = this.getDocument(is);
            return document;
        }
    }

    @NotNull
    private Document getDocument(InputStream source) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = BambooXmlUtils.newSecureDocumentBuilderFactory((Logger)log).newDocumentBuilder();
        Document xml = documentBuilder.parse(source);
        xml.normalize();
        return xml;
    }

    private void saveXml(File pom, Document xml) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer idTransform = transformerFactory.newTransformer();
        idTransform.transform(new DOMSource(xml), new StreamResult(pom));
    }

    private List<Node> findChildrenByName(Node node, String name) {
        return this.stream(node.getChildNodes()).filter(child -> Objects.equals(name, child.getNodeName())).collect(Collectors.toList());
    }

    private Stream<Node> stream(NodeList list) {
        return IntStream.range(0, list.getLength()).mapToObj(list::item);
    }

    private static void checkPomState(boolean expression, Object errorMessage) throws PomProcessingException {
        if (!expression) {
            throw new PomProcessingException(String.valueOf(errorMessage));
        }
    }
}

