/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.configuration.external.LinkedRepositoryExportService;
import com.atlassian.bamboo.configuration.external.exporters.RepositoryExporter;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.repository.EncryptedRepositoryDefinitionAccessor;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContextImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkedRepositoryExportServiceImpl
implements LinkedRepositoryExportService {
    private static final String REPOSITORIES_DIR = "repositories";
    @Autowired
    private EncryptedRepositoryDefinitionAccessor encryptedVcsDefinitionAccessor;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    private VcsRepositoryConfigurationService repositoryConfigurationService;
    @Autowired
    private RepositoryExporter repositoryExporter;
    @Autowired
    private VariableSubstitutorFactory variableSubstitutorFactory;
    @Autowired
    private CustomVariableContext customVariableContext;
    @Autowired
    private BambooPermissionManager bambooPermissionManager;
    @Autowired
    private TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;

    @Override
    @NotNull
    public Iterable<Path> exportAllLinkedRepositories() {
        File repositoriesDir = new File(SystemDirectory.getConfigurationExportsDirectory(), REPOSITORIES_DIR);
        repositoriesDir.mkdirs();
        Stream<Path> repositoryPaths = this.encryptedVcsDefinitionAccessor.getLinkedRepositories().stream().map(r -> this.exportLinkedRepository((VcsRepositoryData)r, repositoriesDir));
        return repositoryPaths.collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Iterable<Path> exportLinkedRepository(@NotNull VcsRepositoryData repositoryData) {
        Preconditions.checkArgument((boolean)repositoryData.isLinked());
        File repositoriesDir = new File(SystemDirectory.getConfigurationExportsDirectory(), REPOSITORIES_DIR);
        repositoriesDir.mkdirs();
        VcsRepositoryData encryptedRepositoryData = this.encryptedVcsDefinitionAccessor.getVcsRepositoryDataByOid(repositoryData.getOid());
        return Collections.singleton(this.exportLinkedRepository(encryptedRepositoryData, repositoriesDir));
    }

    private Path exportLinkedRepository(VcsRepositoryData repositoryData, File repositoriesDir) {
        Object properties = this.repositoryExporter.toSpecsEntity(repositoryData, VcsRepositoryContextImpl.emptyContext());
        return YamlHelper.dumpToYmlFile(properties, repositoriesDir, repositoryData.getOid().toExternalValue());
    }

    @Override
    @NotNull
    public VcsRepositoryProperties convertYamlRepository(@NotNull String yaml) throws PropertiesValidationException, YamlValidationException {
        return this.repositoryExporter.toEntityProperties(yaml);
    }

    @Nullable
    private VcsRepositoryData getExistingData(@Nullable BambooOidProperties oidProperties, @Nullable String name) throws PropertiesValidationException {
        if (oidProperties != null) {
            BambooEntityOid oid = BambooEntityOid.createFromExternalValue((String)oidProperties.getOid());
            return this.repositoryDefinitionManager.getVcsRepositoryDataByOid(oid);
        }
        if (name != null) {
            return this.repositoryDefinitionManager.getLinkedRepositoryByName(name);
        }
        return null;
    }

    @Override
    @NotNull
    public PartialVcsRepositoryData importLinkedRepository(@NotNull VcsRepositoryProperties repositoryProperties) throws PropertiesValidationException, UnauthorisedException {
        return (PartialVcsRepositoryData)this.bambooTransactionHibernateTemplate.execute(status -> {
            VcsRepositoryData existingData = this.getExistingData(repositoryProperties.getOid(), repositoryProperties.getName());
            if (!this.hasPermissionsToProceed(existingData)) {
                throw new UnauthorisedException("You don''t have sufficient permissions to import linked repository");
            }
            VariableSubstitutor variableSubstitutor = this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
            try {
                PartialVcsRepositoryData repositoryData = (PartialVcsRepositoryData)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, (BambooCallables.ThrowingX)((BambooCallables.Throwing)() -> this.repositoryExporter.importRepository(repositoryProperties, existingData, true, VcsRepositoryContextImpl.emptyContext())));
                this.repositoryConfigurationService.validateLinkedRepository(repositoryData);
                return this.repositoryConfigurationService.mergeLinkedRepository(repositoryData);
            }
            catch (YamlValidationException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        });
    }

    private boolean hasPermissionsToProceed(VcsRepositoryData existingData) {
        return existingData != null ? this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)existingData, null) : this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY);
    }

    private boolean hasAdminAccessToRepository(VcsRepositoryData existingData) {
        return this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)existingData, null);
    }
}

