/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.DarkFeatureService;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.configuration.external.DeploymentImportService;
import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.VariableValidationService;
import com.atlassian.bamboo.configuration.external.exporters.NotificationExporter;
import com.atlassian.bamboo.configuration.external.helpers.CustomEnvironmentPluginExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.DockerPipelineExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.PermissionHelper;
import com.atlassian.bamboo.configuration.external.helpers.PlanImportHelper;
import com.atlassian.bamboo.configuration.external.helpers.RequirementsExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TaskDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.configuration.external.util.PropertiesValidator;
import com.atlassian.bamboo.configuration.external.util.ValidationProblemUtils;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.deployments.configuration.service.EnvironmentCustomConfigService;
import com.atlassian.bamboo.deployments.environments.ConfigurationState;
import com.atlassian.bamboo.deployments.environments.EnvironmentPermissionsService;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.events.MultipleEnvironmentsDeletedEvent;
import com.atlassian.bamboo.deployments.environments.events.notifications.EnvironmentNotificationsModifiedEvent;
import com.atlassian.bamboo.deployments.environments.persistence.EnvironmentDao;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentDeletionService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.task.EnvironmentTaskRequirementsHelper;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectPermissionsService;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.deployments.projects.events.DeploymentProjectConfigUpdatedEvent;
import com.atlassian.bamboo.deployments.projects.events.DeploymentProjectCreatedEvent;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.deployments.projects.persistence.items.MutableDeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.persistence.versionnaming.MutableVersionNamingScheme;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.repository.EnvironmentRepositoryLink;
import com.atlassian.bamboo.deployments.repository.persistence.EnvironmentRepositoryLinkDao;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plugin.BambooPluginManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.ReleaseNamingProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.EnvironmentPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.EnvironmentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.util.ReleaseNamingHelper;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.model.task.CheckoutItemProperties;
import com.atlassian.bamboo.specs.model.task.VcsCheckoutTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.DescriptionProvider;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSetImpl;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.VariableUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentImportServiceImpl
implements DeploymentImportService {
    private static final Logger log = Logger.getLogger(DeploymentImportServiceImpl.class);
    @VisibleForTesting
    static final ValidationContext DEPLOYMENT_PERMISSIONS_VALIDATION_CONTEXT = ValidationContext.of((String)"Deployment permissions");
    @VisibleForTesting
    static final ValidationContext ENVIRONMENT_PERMISSIONS_VALIDATION_CONTEXT = ValidationContext.of((String)"Environment permissions");
    @Inject
    private HibernateMutableAclService aclService;
    @Inject
    private BambooAclUpdateHelper aclUpdateHelper;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;
    @Inject
    private DeploymentProjectDao deploymentProjectDao;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private EnvironmentDao environmentDao;
    @Inject
    private EnvironmentDeletionService environmentDeletionService;
    @Inject
    private EnvironmentRepositoryLinkDao environmentRepositoryLinkDao;
    @Inject
    private EnvironmentService environmentService;
    @Inject
    private EnvironmentTaskRequirementsHelper environmentTaskRequirementsHelper;
    @Inject
    private PlanManager planManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private ScopedExclusionService scopedExclusionService;
    @Inject
    private TaskDefinitionExportHelper taskDefinitionExportHelper;
    @Inject
    private TaskManager taskManager;
    @Inject
    private TriggerDefinitionExportHelper triggerDefinitionExportHelper;
    @Inject
    private VariableConfigurationService variableConfigurationService;
    @Inject
    private VariableDefinitionManager variableDefinitionManager;
    @Inject
    private NotificationExporter notificationExporter;
    @Inject
    private TextProvider textProvider;
    @Inject
    private BambooSpecsManager bambooSpecsManager;
    @Inject
    private DeploymentProjectPermissionsService deploymentProjectPermissionsService;
    @Inject
    private EnvironmentPermissionsService environmentPermissionsService;
    @Inject
    private BambooUserManager userManager;
    @Inject
    private EnvironmentCustomConfigService environmentCustomConfigService;
    @Inject
    private DockerPipelineValidationService dockerPipelineValidationService;
    @Inject
    private BambooPluginManager bambooPluginManager;
    @Inject
    private DarkFeatureService darkFeatureService;
    @Inject
    private CustomEnvironmentPluginExportHelper customEnvironmentPluginExportHelper;
    @Inject
    private SecretEncryptionService secretEncryptionService;
    private VariableValidationService variableValidationService;

    @PostConstruct
    private void setUp() {
        this.variableValidationService = new VariableValidationService(this.secretEncryptionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DeploymentProperties convertYamlToDeployment(@NotNull String yaml, @NotNull RssPermissions rssPermissions) throws PropertiesValidationException, YamlValidationException {
        DeploymentProperties properties;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)new PluginsClassLoader(old, (PluginAccessor)this.bambooPluginManager, (PluginEventManager)new DefaultPluginEventManager()));
            properties = YamlHelper.parse(yaml, DeploymentProperties.class);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.validate(properties, rssPermissions);
        return properties;
    }

    @Override
    public void validate(DeploymentProperties deploymentProperties, @NotNull RssPermissions rssPermissions) throws YamlValidationException {
        PropertiesValidator.validate((EntityProperties)deploymentProperties);
        this.taskDefinitionExportHelper.validateTaskProperties(deploymentProperties, rssPermissions);
        this.triggerDefinitionExportHelper.validateTriggerProperties(deploymentProperties, rssPermissions);
        DockerPipelineExportHelper.validateDockerConfiguration(deploymentProperties);
        this.customEnvironmentPluginExportHelper.validatePluginConfigurations(deploymentProperties, rssPermissions);
    }

    @Override
    @NotNull
    public DeploymentPermissionsProperties convertYamlToDeploymentPermissions(String yaml) throws PropertiesValidationException, YamlValidationException {
        DeploymentPermissionsProperties properties = YamlHelper.parse(yaml, DeploymentPermissionsProperties.class);
        PropertiesValidator.validate((EntityProperties)properties);
        return properties;
    }

    @Override
    @NotNull
    public EnvironmentPermissionsProperties convertYamlToEnvironmentPermissions(String yaml) throws YamlValidationException {
        EnvironmentPermissionsProperties properties = YamlHelper.parse(yaml, EnvironmentPermissionsProperties.class);
        PropertiesValidator.validate((EntityProperties)properties);
        return properties;
    }

    @Override
    @NotNull
    public DeploymentProject importDeployment(@NotNull DeploymentProperties deploymentProperties, @Nullable User user, @NotNull RssPermissions rssPermissions, boolean noChangesInProperties) throws PropertiesValidationException {
        return (DeploymentProject)this.bambooTransactionHibernateTemplate.execute(status -> {
            Optional<MutableDeploymentProject> existingDeploymentProject = this.findExistingDeploymentByOidOrName(deploymentProperties.getOid(), deploymentProperties.getName());
            if (existingDeploymentProject.isPresent()) {
                if (!rssPermissions.isDeploymentProjectAllowed(existingDeploymentProject.get().getKey().getKey())) {
                    throw new UnauthorisedException(this.textProvider.getText("rss.modify.deployment.plan.insufficient.permissions", Arrays.asList(rssPermissions.getSpecsRepositoryName(), existingDeploymentProject.get().getName())));
                }
                this.validateRepositories(deploymentProperties, rssPermissions);
                if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)existingDeploymentProject.get(), null)) {
                    throw new UnauthorisedException(this.textProvider.getText("rest.import.deployment.no.edit.permission"));
                }
                return this.modifyExistingDeployment(deploymentProperties, existingDeploymentProject.get(), user, noChangesInProperties);
            }
            if (!rssPermissions.isAllProjectsAccess()) {
                throw new UnauthorisedException(this.textProvider.getText("rss.create.deployment.plan.insufficient.permissions", Collections.singletonList(rssPermissions.getSpecsRepositoryName())));
            }
            this.validateRepositories(deploymentProperties, rssPermissions);
            if (!this.bambooPermissionManager.canCreateDeploymentProject()) {
                throw new UnauthorisedException(this.textProvider.getText("rest.import.deployment.no.create.permission"));
            }
            return this.createNewDeployment(deploymentProperties, user);
        });
    }

    @Override
    public void importDeploymentPermissions(@NotNull DeploymentPermissionsProperties deploymentPermission, @NotNull RssPermissions rssPermissions) {
        this.bambooTransactionHibernateTemplate.execute(status -> {
            MutableDeploymentProject deploymentProject = this.findMutableDeploymentProjectForModification(deploymentPermission.getDeploymentName(), deploymentPermission.getDeploymentOid(), rssPermissions);
            if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)deploymentProject, null)) {
                throw new UnauthorisedException(this.textProvider.getText("rest.import.deployment.no.edit.permission"));
            }
            this.setPermissions(DEPLOYMENT_PERMISSIONS_VALIDATION_CONTEXT, arg_0 -> ((DeploymentProjectPermissionsService)this.deploymentProjectPermissionsService).permissionDependencies(arg_0), (ObjectIdentity)new HibernateObjectIdentityImpl(InternalDeploymentProject.class, (Serializable)Long.valueOf(deploymentProject.getId())), deploymentPermission.getPermissions());
            return null;
        });
    }

    @Override
    public void importDeploymentEnvironmentPermissions(@NotNull EnvironmentPermissionsProperties environmentPermission, @NotNull RssPermissions rssPermissions) {
        this.bambooTransactionHibernateTemplate.execute(status -> {
            MutableDeploymentProject deploymentProject = this.findMutableDeploymentProjectForModification(environmentPermission.getDeploymentName(), environmentPermission.getDeploymentOid(), rssPermissions);
            Optional<MutableEnvironment> environment = this.environmentDao.getEnvironmentsForDeploymentProject(deploymentProject.getId()).stream().filter(env -> env.getName().equals(environmentPermission.getEnvironmentName())).findFirst();
            ImporterUtils.checkArgument((ValidationContext)ENVIRONMENT_PERMISSIONS_VALIDATION_CONTEXT, (boolean)environment.isPresent(), (Object)String.format("Can't find environment by name %s in deployment project %s", environmentPermission.getEnvironmentName(), deploymentProject.getName()));
            if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)environment.get(), null)) {
                throw new UnauthorisedException(this.textProvider.getText("rest.import.environment.no.edit.permission"));
            }
            this.setPermissions(ENVIRONMENT_PERMISSIONS_VALIDATION_CONTEXT, arg_0 -> ((EnvironmentPermissionsService)this.environmentPermissionsService).permissionDependencies(arg_0), (ObjectIdentity)new HibernateObjectIdentityImpl(InternalEnvironment.class, (Serializable)Long.valueOf(environment.get().getId())), environmentPermission.getPermissions());
            return null;
        });
    }

    @Override
    public void importDeploymentPermissions(@Nullable String deploymentName, @Nullable BambooOidProperties deploymentOid, @NotNull PermissionsProperties defaultEnvironmentPermissions, @NotNull List<EnvironmentPermissionsProperties> environmentPermissions, @NotNull RssPermissions rssPermissions) {
        HashMap permissionsByEnvironment = new HashMap();
        environmentPermissions.forEach(env -> permissionsByEnvironment.put(env.getEnvironmentName(), env));
        this.bambooTransactionHibernateTemplate.execute(status -> {
            MutableDeploymentProject deploymentProject = this.findMutableDeploymentProjectForModification(deploymentName, deploymentOid, rssPermissions);
            this.environmentDao.getEnvironmentsForDeploymentProject(deploymentProject.getId()).forEach(env -> permissionsByEnvironment.putIfAbsent(env.getName(), new EnvironmentPermissionsProperties(deploymentName, env.getName(), defaultEnvironmentPermissions)));
            return null;
        });
        for (EnvironmentPermissionsProperties environmentPermissionsProperties : permissionsByEnvironment.values()) {
            this.importDeploymentEnvironmentPermissions(environmentPermissionsProperties, rssPermissions);
        }
    }

    @NotNull
    private MutableDeploymentProject findMutableDeploymentProjectForModification(String deploymentName, BambooOidProperties deploymentOid, @NotNull RssPermissions rssPermissions) {
        Optional<MutableDeploymentProject> deploymentProject = this.findExistingDeploymentByOidOrName(deploymentOid, deploymentName);
        ImporterUtils.checkArgument((ValidationContext)DEPLOYMENT_PERMISSIONS_VALIDATION_CONTEXT, (boolean)deploymentProject.isPresent(), (Object)String.format("Can't find deployment project by oid(%s) or name(%s)", deploymentOid, deploymentName));
        if (!rssPermissions.isDeploymentProjectAllowed(deploymentProject.get().getKey().getKey())) {
            throw new UnauthorisedException(this.textProvider.getText("rss.modify.deployment.plan.insufficient.permissions", Arrays.asList(rssPermissions.getSpecsRepositoryName(), deploymentProject.get().getName())));
        }
        return deploymentProject.get();
    }

    private void setPermissions(@NotNull ValidationContext validationContext, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, @NotNull ObjectIdentity identity, @NotNull PermissionsProperties permissionProperties) {
        ValidationContext usersValidationContext = validationContext.with("Users");
        ValidationContext groupsValidationContext = validationContext.with("Groups");
        this.validateUsers(usersValidationContext, permissionProperties.getUserPermissions());
        this.validateGroups(groupsValidationContext, permissionProperties.getGroupPermissions());
        MutableAcl acl = this.aclService.readMutableAclById(identity);
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.addAll(PermissionHelper.createPermissionsForUsers(permissionDependenciesSupplier, permissionProperties.getUserPermissions()));
        permissions.addAll(PermissionHelper.createPermissionsForGroups(permissionDependenciesSupplier, permissionProperties.getGroupPermissions()));
        permissions.addAll(PermissionHelper.createPermissionsForLoggedInUser(permissionDependenciesSupplier, permissionProperties.getLoggedInUserPermissions()));
        permissions.addAll(PermissionHelper.createPermissionsForAnonymousUser(permissionDependenciesSupplier, permissionProperties.getAnonymousUserPermissions()));
        this.aclService.updateAclAces(acl, permissions);
    }

    private void setBasicProperties(DeploymentProperties deploymentProperties, MutableDeploymentProject mutableDeployment) {
        Optional<Chain> chain = PlanImportHelper.findExistingPlanByOidOrKey(deploymentProperties.getPlan(), this.planManager, Chain.class);
        if (!chain.isPresent()) {
            throw new IllegalArgumentException("Plan referenced by deployment project doesn't exist: " + deploymentProperties.getPlan());
        }
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)chain.get(), null)) {
            throw new UnauthorisedException(this.textProvider.getText("rest.import.deployment.no.plan.permission"));
        }
        if (deploymentProperties.getOid() != null) {
            mutableDeployment.setOid(BambooEntityOid.createFromExternalValue((String)deploymentProperties.getOid().getOid()));
        }
        mutableDeployment.setName(deploymentProperties.getName());
        mutableDeployment.setDescription(StringUtils.defaultString((String)deploymentProperties.getDescription()));
        mutableDeployment.setPlanKey(chain.get().getPlanKey());
    }

    @NotNull
    private DeploymentProject createNewDeployment(DeploymentProperties deploymentProperties, User userForCreation) {
        Either result = this.scopedExclusionService.tryWithLock((Enum)ScopedExclusionService.ExclusionScopeType.DEPLOYMENT_PROJECT_NAME, (Object)deploymentProperties.getName(), this.createNewDeploymentFunction(deploymentProperties, userForCreation));
        if (result.isRight()) {
            Preconditions.checkState((boolean)((Optional)result.right().get()).isPresent());
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.import.deployment.create"));
            DeploymentProject deploymentProject = (DeploymentProject)((Optional)result.right().get()).get();
            this.eventPublisher.publish((Object)new DeploymentProjectCreatedEvent(deploymentProject.getId()));
            return deploymentProject;
        }
        throw new IllegalStateException("Could not create deployment named " + deploymentProperties.getName() + " as it is already being created");
    }

    private ScopedExclusionService.ExclusiveFunction<String, DeploymentProject, RuntimeException> createNewDeploymentFunction(DeploymentProperties deploymentProperties, User user) {
        return name -> {
            if (this.deploymentProjectDao.isDeploymentProjectNameConflicting(deploymentProperties.getName())) {
                throw new IllegalArgumentException("Deployment with name " + deploymentProperties.getName() + " already exists");
            }
            MutableVersionNamingScheme mutableVersionNamingScheme = this.deploymentProjectDao.createNewVersionNamingSchemeInstance();
            this.validateNamingRules(deploymentProperties, mutableVersionNamingScheme);
            for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
                this.variableValidationService.validateVariables(environmentProperties.getVariables());
            }
            MutableDeploymentProject mutableDeployment = this.deploymentProjectDao.createNewDeploymentProjectInstance();
            this.setBasicProperties(deploymentProperties, mutableDeployment);
            this.deploymentProjectDao.save(mutableDeployment);
            MutableAcl acl = this.aclUpdateHelper.createNewObjectAcl(user, InternalDeploymentProject.class, mutableDeployment.getId(), true);
            this.aclService.updateAcl(acl);
            this.updateVersionNamingScheme(deploymentProperties, mutableDeployment, mutableVersionNamingScheme);
            this.createEnvironments(deploymentProperties, mutableDeployment, user);
            this.updateDeploymentProjectItems(mutableDeployment);
            this.setBambooSpecsData(deploymentProperties, mutableDeployment);
            return this.deploymentProjectService.getDeploymentProject(mutableDeployment.getId());
        };
    }

    private DeploymentProject modifyExistingDeployment(DeploymentProperties deploymentProperties, MutableDeploymentProject mutableDeployment, User user, boolean noChangeInProperties) {
        boolean updateOnlyRssData = noChangeInProperties && mutableDeployment.getVcsBambooSpecsSource() != null;
        ScopedExclusionService.ExclusiveFunction<String, DeploymentProject, RuntimeException> deploymentUpdateFunction = updateOnlyRssData ? this.updateOnlySpecsData(deploymentProperties, mutableDeployment) : this.modifyExistingDeploymentFunction(deploymentProperties, mutableDeployment, user);
        Either result = this.scopedExclusionService.tryWithLock((Enum)ScopedExclusionService.ExclusionScopeType.DEPLOYMENT_PROJECT_NAME, (Object)deploymentProperties.getName(), deploymentUpdateFunction);
        if (result.isRight()) {
            Preconditions.checkState((boolean)((Optional)result.right().get()).isPresent());
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.import.deployment.update"));
            DeploymentProject deploymentProject = (DeploymentProject)((Optional)result.right().get()).get();
            this.eventPublisher.publish((Object)new DeploymentProjectConfigUpdatedEvent(mutableDeployment.getId()));
            return deploymentProject;
        }
        throw new IllegalStateException("Could not update deployment named " + deploymentProperties.getName() + " as it's being modified in another thread.");
    }

    private ScopedExclusionService.ExclusiveFunction<String, DeploymentProject, RuntimeException> updateOnlySpecsData(@NotNull DeploymentProperties deploymentProperties, @NotNull MutableDeploymentProject mutableDeployment) {
        return name -> {
            this.setBambooSpecsData(deploymentProperties, mutableDeployment);
            this.deploymentProjectDao.save(mutableDeployment);
            return this.deploymentProjectService.getDeploymentProject(mutableDeployment.getId());
        };
    }

    private ScopedExclusionService.ExclusiveFunction<String, DeploymentProject, RuntimeException> modifyExistingDeploymentFunction(@NotNull DeploymentProperties deploymentProperties, @NotNull MutableDeploymentProject mutableDeployment, @Nullable User user) {
        return name -> {
            if (!deploymentProperties.getName().equals(mutableDeployment.getName()) && this.deploymentProjectDao.isDeploymentProjectNameConflicting(deploymentProperties.getName())) {
                throw new IllegalArgumentException("Deployment with name " + deploymentProperties.getName() + " already exists");
            }
            Map<String, MutableEnvironment> existingEnvironments = this.environmentDao.getEnvironmentsForDeploymentProject(mutableDeployment.getId()).stream().collect(Collectors.toMap(InternalEnvironment::getName, Function.identity()));
            for (Object environment : existingEnvironments.values()) {
                if (this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, environment, null)) continue;
                throw new UnauthorisedException(this.textProvider.getText("rest.import.deployment.no.environment.permission"));
            }
            MutableVersionNamingScheme mutableVersionNamingScheme = this.deploymentProjectDao.getVersionNamingSchemeForProject(mutableDeployment.getId());
            ImporterUtils.checkNotNull((ValidationContext)ValidationContext.of((String)"Deployment project"), (String)"versionScheme", (Object)mutableVersionNamingScheme);
            this.validateNamingRules(deploymentProperties, mutableVersionNamingScheme);
            for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
                this.variableValidationService.validateVariables(environmentProperties.getVariables());
            }
            PlanKey oldPlanKey = mutableDeployment.getPlanKey();
            this.setBasicProperties(deploymentProperties, mutableDeployment);
            this.setBambooSpecsData(deploymentProperties, mutableDeployment);
            this.deploymentProjectDao.save(mutableDeployment);
            PlanKey newPlanKey = mutableDeployment.getPlanKey();
            this.updateVersionNamingScheme(deploymentProperties, mutableDeployment, mutableVersionNamingScheme);
            this.updateEnvironments(deploymentProperties, existingEnvironments, mutableDeployment, user);
            if (!Objects.equals(oldPlanKey, newPlanKey)) {
                log.debug((Object)("Changed source plan key: <" + oldPlanKey + "><" + newPlanKey + ">"));
                this.updateDeploymentProjectItems(mutableDeployment);
            }
            this.setBambooSpecsData(deploymentProperties, mutableDeployment);
            return this.deploymentProjectService.getDeploymentProject(mutableDeployment.getId());
        };
    }

    private void updateDeploymentProjectItems(MutableDeploymentProject mutableDeployment) {
        List projectItems = this.deploymentProjectDao.getProjectItems(mutableDeployment.getId());
        for (MutableDeploymentProjectItem projectItem : projectItems) {
            this.deploymentProjectDao.delete(projectItem);
        }
        this.deploymentProjectService.generateArtifactProjectItems(mutableDeployment);
    }

    private void setBambooSpecsData(DeploymentProperties deploymentProperties, MutableDeploymentProject deploymentProject) {
        RepositoryStoredSpecsData repositoryStoredSpecsData = deploymentProperties.getRepositoryStoredSpecsData();
        if (repositoryStoredSpecsData == null) {
            if (deploymentProject.getVcsBambooSpecsSource() != null) {
                log.info((Object)("Detaching RSS-managed plan " + deploymentProject.getName() + " from RSS"));
            }
            deploymentProject.setVcsBambooSpecsSource(null);
            return;
        }
        Optional maybeCurrentSpecsSource = this.bambooSpecsManager.findSourceById(repositoryStoredSpecsData.getSpecsSourceId());
        if (!maybeCurrentSpecsSource.isPresent()) {
            throw new IllegalStateException("Specs source " + repositoryStoredSpecsData.getSpecsSourceId() + " not found");
        }
        deploymentProject.setVcsBambooSpecsSource((VcsBambooSpecsSource)maybeCurrentSpecsSource.get());
    }

    private void updateVersionNamingScheme(DeploymentProperties deploymentProperties, MutableDeploymentProject mutableDeployment, @NotNull MutableVersionNamingScheme versionNamingScheme) {
        ReleaseNamingProperties releaseNamingProperties = deploymentProperties.getReleaseNaming();
        String nextVersionName = versionNamingScheme.getNextVersionName();
        if (!releaseNamingProperties.isAutoIncrement() || this.shouldUpdateVersionName(nextVersionName, releaseNamingProperties.getNextVersionName())) {
            versionNamingScheme.setNextVersionName(releaseNamingProperties.getNextVersionName());
        }
        versionNamingScheme.setAutoIncrement(releaseNamingProperties.isAutoIncrement());
        versionNamingScheme.getVariablesToAutoIncrement().clear();
        versionNamingScheme.getVariablesToAutoIncrement().addAll(releaseNamingProperties.getVariablesToAutoIncrement());
        versionNamingScheme.setDeploymentProject(mutableDeployment);
        versionNamingScheme.setApplicableToBranches(releaseNamingProperties.isApplicableToBranches());
        this.deploymentProjectDao.save(versionNamingScheme);
    }

    private void validateNamingRules(@NotNull DeploymentProperties deploymentProperties, @NotNull MutableVersionNamingScheme versionNamingScheme) {
        ReleaseNamingProperties releaseNamingProperties = deploymentProperties.getReleaseNaming();
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        Optional<Chain> chain = PlanImportHelper.findExistingPlanByOidOrKey(deploymentProperties.getPlan(), this.planManager, Chain.class);
        if (!chain.isPresent()) {
            validationProblems.add(new ValidationProblem("Plan referenced by deployment project doesn't exist: " + deploymentProperties.getPlan()));
        }
        for (Object variableUsage : VariableUtils.findVariableUsages((String)releaseNamingProperties.getNextVersionName())) {
            if (!PasswordMaskingUtils.shouldBeMasked((String)variableUsage.getName())) continue;
            validationProblems.add(new ValidationProblem("nextVersionName", "%s is not allowed in the release version name because it is a password variable.", new Object[]{variableUsage.toUsageString()}));
        }
        Set variablesToAutoIncrement = releaseNamingProperties.getVariablesToAutoIncrement();
        for (String variableKey : variablesToAutoIncrement) {
            if (!PasswordMaskingUtils.shouldBeMasked((String)variableKey)) continue;
            validationProblems.add(new ValidationProblem("nextVersionName", "%s is not allowed in the release version name because it is a password variable.", new Object[]{variableKey}));
        }
        if (chain.isPresent()) {
            Set existingVariablesToAutoincrement = versionNamingScheme.getVariablesToAutoIncrement();
            HashSet variablesChanged = Sets.newHashSet((Iterable)Sets.difference((Set)variablesToAutoIncrement, (Set)existingVariablesToAutoincrement));
            variablesChanged.addAll(Sets.difference((Set)existingVariablesToAutoincrement, (Set)variablesToAutoIncrement));
            boolean globalErrorAddedOnce = false;
            boolean planErrorAddedOnce = false;
            for (String variableKey : variablesChanged) {
                VariableDefinition variable = this.variableDefinitionManager.getPlanVariableByKey((PlanIdentifier)chain.get(), variableKey);
                if (variable == null) {
                    variable = this.variableDefinitionManager.getGlobalVariableByKey(variableKey);
                }
                if (!globalErrorAddedOnce && variable != null && variable.getVariableType() == VariableType.GLOBAL && !this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
                    validationProblems.add(new ValidationProblem("Your updates result in changes to whether a global variable is automatically incremented or not.  You do not have permission to make changes to global variables.  Please contact an administrator to make these changes"));
                    globalErrorAddedOnce = true;
                    continue;
                }
                if (!planErrorAddedOnce && variable != null && variable.getVariableType() == VariableType.PLAN && !this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, chain.get().getPlanKey())) {
                    validationProblems.add(new ValidationProblem("Your updates result in changes to whether a plan variable is automatically incremented or not.  You do not have permission to make changes to the plans variables."));
                    planErrorAddedOnce = true;
                    continue;
                }
                if (variable != null || !variablesToAutoIncrement.contains(variableKey)) continue;
                validationProblems.add(new ValidationProblem("Variable " + variableKey + " does not exist"));
            }
        }
        if (!validationProblems.isEmpty()) {
            throw new PropertiesValidationException(validationProblems);
        }
    }

    private boolean shouldUpdateVersionName(String currentNextVersionName, String newNextVersionName) {
        if (StringUtils.isBlank((CharSequence)currentNextVersionName)) {
            return true;
        }
        ReleaseNamingHelper.SplitVersionName currentVersionSplit = ReleaseNamingHelper.splitVersionName((String)currentNextVersionName);
        ReleaseNamingHelper.SplitVersionName newVersionSplit = ReleaseNamingHelper.splitVersionName((String)newNextVersionName);
        if (currentVersionSplit.getNumberToIncrement() == null) {
            return true;
        }
        if (!Objects.equals(currentVersionSplit.getPrefix(), newVersionSplit.getPrefix()) || !Objects.equals(currentVersionSplit.getSuffix(), newVersionSplit.getSuffix())) {
            return true;
        }
        long newNumberToIncrement = newVersionSplit.getNumberToIncrement() == null ? 0L : newVersionSplit.getNumberToIncrement();
        return newNumberToIncrement > currentVersionSplit.getNumberToIncrement();
    }

    private void createEnvironments(DeploymentProperties deploymentProperties, MutableDeploymentProject mutableDeployment, User user) {
        int index = 0;
        HashMap<EnvironmentProperties, MutableEnvironment> propertiesToEnvironment = new HashMap<EnvironmentProperties, MutableEnvironment>();
        for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
            MutableEnvironment environment = this.createNewMutableEnvironment();
            this.updateEnvironmentData(mutableDeployment, index, environmentProperties, environment, user, true);
            propertiesToEnvironment.put(environmentProperties, environment);
            ++index;
        }
        this.updateTriggers(propertiesToEnvironment);
    }

    private void updateEnvironments(DeploymentProperties deploymentProperties, Map<String, MutableEnvironment> existingEnvironments, MutableDeploymentProject mutableDeployment, User user) {
        int index = 0;
        HashMap<EnvironmentProperties, MutableEnvironment> propertiesToEnvironment = new HashMap<EnvironmentProperties, MutableEnvironment>();
        for (EnvironmentProperties environmentProperties : deploymentProperties.getEnvironments()) {
            MutableEnvironment environment;
            boolean existingEnvironment = existingEnvironments.containsKey(environmentProperties.getName());
            if (existingEnvironment) {
                environment = existingEnvironments.get(environmentProperties.getName());
                existingEnvironments.remove(environmentProperties.getName());
            } else {
                environment = this.createNewMutableEnvironment();
            }
            this.updateEnvironmentData(mutableDeployment, index, environmentProperties, environment, user, !existingEnvironment);
            propertiesToEnvironment.put(environmentProperties, environment);
            ++index;
        }
        for (MutableEnvironment environment : existingEnvironments.values()) {
            this.environmentDeletionService.delete(environment.getId(), false);
        }
        if (!existingEnvironments.isEmpty()) {
            List deletedEnvironmentIds = existingEnvironments.values().stream().map(InternalEnvironment::getId).collect(Collectors.toList());
            List deletedEnvironmentKeys = existingEnvironments.values().stream().map(InternalEnvironment::getKey).collect(Collectors.toList());
            this.eventPublisher.publish((Object)new MultipleEnvironmentsDeletedEvent(deletedEnvironmentIds, deletedEnvironmentKeys));
        }
        this.updateTriggers(propertiesToEnvironment);
    }

    private void updateTriggers(Map<EnvironmentProperties, MutableEnvironment> environments) {
        for (Map.Entry<EnvironmentProperties, MutableEnvironment> entry : environments.entrySet()) {
            MutableEnvironment mutableEnvironment = entry.getValue();
            this.createTriggers(mutableEnvironment, entry.getKey());
            mutableEnvironment.getTriggerDefinitions().forEach(triggerDefinition -> this.triggerDefinitionExportHelper.activateIfEnabled((Triggerable)mutableEnvironment, (TriggerDefinition)triggerDefinition));
        }
    }

    private void updateEnvironmentData(MutableDeploymentProject mutableDeployment, int index, EnvironmentProperties environmentProperties, MutableEnvironment environment, User user, boolean isCreate) {
        environment.getTriggerDefinitions().forEach(triggerDefinition -> this.triggerDefinitionExportHelper.deactivate((Triggerable)environment, (TriggerDefinition)triggerDefinition));
        environment.setName(environmentProperties.getName());
        environment.setDescription(StringUtils.defaultString((String)environmentProperties.getDescription()));
        environment.setConfigurationState(ConfigurationState.TASKED);
        environment.setDeploymentProject(mutableDeployment);
        environment.setPosition(index);
        RequirementSet requirementSet = environment.getRequirementSet();
        requirementSet.getRequirements().clear();
        RequirementsExportHelper.addCustomRequirements(requirementSet, environmentProperties.getRequirements());
        this.createTasks(environment, environmentProperties);
        if (isCreate) {
            this.environmentDao.save(environment);
        }
        boolean notificationsUpdated = this.updateNotificationSet(environment, environmentProperties);
        this.environmentDao.save(environment);
        if (notificationsUpdated) {
            this.eventPublisher.publish((Object)new EnvironmentNotificationsModifiedEvent(environment.getId()));
        }
        DockerConfigurationProperties dockerPipelineProperties = environmentProperties.getDockerConfiguration();
        DockerPipelineConfiguration dockerPipelineConfiguration = DockerPipelineExportHelper.fromSpecsEntity(dockerPipelineProperties);
        ErrorCollection dockerErrors = this.dockerPipelineValidationService.validateDockerPipelineConfiguration(dockerPipelineConfiguration);
        ImporterUtils.checkNoErrors(ValidationProblemUtils.fromErrorCollection(dockerErrors));
        this.environmentCustomConfigService.saveDockerPipelineConfiguration(dockerPipelineConfiguration, environment.getId());
        LinkedHashMap configurations = new LinkedHashMap();
        environmentProperties.getPluginConfigurations().forEach(c -> {
            String moduleKey = c.getAtlassianPlugin().getCompleteModuleKey();
            configurations.put(moduleKey, this.customEnvironmentPluginExportHelper.importConfiguration(moduleKey, (EnvironmentPluginConfigurationProperties)c));
        });
        this.environmentCustomConfigService.saveEnvironmentPluginConfig(configurations, environment.getId());
        if (isCreate) {
            this.copyPermissionsFromDeploymentProject(mutableDeployment, environment, user);
        }
        this.variableConfigurationService.setDeploymentEnvironmentVariables(environment.getId(), environmentProperties.getVariables());
    }

    private boolean updateNotificationSet(MutableEnvironment environment, EnvironmentProperties environmentProperties) {
        NotificationSet notificationSet = environment.getNotificationSet();
        return this.notificationExporter.updateNotificationSet(notificationSet, environmentProperties.getNotifications(), (EntityProperties)environmentProperties);
    }

    private void copyPermissionsFromDeploymentProject(MutableDeploymentProject mutableDeployment, MutableEnvironment environment, User user) {
        Acl projectAcl = this.bambooPermissionManager.getAcl((Object)mutableDeployment);
        MutableAcl acl = this.aclUpdateHelper.copyProjectPermissionsToEnvironment(user, InternalEnvironment.class, environment.getId(), projectAcl);
        this.aclService.updateAcl(acl);
    }

    @NotNull
    private MutableEnvironment createNewMutableEnvironment() {
        MutableEnvironment environment = this.environmentDao.createNewEnvironmentInstance();
        environment.setRequirementSet((RequirementSet)new RequirementSetImpl());
        environment.setNotificationSet((NotificationSet)new NotificationSetImpl());
        return environment;
    }

    private void createTasks(MutableEnvironment mutableEnvironment, EnvironmentProperties environmentProperties) {
        boolean dockerEnabled = environmentProperties.getDockerConfiguration() != null && environmentProperties.getDockerConfiguration().isEnabled();
        ArrayList<TaskDefinition> taskDefinitions = new ArrayList<TaskDefinition>();
        environmentProperties.getTasks().forEach(taskProperties -> this.importTaskProperties(mutableEnvironment, (List<TaskDefinition>)taskDefinitions, (TaskProperties)taskProperties, false, dockerEnabled));
        environmentProperties.getFinalTasks().forEach(taskProperties -> this.importTaskProperties(mutableEnvironment, (List<TaskDefinition>)taskDefinitions, (TaskProperties)taskProperties, true, dockerEnabled));
        BuildConfiguration newConfiguration = new BuildConfiguration();
        TaskConfigurationUtils.addTaskDefinitionsToConfig(taskDefinitions, (HierarchicalConfiguration)newConfiguration, (String)"");
        mutableEnvironment.setTasksXmlData(newConfiguration.asXml());
        this.adjustRepositoryLinksForEnvironment(mutableEnvironment, taskDefinitions);
    }

    private void createTriggers(MutableEnvironment mutableEnvironment, EnvironmentProperties environmentProperties) {
        ArrayList triggerDefinitions = new ArrayList();
        environmentProperties.getTriggers().forEach(triggerProperties -> this.importTriggerProperties(mutableEnvironment, triggerDefinitions, (TriggerProperties)triggerProperties));
        BuildConfiguration newConfiguration = new BuildConfiguration();
        TriggerConfigurationUtils.addTriggerDefinitionsToConfig(triggerDefinitions, (HierarchicalConfiguration)newConfiguration);
        mutableEnvironment.setTriggersXmlData(newConfiguration.asXml());
    }

    private void importTaskProperties(MutableEnvironment mutableEnvironment, List<TaskDefinition> taskDefinitions, TaskProperties taskProperties, boolean finalTask, boolean isDockerEnabled) {
        try {
            TaskDefinition taskDefinition = this.taskDefinitionExportHelper.importTaskDefinition(taskDefinitions.size() + 1, (TaskContainer)mutableEnvironment, taskDefinitions, taskProperties, null, finalTask);
            taskDefinition.setRootDirectorySelector(TaskRootDirectorySelector.DEFAULT);
            taskDefinitions.add(taskDefinition);
            this.taskManager.calculateRequirementsForTaskDefinition(mutableEnvironment.getRequirementSet(), taskDefinition, this.getEnvironmentRequirementsSupplier(mutableEnvironment, taskDefinition), isDockerEnabled);
        }
        catch (PropertiesValidationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private void importTriggerProperties(MutableEnvironment mutableEnvironment, List<TriggerDefinition> triggerDefinitions, TriggerProperties triggerProperties) {
        TriggerDefinition triggerDefinition = this.triggerDefinitionExportHelper.importTriggerDefinition(triggerDefinitions.size() + 1, (Triggerable)mutableEnvironment, triggerProperties);
        triggerDefinitions.add(triggerDefinition);
    }

    @NotNull
    private Supplier<Set<Requirement>> getEnvironmentRequirementsSupplier(@NotNull MutableEnvironment environment, @NotNull TaskDefinition taskDefinition) {
        return this.environmentTaskRequirementsHelper.getEnvironmentRequirementsSupplier(this.environmentService.createImmutableEnvironment(environment), taskDefinition);
    }

    private void adjustRepositoryLinksForEnvironment(MutableEnvironment environment, List<TaskDefinition> allTasks) {
        List repositoryLinks = this.environmentRepositoryLinkDao.getEnvironmentRepositoryLinks((InternalEnvironment)environment);
        Set repositoriesUsedByNewTasks = allTasks.stream().filter(BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.vcs:task.vcs.checkout")).flatMap(td -> td.getConfiguration().keySet().stream().filter(RepositoryTaskHelper::isRepositorySelector).map(repositoryKey -> (String)td.getConfiguration().get(repositoryKey))).map(Long::parseLong).collect(Collectors.toSet());
        Set existingLinksRepoIds = repositoryLinks.stream().map(rl -> rl.getRepositoryDataEntity().getId()).collect(Collectors.toSet());
        Sets.SetView linksToCreate = Sets.difference(repositoriesUsedByNewTasks, existingLinksRepoIds);
        Sets.SetView linksToDelete = Sets.difference(existingLinksRepoIds, repositoriesUsedByNewTasks);
        int maxPosition = 0;
        for (EnvironmentRepositoryLink repositoryLink : repositoryLinks) {
            if (linksToDelete.contains(repositoryLink.getRepositoryDataEntity().getId())) {
                this.environmentRepositoryLinkDao.removeRepositoryFromEnvironment(repositoryLink);
                continue;
            }
            repositoryLink.setPosition(maxPosition);
            ++maxPosition;
            this.environmentRepositoryLinkDao.save((BambooObject)repositoryLink);
        }
        for (Long repositoryId : linksToCreate) {
            RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId.longValue());
            if (repositoryDataEntity == null) {
                log.error((Object)("Data inconsistency, cannot find RepositoryDataEntity with ID: " + repositoryId));
                continue;
            }
            this.environmentRepositoryLinkDao.linkRepositoryToEnvironment(environment, repositoryDataEntity, maxPosition);
            ++maxPosition;
        }
    }

    private void validateUsers(@NotNull ValidationContext validationContext, @NotNull List<UserPermissionProperties> userPermissions) throws PropertiesValidationException {
        List nonExistingUserNames = userPermissions.stream().map(UserPermissionProperties::getUsername).filter(userName -> this.userManager.getUser(userName) == null).collect(Collectors.toList());
        ImporterUtils.checkArgument((ValidationContext)validationContext, (boolean)nonExistingUserNames.isEmpty(), (Object)("Cannot set permission for non existing users: " + nonExistingUserNames));
    }

    private void validateGroups(@NotNull ValidationContext validationContext, @NotNull List<GroupPermissionProperties> groupPermissionProperties) throws PropertiesValidationException {
        List nonExistingGroupNames = groupPermissionProperties.stream().map(GroupPermissionProperties::getGroup).filter(groupName -> this.userManager.getGroup(groupName) == null).collect(Collectors.toList());
        ImporterUtils.checkArgument((ValidationContext)validationContext, (boolean)nonExistingGroupNames.isEmpty(), (Object)("Cannot set permission for non existing groups: " + nonExistingGroupNames));
    }

    private Optional<MutableDeploymentProject> findExistingDeploymentByOidOrName(@Nullable BambooOidProperties oid, @Nullable String name) {
        if (oid != null) {
            return Optional.ofNullable(this.deploymentProjectDao.findDeploymentProjectByOid(BambooEntityOid.createFromExternalValue((String)oid.getOid())));
        }
        return Optional.ofNullable(this.deploymentProjectDao.findDeploymentProjectByName(name));
    }

    private void validateRepositories(@NotNull DeploymentProperties deploymentProperties, @NotNull RssPermissions rssPermissions) {
        Set<String> forbiddenLinkedRepositories = this.getForbiddenRepositoryNames(deploymentProperties, rssPermissions);
        if (!forbiddenLinkedRepositories.isEmpty()) {
            List<String> parameters = Arrays.asList(rssPermissions.getSpecsRepositoryName(), StringUtils.join(forbiddenLinkedRepositories, (String)", "));
            throw new UnauthorisedException(this.textProvider.getText("rss.import.deployment.repository.insufficient.permissions", parameters));
        }
    }

    private Set<String> getForbiddenRepositoryNames(DeploymentProperties deploymentProperties, RssPermissions rssPermissions) {
        if (rssPermissions.isAllRepositoriesAccess()) {
            return Collections.emptySet();
        }
        return deploymentProperties.getEnvironments().stream().flatMap(environmentProperties -> environmentProperties.getTasks().stream()).filter(this::isCheckoutTask).map(taskProperties -> (VcsCheckoutTaskProperties)Narrow.downTo((Object)taskProperties, VcsCheckoutTaskProperties.class)).filter(Objects::nonNull).flatMap(taskProperties -> taskProperties.getCheckoutItems().stream().map(CheckoutItemProperties::getRepository).filter(Objects::nonNull)).map(this::convertRepositoryPropertiesToVcsRepositoryData).filter(repositoryData -> repositoryData != null && !rssPermissions.isRepositoryAllowed(repositoryData.getId())).map(DescriptionProvider::getName).collect(Collectors.toSet());
    }

    private boolean isCheckoutTask(TaskProperties taskProperties) {
        return BambooPluginUtils.pluginKeyEquals((String)"com.atlassian.bamboo.plugins.vcs:task.vcs.checkout").test(() -> taskProperties.getAtlassianPlugin().getCompleteModuleKey());
    }

    @Nullable
    private VcsRepositoryData convertRepositoryPropertiesToVcsRepositoryData(VcsRepositoryIdentifierProperties repositoryIdentifierProperty) {
        if (StringUtils.isNotEmpty((CharSequence)repositoryIdentifierProperty.getName())) {
            return this.repositoryDefinitionManager.getLinkedRepositoryByName(repositoryIdentifierProperty.getName());
        }
        if (repositoryIdentifierProperty.getOid() != null) {
            BambooEntityOid oid = BambooEntityOid.createFromExternalValue((String)repositoryIdentifierProperty.getOid().getOid());
            return this.repositoryDefinitionManager.getVcsRepositoryDataByOid(oid);
        }
        return null;
    }
}

