/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.configuration.external.DeploymentExportService;
import com.atlassian.bamboo.configuration.external.exporters.NotificationExporter;
import com.atlassian.bamboo.configuration.external.exporters.PermissionExporter;
import com.atlassian.bamboo.configuration.external.exporters.VariableExporter;
import com.atlassian.bamboo.configuration.external.helpers.CustomEnvironmentPluginExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.DockerPipelineExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.PermissionHelper;
import com.atlassian.bamboo.configuration.external.helpers.RequirementsExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TaskDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.deployments.configuration.service.EnvironmentCustomConfigService;
import com.atlassian.bamboo.deployments.environments.EnvironmentComparators;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.persistence.EnvironmentDao;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.projects.versionnaming.VersionNamingScheme;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.deployment.Environment;
import com.atlassian.bamboo.specs.api.builders.deployment.ReleaseNaming;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.docker.DockerConfiguration;
import com.atlassian.bamboo.specs.api.builders.notification.Notification;
import com.atlassian.bamboo.specs.api.builders.permission.DeploymentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.EnvironmentPermissions;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeploymentExportServiceImpl
implements DeploymentExportService {
    private static final Logger log = Logger.getLogger(DeploymentExportServiceImpl.class);
    private static final String DEPLOYMENTS_DIR = "deployments";
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private DeploymentVersionService deploymentVersionService;
    @Inject
    private PlanService planService;
    @Inject
    private HibernateMutableAclService aclService;
    @Inject
    private PermissionExporter permissionExporter;
    @Inject
    private EncryptedVariableDefinitionAccessor variableDefinitionAccessor;
    @Inject
    private VariableExporter variableExporter;
    @Inject
    private EnvironmentDao environmentDao;
    @Inject
    private NotificationExporter notificationExporter;
    @Inject
    private TriggerDefinitionExportHelper triggerDefinitionExportHelper;
    @Inject
    private TaskDefinitionExportHelper taskDefinitionExportHelper;
    @Inject
    private TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private EnvironmentCustomConfigService environmentCustomConfigService;
    @Inject
    private CustomEnvironmentPluginExportHelper customEnvironmentPluginExportHelper;

    @Override
    public Iterable<Path> exportAllDeploymentProjects() {
        return this.deploymentProjectService.getAllDeploymentProjects().stream().map(this::exportSingleDeployment).collect(Collectors.toList());
    }

    @Override
    public Path exportSingleDeployment(@NotNull DeploymentProject project) {
        try {
            Deployment deployment = this.generateDeployment(project);
            return YamlHelper.dumpToYmlFile((EntityPropertiesBuilder)deployment, this.getDeploymentDirectory(), project.getKey().getKey());
        }
        catch (Exception e) {
            log.error((Object)("Exporting deployment: " + project.getName() + " failed: "), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Deployment exportDeploymentToSpecs(@NotNull DeploymentProject deploymentProject) {
        return this.generateDeployment(deploymentProject);
    }

    private Deployment generateDeployment(@NotNull DeploymentProject project) {
        Deployment builder = new Deployment(this.getPlanData(project), project.getName()).description(project.getDescription()).oid(project.getOid().toExternalValue());
        VersionNamingScheme versionNamingScheme = this.deploymentProjectService.getVersionNamingScheme(project.getId());
        ReleaseNaming releaseNaming = new ReleaseNaming(versionNamingScheme.getNextVersionName()).autoIncrement(versionNamingScheme.isAutoIncrement()).applicableToBranches(versionNamingScheme.isApplicableToBranches());
        versionNamingScheme.getVariablesToAutoIncrement().forEach(xva$0 -> releaseNaming.variablesToAutoIncrement(new String[]{xva$0}));
        builder.releaseNaming(releaseNaming);
        this.environmentDao.getEnvironmentsForDeploymentProject(project.getId()).stream().sorted(EnvironmentComparators.byDeploymentProjectIdEnvironmentPositionAndName()).map(this::generateEnvironment).forEach(xva$0 -> builder.environments(new Environment[]{xva$0}));
        return builder;
    }

    private Environment generateEnvironment(@NotNull MutableEnvironment environment) {
        Environment builder = new Environment(environment.getName()).description(environment.getDescription());
        environment.getTaskDefinitions().stream().filter(t -> !t.isFinalising()).map(t -> this.taskDefinitionExportHelper.toSpecsEntity((TaskContainer)environment, (TaskDefinition)t)).forEach(xva$0 -> builder.tasks(new Task[]{xva$0}));
        environment.getTaskDefinitions().stream().filter(TaskIdentifier::isFinalising).map(t -> this.taskDefinitionExportHelper.toSpecsEntity((TaskContainer)environment, (TaskDefinition)t)).forEach(xva$0 -> builder.finalTasks(new Task[]{xva$0}));
        environment.getTriggerDefinitions().stream().map(triggerDefinition -> this.triggerDefinitionExportHelper.toSpecsEntity(Collections.emptySet(), (TriggerDefinition)triggerDefinition, (Triggerable)environment)).forEach(xva$0 -> builder.triggers(new Trigger[]{xva$0}));
        environment.getRequirementSet().getRequirements().stream().filter(r -> r.isReadonly() == false).map(RequirementsExportHelper::toSpecsEntity).forEach(xva$0 -> builder.requirements(new Requirement[]{xva$0}));
        DockerPipelineConfiguration dockerPipelineConfiguration = this.environmentCustomConfigService.getDockerPipelineConfiguration(environment.getId());
        DockerConfiguration dockerPipeline = DockerPipelineExportHelper.toSpecsEntity(dockerPipelineConfiguration);
        builder.dockerConfiguration(dockerPipeline);
        Map pluginConfigs = this.environmentCustomConfigService.getEnvironmentPluginConfig(environment.getId());
        pluginConfigs.forEach((k, v) -> builder.pluginConfigurations(new EnvironmentPluginConfiguration[]{this.customEnvironmentPluginExportHelper.toSpecsEntity((String)k, (Map<String, String>)v)}));
        this.variableDefinitionAccessor.getDeploymentEnvironmentVariables(environment.getId()).stream().map(this.variableExporter::toSpecsEntity).forEach(xva$0 -> builder.variables(new Variable[]{xva$0}));
        this.notificationExporter.exportNotificationSet(environment.getNotificationSet()).forEach(xva$0 -> builder.notifications(new Notification[]{xva$0}));
        return builder;
    }

    private PlanIdentifier getPlanData(@NotNull DeploymentProject project) {
        PlanKey planKey = project.getPlanKey();
        if (planKey != null) {
            try {
                ImmutableChain plan = this.planService.getPlan(planKey);
                if (plan != null) {
                    return new PlanIdentifier(new BambooOid(plan.getOid().toExternalValue())).projectKey(plan.getProject().getKey()).key(plan.getPlanKey().getPartialKey());
                }
            }
            catch (WebValidationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return new PlanIdentifier(PlanKeys.getProjectKeyPart((PlanKey)planKey), planKey.getPartialKey());
        }
        return new PlanIdentifier(new BambooOid("0"));
    }

    @NotNull
    private File getDeploymentDirectory() {
        File deploymentDir = new File(SystemDirectory.getConfigurationExportsDirectory(), DEPLOYMENTS_DIR);
        deploymentDir.mkdirs();
        return deploymentDir;
    }

    @Override
    @NotNull
    public DeploymentPermissions exportDeploymentPermissions(@NotNull DeploymentProject deploymentProject) {
        return (DeploymentPermissions)this.bambooTransactionHibernateTemplate.execute(status -> {
            if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)deploymentProject, null)) {
                throw new UnauthorisedException("You don't have EDIT permission to export permissions for deployment: " + deploymentProject.getName());
            }
            DeploymentPermissions deploymentPermission = new DeploymentPermissions(deploymentProject.getName()).permissions(PermissionHelper.createFromAcl((Acl)this.aclService.readMutableAclById(deploymentProject.getId())));
            return deploymentPermission;
        });
    }

    @Override
    @NotNull
    public EnvironmentPermissions exportEnvironmentPermissions(@NotNull DeploymentProject deploymentProject, @NotNull com.atlassian.bamboo.deployments.environments.Environment environment) {
        return (EnvironmentPermissions)this.bambooTransactionHibernateTemplate.execute(status -> {
            if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)environment, null)) {
                throw new UnauthorisedException("You don't have EDIT permission to export permissions for deployment environment: " + environment.getName());
            }
            EnvironmentPermissions environmentPermission = new EnvironmentPermissions(deploymentProject.getName(), environment.getName()).permissions(PermissionHelper.createFromAcl((Acl)this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl(InternalEnvironment.class, (Serializable)Long.valueOf(environment.getId())))));
            return environmentPermission;
        });
    }
}

