/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external;

import com.atlassian.bamboo.configuration.external.CredentialsExportService;
import com.atlassian.bamboo.configuration.external.helpers.YamlHelper;
import com.atlassian.bamboo.configuration.external.util.PropertiesValidator;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.credentials.CredentialTypeExporter;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsDataEntity;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.credentials.DefaultCredentialTypeExporter;
import com.atlassian.bamboo.credentials.EncryptedCredentialsAccessor;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.credentials.AnySharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.util.BambooIterables;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class CredentialsExportServiceImpl
implements CredentialsExportService {
    private static final String CREDENTIALS_DIR = "credentials";
    @Autowired
    private CredentialsManager credentialsManager;
    @Autowired
    private EncryptedCredentialsAccessor encryptedCredentialsAccessor;
    @Autowired
    private ProjectManager projectManager;

    @Override
    @NotNull
    public Iterable<Path> exportAllCredentials() {
        File credentialsDir = new File(SystemDirectory.getConfigurationExportsDirectory(), CREDENTIALS_DIR);
        credentialsDir.mkdirs();
        return BambooIterables.stream((Iterable)this.encryptedCredentialsAccessor.getAllCredentials()).map(c -> this.exportCredentials((CredentialsData)c, credentialsDir)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Iterable<Path> exportCredentials(@NotNull CredentialsData credentialsData) {
        File credentialsDir = new File(SystemDirectory.getConfigurationExportsDirectory(), CREDENTIALS_DIR);
        credentialsDir.mkdirs();
        Path exportPath = this.exportCredentials(credentialsData, credentialsDir);
        return Collections.singleton(exportPath);
    }

    private Path exportCredentials(CredentialsData credentialsData, File credentialsDir) {
        return YamlHelper.dumpToYmlFile((EntityPropertiesBuilder)this.toSpecsEntity(credentialsData), credentialsDir, credentialsData.getOid().toExternalValue());
    }

    @Override
    @NotNull
    public SharedCredentialsProperties toEntityProperties(String yamlString) throws PropertiesValidationException, YamlValidationException {
        SharedCredentialsProperties properties = YamlHelper.parseAndNarrow(yamlString, SharedCredentialsProperties.class);
        PropertiesValidator.validate((EntityProperties)properties);
        return properties;
    }

    @Override
    @NotNull
    public CredentialsData importCredentials(@NotNull SharedCredentialsProperties credentialProperties) throws PropertiesValidationException, YamlValidationException {
        BambooEntityOid bambooEntityOid = credentialProperties.getOid() != null ? BambooEntityOid.createFromExternalValue((String)credentialProperties.getOid().getOid()) : null;
        Long projectId = credentialProperties.getProject() != null ? Long.valueOf(this.projectManager.getProjectByKey(credentialProperties.getProject().getKey().getKey()).getId()) : null;
        CredentialTypeExporter exporter = this.getCredentialTypeExporter(credentialProperties);
        Map credentialsConfiguration = exporter.toCredentialsConfiguration(credentialProperties);
        CredentialsDataEntity credentialsData = new CredentialsDataEntity(credentialProperties.getAtlassianPlugin().getCompleteModuleKey(), credentialProperties.getName(), credentialsConfiguration, bambooEntityOid, projectId);
        this.credentialsManager.validate((CredentialsData)credentialsData);
        return this.credentialsManager.mergeImportedEntity((CredentialsData)credentialsData);
    }

    @Override
    @NotNull
    public SharedCredentials toSpecsEntity(@NotNull CredentialsData credentialsData) {
        CredentialTypeExporter exporter = this.getCredentialTypeExporter(credentialsData.getPluginKey());
        return exporter.toSpecsEntity(credentialsData).name(credentialsData.getName()).oid(credentialsData.getOid().toExternalValue());
    }

    @NotNull
    private CredentialTypeExporter getCredentialTypeExporter(SharedCredentialsProperties credentialsProperties) {
        if (credentialsProperties instanceof AnySharedCredentialsProperties) {
            return new DefaultCredentialTypeExporter();
        }
        return this.getCredentialTypeExporter(credentialsProperties.getAtlassianPlugin().getCompleteModuleKey());
    }

    @NotNull
    private CredentialTypeExporter getCredentialTypeExporter(String pluginKey) {
        CredentialTypeExporter exporter = this.credentialsManager.retrieveCredentialTypeExporter(pluginKey);
        if (exporter == null) {
            throw new RuntimeException("Couldn't find exporter for: " + pluginKey);
        }
        return exporter;
    }
}

