/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.projects.service;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.deployments.environments.EnvironmentTriggerValidationError;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectStatusForResultSummary;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectWithEnvironmentForDashboard;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectWithEnvironmentStatuses;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.ArtifactValidationError;
import com.atlassian.bamboo.deployments.projects.versionnaming.VersionNamingScheme;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.acegisecurity.AccessDeniedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface DeploymentProjectService {
    @NotNull
    public List<DeploymentProject> getAllDeploymentProjects();

    @NotNull
    public List<DeploymentProject> getDeploymentProjectsRelatedToPlan(@NotNull PlanKey var1);

    @NotNull
    public List<DeploymentProject> getDeploymentProjectsRelatedToPlanOrBranches(@NotNull PlanKey var1);

    @NotNull
    public List<DeploymentProjectWithEnvironmentStatuses> getDeploymentProjectsWithStatusesRelatedToPlan(@NotNull PlanKey var1);

    @NotNull
    public List<DeploymentProjectWithEnvironmentStatuses> getDeploymentProjectsWithStatusesRelatedToPlanOrBranches(@NotNull PlanKey var1);

    @NotNull
    public List<DeploymentProjectStatusForResultSummary> getDeploymentProjectsWithStatusesRelatedToPlanResult(@NotNull ResultsSummary var1);

    @NotNull
    public List<DeploymentProject> getDeploymentProjectsRelatedToArtifact(@NotNull ArtifactDefinition var1);

    @Nullable
    public DeploymentProject getDeploymentProject(long var1) throws AccessDeniedException;

    @Nullable
    public DeploymentProject getDeploymentProjectForEnvironment(long var1);

    @Nullable
    public DeploymentProject getDeploymentProjectForVersion(long var1);

    @Deprecated
    public void deleteDeploymentProject(long var1);

    @NotNull
    public ErrorCollection validateAddDeploymentProject(String var1, String var2, String var3);

    @NotNull
    public ErrorCollection validateAddDeploymentProject(String var1, String var2, String var3, String var4);

    @NotNull
    public DeploymentProject addDeploymentProject(String var1, String var2, String var3) throws WebValidationException;

    @NotNull
    public ErrorCollection validateCloneDeploymentProject(String var1, String var2, String var3);

    @NotNull
    public DeploymentProject cloneDeploymentProject(long var1, String var3, String var4, String var5) throws WebValidationException;

    @NotNull
    public ErrorCollection validateEditDeploymentProject(long var1, String var3, @Nullable String var4, @Nullable String var5);

    @NotNull
    public ErrorCollection validateEditDeploymentProject(long var1, String var3, String var4, String var5, String var6);

    @NotNull
    public ErrorCollection validateArtifactTaskDefinitionOnPlanChange(long var1, String var3, @NotNull Map<String, ArtifactValidationError> var4);

    @NotNull
    public ErrorCollection validateTriggerConfigurationOnPlanChange(long var1, @NotNull PlanKey var3, @NotNull List<EnvironmentTriggerValidationError> var4);

    @NotNull
    public DeploymentProject editDeploymentProject(long var1, String var3, @Nullable String var4, String var5) throws WebValidationException;

    @NotNull
    public List<DeploymentProjectItem> getDeploymentProjectItems(long var1);

    @Nullable
    public DeploymentProjectItem getProjectItem(long var1);

    public void addArtifactProjectItem(long var1, @NotNull ArtifactDefinition var3);

    public void removeArtifactProjectItem(long var1, @NotNull ArtifactDefinition var3);

    public void removeProjectItem(long var1, long var3);

    @Nullable
    public VersionNamingScheme getVersionNamingScheme(long var1);

    @NotNull
    public String getIncrementedVersionName(@NotNull String var1);

    public boolean userHasPermissionsToChangeAutoIncrementedVariables(long var1, @NotNull Set<String> var3);

    @NotNull
    public ErrorCollection validateVersionNamingScheme(long var1, String var3, boolean var4, @NotNull Set<String> var5);

    @Deprecated
    @NotNull
    public VersionNamingScheme updateVersionNamingScheme(long var1, String var3, boolean var4, @NotNull Set<String> var5) throws WebValidationException;

    @NotNull
    public VersionNamingScheme updateVersionNamingScheme(long var1, String var3, boolean var4, boolean var5, @NotNull Set<String> var6) throws WebValidationException;

    public void unlinkDeploymentProjectsRelatedToPlan(@NotNull PlanKey var1);

    public List<DeploymentProject> getDeploymentProjectsReferencingArtifact(@NotNull Artifact var1);

    public void updatePlanKey(@NotNull PlanKey var1, @NotNull PlanKey var2);

    public void resetTriggers(@NotNull PlanKey var1);

    public int getDeploymentProjectCount();

    public Map<String, ArtifactDefinition> generateArtifactProjectItems(@NotNull MutableDeploymentProject var1);

    @NotNull
    public Collection<Long> findDeploymentProjectsInOtherStates(@NotNull VcsLocationBambooSpecsState var1);

    public DeploymentProjectWithEnvironmentForDashboard getPaginatedDeploymentsWithEnvironments(int var1, int var2, @Nullable String var3);
}

