/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.projects;

import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DeploymentProjectFunctions {
    private static final Logger log = Logger.getLogger(DeploymentProjectFunctions.class);

    private DeploymentProjectFunctions() {
    }

    public static Function<DeploymentProject, List<DeploymentProjectItem>> getDeploymentProjectItems(@NotNull DeploymentProjectService deploymentProjectService) {
        return new GetDeploymentProjectItems(deploymentProjectService);
    }

    private static class GetDeploymentProjectItems
    implements Function<DeploymentProject, List<DeploymentProjectItem>> {
        private final DeploymentProjectService deploymentProjectService;

        private GetDeploymentProjectItems(DeploymentProjectService deploymentProjectService) {
            this.deploymentProjectService = deploymentProjectService;
        }

        public List<DeploymentProjectItem> apply(@Nullable DeploymentProject deploymentProject) {
            return this.deploymentProjectService.getDeploymentProjectItems(((DeploymentProject)Preconditions.checkNotNull((Object)deploymentProject)).getId());
        }
    }
}

