/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.execution.events;

import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.execution.events.DeploymentTimingPoint;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DeploymentTimingPoints
implements DeploymentTimingPoint {
    private static final Logger log = Logger.getLogger(DeploymentTimingPoints.class);
    private final Date date;
    private final long deploymentResultId;

    protected DeploymentTimingPoints(long deploymentResultId, @NotNull Date date) {
        this.deploymentResultId = deploymentResultId;
        this.date = date;
    }

    public static ExecutionCancelled executionCancelled(@NotNull Long deploymentResultId, @NotNull Date date, boolean buildActuallyCancelled) {
        return new ExecutionCancelled(deploymentResultId, date, buildActuallyCancelled);
    }

    public static Queued queued(@NotNull DeploymentContext context, @NotNull Date date) {
        return new Queued(context, date);
    }

    public static AgentAssigned agentAssigned(@NotNull DeploymentContext context, @NotNull Date date, long agentId) {
        return new AgentAssigned(context, date, agentId);
    }

    public static ExecutionStarted executionStarted(@NotNull DeploymentContext context, @NotNull Date date) {
        return new ExecutionStarted(context, date);
    }

    public static ExecutionFinished executionFinished(@NotNull DeploymentContext context, @NotNull Date date) {
        return new ExecutionFinished(context, date);
    }

    @NotNull
    public Date getDate() {
        return this.date;
    }

    @Override
    public long getDeploymentResultId() {
        return this.deploymentResultId;
    }

    public static class ExecutionFinished
    extends DeploymentTimingPoints {
        private ExecutionFinished(@NotNull DeploymentContext context, @NotNull Date date) {
            super(context.getDeploymentResultId(), date);
        }
    }

    public static class ExecutionCancelled
    extends DeploymentTimingPoints {
        private final boolean buildActuallyCancelled;

        public ExecutionCancelled(@NotNull Long deploymentResultId, @NotNull Date date, boolean buildActuallyCancelled) {
            super(deploymentResultId, date);
            this.buildActuallyCancelled = buildActuallyCancelled;
        }

        public boolean isBuildActuallyCancelled() {
            return this.buildActuallyCancelled;
        }
    }

    public static class ExecutionStarted
    extends DeploymentTimingPoints {
        private ExecutionStarted(@NotNull DeploymentContext context, @NotNull Date date) {
            super(context.getDeploymentResultId(), date);
        }
    }

    public static class AgentAssigned
    extends DeploymentTimingPoints {
        private final long agentId;

        private AgentAssigned(@NotNull DeploymentContext context, @NotNull Date date, long agentId) {
            super(context.getDeploymentResultId(), date);
            this.agentId = agentId;
        }

        public long getAgentId() {
            return this.agentId;
        }
    }

    public static class Queued
    extends DeploymentTimingPoints {
        private Queued(@NotNull DeploymentContext context, @NotNull Date date) {
            super(context.getDeploymentResultId(), date);
        }
    }
}

