/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.DeploymentKeyImpl;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.results.InternalDeploymentResult;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeploymentResultKeyImpl
implements DeploymentResultKey {
    private static final Logger log = Logger.getLogger(DeploymentResultKeyImpl.class);
    private static final char SEPARATOR_CHAR = '-';
    private final DeploymentKey environmentKey;
    private final int deploymentResultId;

    private DeploymentResultKeyImpl(DeploymentKey environmentKey, int deploymentResultId) {
        this.environmentKey = environmentKey;
        this.deploymentResultId = deploymentResultId;
    }

    @NotNull
    public String getKey() {
        return String.format("%s-%d", this.environmentKey.getKey(), this.deploymentResultId);
    }

    @NotNull
    public Key getEntityKey() {
        return this.environmentKey;
    }

    public int getResultNumber() {
        return this.deploymentResultId;
    }

    public static DeploymentResultKeyImpl from(@NotNull DeploymentKey environmentKey, long deploymentResultId) {
        return new DeploymentResultKeyImpl(environmentKey, (int)deploymentResultId);
    }

    public static DeploymentResultKeyImpl from(@NotNull InternalEnvironment environment, @NotNull InternalDeploymentResult deploymentResult) {
        return new DeploymentResultKeyImpl(environment.getKey(), (int)deploymentResult.getId());
    }

    public static DeploymentResultKeyImpl from(@NotNull String key) {
        Object[] split = StringUtils.split((String)key, (char)'-');
        Preconditions.checkArgument((split.length > 1 ? 1 : 0) != 0);
        String deploymentKeyStr = StringUtils.join((Object[])split, (char)'-', (int)0, (int)(split.length - 1));
        DeploymentKeyImpl environmentKey = new DeploymentKeyImpl(deploymentKeyStr);
        return DeploymentResultKeyImpl.from(environmentKey, Long.valueOf((String)split[split.length - 1]));
    }

    public String toString() {
        return this.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultKey)) {
            return false;
        }
        ResultKey resultKey = (ResultKey)o;
        return this.deploymentResultId == resultKey.getResultNumber() && Objects.equal((Object)this.environmentKey, (Object)resultKey.getEntityKey());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.environmentKey, this.deploymentResultId});
    }
}

