/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configurator;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsMavenPomAccessor {
    public static final String POM_XML = "pom.xml";

    @NotNull
    public String getMavenScmProviderKey();

    public Map<String, String> parseMavenScmUrlToVcsLocation(@NotNull String var1, @Nullable VcsRepositoryData var2) throws IllegalArgumentException;

    @Nullable
    default public VcsBranch parseMavenScmUrlToVcsBranch(@NotNull String mavenScmUrl, @Nullable VcsRepositoryData existingData) throws IllegalArgumentException {
        return null;
    }

    @NotNull
    default public File findPomFileInWorkingCopy(VcsWorkingCopy checkoutDirectory, String mavenPath) throws RepositoryException {
        File candidate;
        File pomLocation = new File(checkoutDirectory.getPath(), mavenPath);
        if (pomLocation.isFile()) {
            return pomLocation;
        }
        if (pomLocation.isDirectory() && (candidate = new File(pomLocation, POM_XML)).isFile()) {
            return candidate;
        }
        throw new RepositoryException("Cannot find pom file in the specified location " + mavenPath);
    }
}

