/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CapabilitySource implements Comparable<CapabilitySource>
{
    UI(1),
    PROPERTIES_FILE(2),
    AUTO_DETECTION(4),
    SHARED(8);

    private final int mask;

    private CapabilitySource(int mask) {
        this.mask = mask;
    }

    @Nullable
    public static CapabilitySource forName(@NotNull String name) {
        try {
            return CapabilitySource.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getMask() {
        return this.mask;
    }
}

