/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection;

import com.google.common.base.Preconditions;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PartialList<E> {
    private final boolean totalSizeKnown;
    private final long totalSize;
    private final List<E> list;

    @Deprecated
    public PartialList(int totalSize, List<E> list) {
        this(list, totalSize);
    }

    private PartialList(@NotNull List<E> list, long totalSize) {
        this.totalSizeKnown = true;
        this.totalSize = totalSize;
        this.list = list;
    }

    private PartialList(@NotNull List<E> list) {
        this.totalSizeKnown = false;
        this.totalSize = -1L;
        this.list = list;
    }

    @NotNull
    public static <E> PartialList<E> ofUnknownSize(@NotNull List<E> list) {
        return new PartialList<E>(list);
    }

    @NotNull
    public static <E> PartialList<E> ofKnownSize(@NotNull List<E> list, int totalSize) {
        return PartialList.ofKnownSize(list, (long)totalSize);
    }

    @NotNull
    public static <E> PartialList<E> ofKnownSize(@NotNull List<E> list, long totalSize) {
        Preconditions.checkArgument((totalSize >= 0L ? 1 : 0) != 0, (Object)"Total size must not be negative");
        return new PartialList<E>(list, totalSize);
    }

    public boolean isTotalSizeKnown() {
        return this.totalSizeKnown;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    @NotNull
    public List<E> getList() {
        return this.list;
    }

    public boolean isCompleteList() {
        return this.totalSizeKnown && this.totalSize == (long)this.list.size();
    }
}

