/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range<E extends Number> {
    private final E min;
    private final E max;

    public static <E extends Number> Range<E> make(@NotNull E min, @NotNull E max) {
        Preconditions.checkNotNull(min, (Object)"Minimum must not be null");
        Preconditions.checkNotNull(max, (Object)"Maximum must not be null");
        Preconditions.checkArgument((((Comparable)((Object)max)).compareTo(min) >= 0 ? 1 : 0) != 0, (Object)"Maximum must not be lower than minimum");
        return new Range<E>(min, max);
    }

    @Deprecated
    public Range(@Nullable E min, @Nullable E max) {
        this.min = min;
        this.max = max;
    }

    public E getMinimum() {
        return this.min;
    }

    public E getMaximum() {
        return this.max;
    }

    boolean isValueInRange(E value) {
        return ((Comparable)value).compareTo(this.min) >= 0 && ((Comparable)value).compareTo(this.max) <= 0;
    }
}

