/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class JavaVirtualMachineDetector {
    private static final Logger log = Logger.getLogger(JavaVirtualMachineDetector.class);
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(java|openjdk) version \"(.+)\"");
    private static final String VERSION_CMD_OPTION = "-version";
    private boolean myIsRunningOnOsx;

    public JavaVirtualMachineDetector(boolean isRunningOnOsx) {
        this.myIsRunningOnOsx = isRunningOnOsx;
    }

    public String detectJavaHome(String systemJavaHome) {
        if (!this.myIsRunningOnOsx && systemJavaHome != null) {
            File systemJavaHomeDirectory = new File(systemJavaHome);
            if (this.containsJavac(systemJavaHomeDirectory)) {
                return systemJavaHome;
            }
            File parentDirectory = systemJavaHomeDirectory.getParentFile();
            if (this.containsJavac(parentDirectory)) {
                return systemJavaHomeDirectory.getParent();
            }
        }
        return systemJavaHome;
    }

    public boolean containsJavac(File givenDirectory) {
        if (this.myIsRunningOnOsx) {
            return true;
        }
        File javac = new File(givenDirectory, "bin" + File.separator + "javac");
        File javacWindows = new File(givenDirectory, "bin" + File.separator + "javac.exe");
        return javac.exists() || javacWindows.exists();
    }

    @Nullable
    public String detectExternalJdkVersion(File givenDirectory) {
        if (givenDirectory.equals(SystemUtils.getJavaHome()) || givenDirectory.equals(new File(SystemUtils.getJavaHome().getParent()))) {
            return SystemUtils.JAVA_VERSION;
        }
        return this.detectExternalJdkVersionInDirectory(givenDirectory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @VisibleForTesting
    String detectExternalJdkVersionInDirectory(File givenDirectory) {
        if (!this.containsJavac(givenDirectory)) return null;
        try {
            String javaCommand = givenDirectory + File.separator + "bin" + File.separator + "java" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
            ProcessBuilder pb = new ProcessBuilder(Lists.newArrayList((Object[])new String[]{javaCommand, VERSION_CMD_OPTION}));
            pb.redirectErrorStream(true);
            Process p = pb.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String versionLine = br.readLine();
                if (versionLine == null) return null;
                Optional<String> version = this.getJavaVersion(versionLine);
                if (version.isPresent()) {
                    String string = version.get();
                    return string;
                }
                log.warn((Object)("Can't parse output from " + javaCommand + " " + VERSION_CMD_OPTION));
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @VisibleForTesting
    Optional<String> getJavaVersion(String versionLine) {
        Matcher matcher = JAVA_VERSION_PATTERN.matcher(versionLine);
        if (matcher.find()) {
            return Optional.of(matcher.group(2));
        }
        return Optional.empty();
    }
}

