/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Internal
public class PlanBranchGist {
    private final PlanKey key;
    private final String buildName;
    private final boolean suspendedFromBuilding;
    private final PlanBranchWorkflow planBranchWorkflow;
    private final boolean divergent;

    public PlanBranchGist(PlanKey key, String buildName, boolean suspendedFromBuilding, PlanBranchWorkflow planBranchWorkflow, boolean divergent) {
        this.key = key;
        this.buildName = buildName;
        this.suspendedFromBuilding = suspendedFromBuilding;
        this.planBranchWorkflow = planBranchWorkflow;
        this.divergent = divergent;
    }

    public PlanKey getKey() {
        return this.key;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public boolean isSuspendedFromBuilding() {
        return this.suspendedFromBuilding;
    }

    public PlanBranchWorkflow getPlanBranchWorkflow() {
        return this.planBranchWorkflow;
    }

    public boolean isDivergent() {
        return this.divergent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanBranchGist that = (PlanBranchGist)o;
        return Objects.equals(this.getKey(), that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    public static class PlanNameCaseInsensitiveComparator
    implements Comparator<PlanBranchGist> {
        public static final Ordering<PlanBranchGist> ORDERING = Ordering.from((Comparator)new PlanNameCaseInsensitiveComparator());

        private PlanNameCaseInsensitiveComparator() {
        }

        @Override
        public int compare(PlanBranchGist p1, PlanBranchGist p2) {
            if (p1 == null || p2 == null) {
                return p1 == p2 ? 0 : (p1 == null ? -1 : 1);
            }
            CompareToBuilder compareToBuilder = new CompareToBuilder();
            compareToBuilder.append((Object)p1.getBuildName(), (Object)p2.getBuildName(), String.CASE_INSENSITIVE_ORDER);
            return compareToBuilder.toComparison();
        }
    }
}

