/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.BambooCacheStats;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.atlassian.bamboo.utils.Range;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface ImmutablePlanCacheService {
    @Nullable
    public ImmutableChain getImmutablePlanByKey(@NotNull PlanKey var1);

    @NotNull
    public <T extends ImmutablePlan> Stream<T> getPlans(Class<T> var1, @NotNull com.google.common.base.Predicate<? super T> var2);

    public <V> V withHiddenPlans(Collection<PlanKey> var1, Supplier<V> var2);

    @Nullable
    public ImmutableChain getImmutableChainByKeyIfInCache(@NotNull PlanKey var1);

    public void invalidate(@NotNull PlanKey var1);

    public void cascadeInvalidate(@NotNull PlanKey var1);

    public void remove(@NotNull PlanKey var1);

    public void initialiseCache();

    public void disableCache();

    public void enableCache();

    public BambooCacheStats getCacheStats();

    @Internal
    public void getChainsToInvalidateAndReindex(CacheInvalidator var1, Set<PlanKey> var2, Set<PlanKey> var3);

    @NotNull
    public PlanCacheIndices getIndices();

    @Deprecated
    @Internal
    @NotNull
    public Range<Integer> getBuildNumbersRange(PlanKey var1);

    @Deprecated
    @Internal
    public void invalidateBuildNumbersRange(PlanKey var1, int var2, boolean var3);

    public Stream<ImmutablePlan> getPlans(Predicate<ImmutablePlan> var1);

    public Optional<ImmutableChain> getAnyPlan(Predicate<? super ImmutableChain> var1);

    public void invalidateLatestResultSummary(PlanResultKey var1);

    public void invalidateAllLatestResultSummaries();

    @Internal
    public void indexPlan(@NotNull ImmutableChain var1);

    public void hideDeletedPlan(PlanKey var1);

    public void hideDeletedStage(Long var1);

    public boolean isPlanBeingDeleted(PlanKey var1);

    public void enterDeletionCodeSection();

    public void leaveDeletionCodeSection();

    @NotNull
    public <T extends ImmutableJob> Set<T> filterOutDeletedIfNeeded(@NotNull Set<T> var1);

    @NotNull
    public <T extends ImmutableChainStage> List<T> filterOutDeletedIfNeeded(@NotNull List<T> var1);

    public void onStageDeleted(long var1);

    @Internal
    public static interface CacheInvalidator {
        public String getDescription();

        public void getChainsToInvalidateAndReindex(@NotNull ImmutablePlanCacheService var1, Cache<PlanKey, ImmutableChain> var2, Set<PlanKey> var3, Set<PlanKey> var4);
    }
}

