/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import java.util.Optional;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

@ExperimentalApi
public class ChainBranchCreationResult {
    private final PlanKey planKey;
    private final VcsBranch vcsBranch;
    private final Future<Boolean> specsDetectionFuture;

    public ChainBranchCreationResult(@NotNull PlanKey planKey, @NotNull VcsBranch vcsBranch) {
        this(planKey, vcsBranch, null);
    }

    public ChainBranchCreationResult(@NotNull PlanKey planKey, @NotNull VcsBranch vcsBranch, @NotNull Future<Boolean> specsDetectionFuture) {
        this.planKey = planKey;
        this.vcsBranch = vcsBranch;
        this.specsDetectionFuture = specsDetectionFuture;
    }

    public boolean isSpecsDetectionEnqueued() {
        return this.specsDetectionFuture != null;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.vcsBranch;
    }

    @NotNull
    public Future<Boolean> getSpecsDetectionFuture() {
        return Optional.ofNullable(this.specsDetectionFuture).orElseThrow(() -> new IllegalStateException("Not a specs detection future"));
    }
}

