/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.docker;

import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.docker.PortMapping;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public class RunConfig {
    private final Optional<String> command;
    private final Optional<String> containerName;
    private final List<PortMapping> ports;
    private final List<DataVolume> volumes;
    private final Optional<String> workDir;
    private final boolean detach;
    private final Map<String, String> links;
    private final Map<String, String> env;
    private List<String> passedEnv;
    private final Optional<String> additionalArgs;
    private final List<String> tokenizedAdditionalArgs;
    private final boolean useInitialisingScript;

    private RunConfig(@NotNull Builder builder) {
        this.command = builder.command;
        this.containerName = builder.containerName;
        this.ports = Collections.unmodifiableList(builder.ports);
        this.volumes = Collections.unmodifiableList(builder.volumes);
        this.workDir = builder.workDir;
        this.detach = builder.detach;
        this.links = Collections.unmodifiableMap(builder.links);
        this.env = Collections.unmodifiableMap(builder.env);
        this.passedEnv = Collections.unmodifiableList(builder.passedEnv);
        this.additionalArgs = builder.additionalArgs;
        this.tokenizedAdditionalArgs = Collections.unmodifiableList(builder.tokenizedAdditionalArgs);
        this.useInitialisingScript = builder.useInitialisingScript;
    }

    @NotNull
    public Optional<String> getCommand() {
        return this.command;
    }

    @NotNull
    public Optional<String> getContainerName() {
        return this.containerName;
    }

    @NotNull
    public List<PortMapping> getPorts() {
        return this.ports;
    }

    @NotNull
    public List<DataVolume> getVolumes() {
        return this.volumes;
    }

    @NotNull
    public Optional<String> getWorkDir() {
        return this.workDir;
    }

    public boolean isDetach() {
        return this.detach;
    }

    @NotNull
    public Map<String, String> getLinks() {
        return this.links;
    }

    @NotNull
    public Map<String, String> getEnv() {
        return this.env;
    }

    @NotNull
    public List<String> getPassedEnv() {
        return this.passedEnv;
    }

    @NotNull
    public Optional<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    @NotNull
    public List<String> getTokenizedAdditionalArgs() {
        return this.tokenizedAdditionalArgs;
    }

    public boolean isUseInitialisingScript() {
        return this.useInitialisingScript;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<String> command = Optional.empty();
        private Optional<String> containerName = Optional.empty();
        private List<PortMapping> ports = Collections.emptyList();
        private List<DataVolume> volumes = Collections.emptyList();
        private Optional<String> workDir = Optional.empty();
        private boolean detach = false;
        private Map<String, String> links = Collections.emptyMap();
        private Map<String, String> env = Collections.emptyMap();
        private List<String> passedEnv = Collections.emptyList();
        private Optional<String> additionalArgs = Optional.empty();
        private List<String> tokenizedAdditionalArgs = Collections.emptyList();
        private boolean useInitialisingScript;

        private Builder() {
        }

        @NotNull
        public Builder command(@NotNull String command) {
            this.command = Optional.of(command);
            return this;
        }

        @NotNull
        public Builder containerName(@NotNull String containerName) {
            this.containerName = Optional.of(containerName);
            return this;
        }

        @NotNull
        public Builder ports(@NotNull List<PortMapping> ports) {
            this.ports = ports;
            return this;
        }

        @NotNull
        public Builder volumes(@NotNull List<DataVolume> volumes) {
            this.volumes = volumes;
            return this;
        }

        @NotNull
        public Builder workDir(@NotNull String workDir) {
            this.workDir = Optional.of(workDir);
            return this;
        }

        @NotNull
        public Builder detach(boolean detach) {
            this.detach = detach;
            return this;
        }

        @NotNull
        public Builder links(@NotNull Map<String, String> links) {
            this.links = links;
            return this;
        }

        @NotNull
        public Builder env(@NotNull Map<String, String> env) {
            this.env = env;
            return this;
        }

        @NotNull
        public Builder passedEnv(List<String> dockerEnv) {
            this.passedEnv = dockerEnv;
            return this;
        }

        @NotNull
        public Builder additionalArgs(@NotNull String additionalArgs) {
            this.additionalArgs = Optional.of(additionalArgs);
            return this;
        }

        @NotNull
        public Builder tokenizedAdditionalArgs(@NotNull List<String> additionalArgs) {
            this.tokenizedAdditionalArgs = additionalArgs;
            return this;
        }

        @NotNull
        public Builder useInitialisingScript(boolean useInitialisingScript) {
            this.useInitialisingScript = useInitialisingScript;
            return this;
        }

        @NotNull
        public RunConfig build() {
            return new RunConfig(this);
        }
    }
}

