/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.core;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum BambooEntityType {
    CHAIN(1),
    STAGE(2),
    JOB(3),
    REPOSITORY(4),
    CHAIN_BRANCH(5),
    JOB_BRANCH(6),
    TASK(7),
    PROJECT(8),
    ARTIFACT_DEFINITION(9),
    DEPLOYMENT_PROJECT(10),
    SHARED_CREDENTIAL(11);

    private static final Map<Integer, BambooEntityType> ENTITY_TYPE_MAP;
    private final int typeId;

    private BambooEntityType(int typeId) {
        this.typeId = typeId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    @NotNull
    public static BambooEntityType fromTypeId(int typeId) {
        return Optional.ofNullable(ENTITY_TYPE_MAP.get(typeId)).orElseThrow(() -> new IllegalArgumentException("No BambooEntityType found with ID: " + typeId));
    }

    static {
        ENTITY_TYPE_MAP = Arrays.stream(BambooEntityType.values()).collect(Collectors.toMap(BambooEntityType::getTypeId, Function.identity()));
    }
}

