/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.annotations.ExperimentalApi;
import java.io.Serializable;

@ExperimentalApi
public class LookAndFeelConfiguration
implements Serializable {
    public static final String DEFAULT_LOGO_PATH = "/attachments/logos/bamboo-logo.png";
    public static final String DEFAULT_LOGO_URL = "/plugins/servlet/com.atlassian.bamboo.plugins.lookandfeel.resources?resource=logo";
    public static final String DEFAULT_FAVICON_PATH = "/attachments/logos/bamboo-favicon.ico";
    public static final String DEFAULT_FAVICON_URL = "/plugins/servlet/com.atlassian.bamboo.plugins.lookandfeel.resources?resource=favicon";
    public static final String DEFAULT_PRIMARY_HEADER_COLOR = "#0747a6";
    public static final String DEFAULT_SECONDARY_HEADER_COLOR = "#0065ff";
    private final String logoPath;
    private final String faviconPath;
    private final String primaryHeaderColor;
    private final String secondaryHeaderColor;

    public LookAndFeelConfiguration() {
        this(DEFAULT_PRIMARY_HEADER_COLOR, DEFAULT_SECONDARY_HEADER_COLOR);
    }

    public LookAndFeelConfiguration(String primaryHeaderColor, String secondaryHeaderColor) {
        this(DEFAULT_LOGO_PATH, DEFAULT_FAVICON_PATH, primaryHeaderColor, secondaryHeaderColor);
    }

    private LookAndFeelConfiguration(String logoPath, String faviconPath, String primaryHeaderColor, String secondaryHeaderColor) {
        this.logoPath = logoPath;
        this.faviconPath = faviconPath;
        this.primaryHeaderColor = primaryHeaderColor;
        this.secondaryHeaderColor = secondaryHeaderColor;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public String getLogoResourceUrl() {
        return DEFAULT_LOGO_URL;
    }

    public String getFaviconPath() {
        return this.faviconPath;
    }

    public String getFaviconResourceUrl() {
        return DEFAULT_FAVICON_URL;
    }

    public String getDefaultPrimaryHeaderColor() {
        return DEFAULT_PRIMARY_HEADER_COLOR;
    }

    public String getDefaultSecondaryHeaderColor() {
        return DEFAULT_SECONDARY_HEADER_COLOR;
    }

    public String getPrimaryHeaderColor() {
        return this.primaryHeaderColor;
    }

    public String getSecondaryHeaderColor() {
        return this.secondaryHeaderColor;
    }

    protected Object readResolve() {
        return this;
    }

    public static enum LessVariables {
        PRIMARY_HEADER_COLOR("primaryHeaderColor"),
        SECONDARY_HEADER_COLOR("secondaryHeaderColor");

        public String lessPropertyName;

        private LessVariables(String lessPropertyName) {
            this.lessPropertyName = lessPropertyName;
        }
    }
}

