/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.collections.message;

import com.atlassian.bamboo.collections.message.FinalCollectionUtils;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinalArrayList<E>
extends ArrayList<E> {
    public FinalArrayList() {
        this.assertNoInheritance();
    }

    public FinalArrayList(int initialCapacity) {
        super(initialCapacity);
        this.assertNoInheritance();
    }

    public FinalArrayList(@NotNull Collection<? extends E> c) {
        super(c);
        this.assertNoInheritance();
    }

    public FinalArrayList(@NotNull Iterable<? extends E> iterable) {
        super(Iterables.size(iterable));
        this.assertNoInheritance();
        Iterables.addAll((Collection)this, iterable);
    }

    private void assertNoInheritance() {
        FinalCollectionUtils.failIfClassDifferent(this.getClass(), FinalArrayList.class);
    }

    @Contract(value="!null -> !null")
    public static <E> FinalArrayList<E> nullOrCopy(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            return null;
        }
        return new FinalArrayList<E>(iterable);
    }
}

