/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggerWithoutLogAccess;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class LoggerId<T extends Key>
implements Serializable {
    protected final T key;
    private volatile boolean isPersistent;

    LoggerId(T key, boolean isPersistent) {
        this.key = key;
        this.isPersistent = isPersistent;
    }

    @NotNull
    public BuildLogger getLogger(@NotNull BuildLoggerManager buildLoggerManager) {
        return buildLoggerManager.getLogger((Key)this.key);
    }

    public BuildLoggerWithoutLogAccess getLoggerWithoutLogAccess(BuildLoggerManager buildLoggerManager) {
        return buildLoggerManager.getLoggerWithoutLogAccess(this);
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void disablePersisting() {
        this.isPersistent = false;
    }

    public abstract File getLogFileDirectory();

    public abstract String getLogFileName();

    public T getKey() {
        return this.key;
    }

    public String toString() {
        return "Logger for " + this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggerId loggerId = (LoggerId)o;
        return Objects.equals(this.key, loggerId.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String getLinePrefix() {
        return "";
    }
}

