/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.core.ResultKeyProvider;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.queue.AgentQueueAccessor;
import com.atlassian.bamboo.v2.build.queue.BuildQueuePosition;
import java.util.Collection;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
@ThreadSafe
public interface BuildQueueManager
extends AgentQueueAccessor {
    public static final String DISABLE_BUILD_SYSTEM_PROPERTY = "atlassian.bamboo.build.disable";

    public void addToQueue(@NotNull CommonContext var1);

    public void removeBuildFromQueue(@NotNull ResultKey var1);

    @Nullable
    public QueueItemView<CommonContext> peekContext(@NotNull ResultKey var1);

    public boolean reorderInQueue(ResultKey var1, int var2);

    @NotNull
    public BuildQueuePosition getQueuePosition(@NotNull ResultKey var1);

    public void invalidateExecutors(@NotNull String var1);

    public void invalidateExecutors(@NotNull Key var1);

    public void invalidateExecutables(@NotNull BuildAgent var1);

    @NotNull
    public Iterable<QueuedResultKey> getQueuedExecutables();

    @Nullable
    public Collection<ElasticImageConfiguration> getImagesForQueuedExecutable(@NotNull ResultKey var1);

    @Nullable
    public Set<Long> getExecutorsForQueuedExecutable(@NotNull ResultKey var1);

    public void restoreState(Set<ResultKey> var1);

    public static final class QueueItemView<T> {
        private final QueuedResultKey queuedResultKey;
        private final T view;

        public QueueItemView(@NotNull QueuedResultKey queuedResultKey, T view) {
            this.queuedResultKey = queuedResultKey;
            this.view = view;
        }

        @NotNull
        public QueuedResultKey getQueuedResultKey() {
            return this.queuedResultKey;
        }

        public T getView() {
            return this.view;
        }
    }

    public static final class QueuedResultKey
    implements ResultKeyProvider {
        private final long timestamp;
        private final ResultKey resultKey;

        public QueuedResultKey(@NotNull ResultKey resultKey, long timestamp) {
            this.timestamp = timestamp;
            this.resultKey = resultKey;
        }

        @Override
        @NotNull
        public ResultKey getResultKey() {
            return this.resultKey;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueuedResultKey that = (QueuedResultKey)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            return this.resultKey.equals(that.resultKey);
        }

        public String toString() {
            return "QueuedResultKey{resultKey=" + this.resultKey + ", timestamp=" + this.timestamp + '}';
        }

        public int hashCode() {
            return (int)(this.timestamp ^ this.timestamp >>> 32);
        }
    }
}

