/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.interceptors.ContentMatchingInterceptor;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class TaskResultBuilder {
    private static final Logger log = Logger.getLogger(TaskResultBuilder.class);
    private final CommonTaskContext taskContext;
    private final Map<String, String> taskResultData;
    private TaskState taskState;
    private boolean stopJobExecutionAfterTask;

    private TaskResultBuilder(@NotNull CommonTaskContext taskContext) {
        this.taskContext = taskContext;
        this.taskState = TaskState.SUCCESS;
        this.taskResultData = new HashMap<String, String>();
    }

    public static TaskResultBuilder newBuilder(@NotNull CommonTaskContext taskContext) {
        return new TaskResultBuilder(taskContext);
    }

    @Deprecated
    public static TaskResultBuilder create(@NotNull TaskContext taskContext) {
        return new TaskResultBuilder(taskContext);
    }

    public static TaskResult copyWithNewState(@NotNull TaskResult taskResult, @NotNull TaskState newTaskState) {
        return new TaskResultImpl(newTaskState, taskResult.getTaskIdentifier(), taskResult.getResultData(), taskResult.shouldStopExecution());
    }

    public static TaskResult createFailedWithErrorResult(TaskIdentifier taskIdentifier) {
        return new TaskResultImpl(TaskState.ERROR, taskIdentifier, null);
    }

    public TaskResultBuilder success() {
        this.taskState = TaskState.SUCCESS;
        return this;
    }

    public TaskResultBuilder failed() {
        this.taskState = TaskState.FAILED;
        return this;
    }

    public TaskResultBuilder failedWithError() {
        this.taskState = TaskState.ERROR;
        return this;
    }

    public TaskResultBuilder checkReturnCode(@NotNull ExternalProcess externalProcess) {
        return this.checkReturnCode(externalProcess, 0);
    }

    public TaskResultBuilder checkReturnCode(@NotNull ExternalProcess externalProcess, int expectedReturnCode) {
        int exitCode = externalProcess.getHandler().getExitCode();
        if (this.taskState == TaskState.SUCCESS && exitCode != expectedReturnCode) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            String logString = String.format("Failing task since return code of [%s] was %d while expected %d", externalProcess.getCommandLine(), exitCode, expectedReturnCode);
            logString = PasswordMaskingUtils.maskPossiblePasswordValues(logString, this.taskContext.getCommonContext().getVariableContext());
            log.info((Object)buildLogger.addBuildLogEntry(logString));
            ProcessException e = externalProcess.getHandler().getException();
            if (e != null) {
                log.info((Object)"Process exception: ", (Throwable)e);
            }
            this.taskState = TaskState.FAILED;
        }
        return this;
    }

    public TaskResultBuilder checkTestFailures() {
        if (this.taskState == TaskState.SUCCESS) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            CurrentResult currentResult = this.taskContext.getCommonContext().getCurrentResult();
            CurrentBuildResult buildResult = Narrow.to(currentResult, CurrentBuildResult.class);
            if (buildResult != null) {
                int skippedTestResultsCount;
                Collection<TestResults> successfulTestResults = buildResult.getSuccessfulTestResults();
                Collection<TestResults> failedTestResults = buildResult.getFailedTestResults();
                Collection<TestResults> skippedTestResults = buildResult.getSkippedTestResults();
                int successfulTestResultsCount = successfulTestResults != null ? successfulTestResults.size() : 0;
                int failedTestResultsCount = failedTestResults != null ? failedTestResults.size() : 0;
                int n = skippedTestResultsCount = skippedTestResults != null ? skippedTestResults.size() : 0;
                if (buildResult.getParserErrorsCount() > 0) {
                    log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since %d parsing errors occurred.", buildResult.getParserErrorsCount())));
                    this.taskState = TaskState.ERROR;
                } else if (failedTestResultsCount > 0) {
                    log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since %d failing test cases were found.", failedTestResultsCount)));
                    this.taskState = TaskState.FAILED;
                } else if (successfulTestResultsCount == 0 && skippedTestResultsCount == 0) {
                    log.info((Object)buildLogger.addBuildLogEntry("Failing task since test cases were expected but none were found."));
                    this.taskState = TaskState.FAILED;
                }
            } else {
                throw new UnsupportedOperationException("This method should be called only for build execution");
            }
        }
        return this;
    }

    public TaskResultBuilder checkInterceptorMatches(@NotNull ContentMatchingInterceptor interceptor, int maximumAge) {
        if (this.taskState == TaskState.SUCCESS && !interceptor.isMatchRecentEnough(maximumAge)) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since text '%s' was not found in last %d log entries", interceptor.getStringToMatch(), maximumAge)));
            this.taskState = TaskState.FAILED;
        }
        return this;
    }

    public TaskResultBuilder checkInterceptorNotMatches(@NotNull ContentMatchingInterceptor interceptor, int maximumAge) {
        if (this.taskState == TaskState.SUCCESS && interceptor.isMatchRecentEnough(maximumAge)) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since text '%s' was found in last %d log entries", interceptor.getStringToMatch(), maximumAge)));
            this.taskState = TaskState.FAILED;
        }
        return this;
    }

    public TaskResult build() {
        TaskResultImpl taskResult = new TaskResultImpl(this.taskState, this.taskContext, this.taskResultData, this.stopJobExecutionAfterTask);
        return taskResult;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public TaskResultBuilder setState(TaskState taskState) {
        this.taskState = taskState;
        return this;
    }

    public TaskResultBuilder stopJobExecutionAfterTask() {
        this.stopJobExecutionAfterTask = true;
        return this;
    }

    private static final class TaskResultImpl
    implements TaskResult {
        private static final Logger log = Logger.getLogger(TaskResultImpl.class);
        private final TaskState taskState;
        private final MinimalTaskIdentifier taskIdentifier;
        private final FinalHashMap<String, String> data;
        private final boolean stopJobExecutionAfterTask;

        public TaskResultImpl(@NotNull TaskState taskState, @NotNull CommonTaskContext taskContext) {
            this(taskState, taskContext, null, false);
        }

        public TaskResultImpl(@NotNull TaskState taskState, @NotNull TaskIdentifier taskIdentifier, @Nullable Map<String, String> taskResultData) {
            this(taskState, taskIdentifier, taskResultData, false);
        }

        public TaskResultImpl(@NotNull TaskState taskState, @NotNull TaskIdentifier taskIdentifier, @Nullable Map<String, String> taskResultData, boolean stopJobExecutionAfterTask) {
            this.taskState = taskState;
            this.taskIdentifier = new MinimalTaskIdentifier(taskIdentifier);
            this.data = taskResultData != null ? new FinalHashMap<String, String>(taskResultData) : new FinalHashMap();
            this.stopJobExecutionAfterTask = stopJobExecutionAfterTask;
        }

        @Override
        @NotNull
        public TaskState getTaskState() {
            return this.taskState;
        }

        @Override
        @NotNull
        public Map<String, String> getResultData() {
            return this.data;
        }

        @Override
        @NotNull
        public TaskIdentifier getTaskIdentifier() {
            return this.taskIdentifier;
        }

        @Override
        public boolean shouldStopExecution() {
            return this.stopJobExecutionAfterTask;
        }
    }

    private static final class MinimalTaskIdentifier
    implements TaskIdentifier,
    Serializable {
        private final long id;
        private final String pluginKey;
        private final String userDescription;
        private final boolean isEnabled;
        private final boolean finalising;

        public MinimalTaskIdentifier(@NotNull TaskIdentifier taskIdentifier) {
            this.id = taskIdentifier.getId();
            this.pluginKey = taskIdentifier.getPluginKey();
            this.userDescription = taskIdentifier.getUserDescription();
            this.isEnabled = taskIdentifier.isEnabled();
            this.finalising = taskIdentifier.isFinalising();
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getPluginKey() {
            return this.pluginKey;
        }

        @Override
        @Nullable
        public String getUserDescription() {
            return this.userDescription;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public boolean isFinalising() {
            return this.finalising;
        }
    }
}

