/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AclEntriesStatistics {
    private final Map<String, AclEntryStatistics> statsByJavaType;

    public AclEntriesStatistics() {
        this(new HashMap<String, AclEntryStatistics>());
    }

    public AclEntriesStatistics(Map<String, AclEntryStatistics> statsByJavaType) {
        this.statsByJavaType = statsByJavaType;
    }

    public Map<String, AclEntryStatistics> getStatsByJavaType() {
        return Collections.unmodifiableMap(this.statsByJavaType);
    }

    public void put(String clazz, BambooPermission permission, Long count) {
        AclEntryStatistics entry = this.statsByJavaType.getOrDefault(clazz, new AclEntryStatistics());
        entry.put(permission, count);
        this.statsByJavaType.put(clazz, entry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AclEntriesStatistics that = (AclEntriesStatistics)o;
        return Objects.equals(this.statsByJavaType, that.statsByJavaType);
    }

    public int hashCode() {
        return Objects.hash(this.statsByJavaType);
    }

    public String toString() {
        return "AclEntriesStatistics{" + this.statsByJavaType + '}';
    }

    public static class AclEntryStatistics {
        private final Map<String, Long> statsByPermissionName;

        public AclEntryStatistics() {
            this(new HashMap<String, Long>());
        }

        public AclEntryStatistics(Map<String, Long> statsByPermissionName) {
            this.statsByPermissionName = statsByPermissionName;
        }

        public Map<String, Long> getStatsByPermissionName() {
            return Collections.unmodifiableMap(this.statsByPermissionName);
        }

        public void put(BambooPermission permission, Long count) {
            this.statsByPermissionName.put(permission.getName(), count);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AclEntryStatistics that = (AclEntryStatistics)o;
            return Objects.equals(this.statsByPermissionName, that.statsByPermissionName);
        }

        public int hashCode() {
            return Objects.hash(this.statsByPermissionName);
        }

        public String toString() {
            return this.statsByPermissionName.toString();
        }
    }
}

