/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.Instance;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public interface ElasticFunctionalityFacade {
    public static final int DEFAULT_ALLOWED_AGENTS = 5;

    @NotNull
    public String getKeyPairName();

    public void recheckElasticSupportEnabledFlag();

    public void shutdownInstance(@NotNull RemoteElasticInstance var1);

    public void shutdownInstance(String var1) throws AWSException;

    public void shutdownAllInstances();

    public void startupAgents(@NotNull Collection<ElasticImageConfiguration> var1) throws AWSException;

    public boolean validateAgentCreation(int var1, ErrorCollection var2);

    public void restoreAgent(@NotNull ElasticAgentDefinition var1, @NotNull Instance var2, @NotNull AWSAccount var3);

    public boolean isElasticSupportEnabled();

    public void setElasticSupportEnabled(boolean var1);

    public boolean isElasticSupportPossible(@NotNull ErrorCollection var1);

    @NotNull
    public String getPkFileLocation();

    @NotNull
    public Either<Ec2PrivateKeyValidationStatus, File> getPrivateKeyLocation();

    public int getMaxConcurrentInstances();

    public void updateAgentPendingStatus(String var1);

    public void addElasticLogEntry(Logger var1, String var2);

    public void adjustElasticInstanceNumbers(@NotNull ElasticInstanceSchedule var1) throws AWSException;

    @Deprecated
    @NotNull
    public Either<Ec2PrivateKeyValidationStatus, Option<String>> getPassword(RemoteElasticInstance var1);

    @NotNull
    public io.atlassian.fugue.Either<Ec2PrivateKeyValidationStatus, Optional<String>> getPassword2(RemoteElasticInstance var1);

    public static enum Ec2PrivateKeyValidationStatus {
        VALIDATION_SUCCESSFUL,
        KEYPAIR_FILE_DOES_NOT_EXIST,
        KEYPAIR_DOES_NOT_EXIST_ON_ACCOUNT,
        KEYPAIR_UNREADABLE,
        KEYPAIR_CANNOT_PARSE,
        KEYPAIR_UNABLE_TO_VALIDATE,
        KEYPAIR_MISMATCH;

    }
}

