/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.annotations.Internal;
import com.google.common.base.Function;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class CommandlineStringUtils {
    private static final Logger log = Logger.getLogger(CommandlineStringUtils.class);

    private CommandlineStringUtils() {
    }

    @NotNull
    public static List<String> tokeniseCommandline(@Nullable String toProcess) {
        try {
            return CommandlineStringUtils.internalTokeniseCommandline(toProcess);
        }
        catch (ParseException e) {
            log.warn((Object)"Could not parse commandline string", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    public static Function<String, List<String>> tokeniseCommandlineFunction() {
        return CommandlineStringUtils::tokeniseCommandline;
    }

    @NotNull
    private static List<String> internalTokeniseCommandline(@Nullable String toProcess) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        if (toProcess == null || toProcess.length() == 0) {
            return result;
        }
        ParserState state = ParserState.NORMAL;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case QUOTE: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = ParserState.NORMAL;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case DOUBLE_QUOTE: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = ParserState.NORMAL;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = ParserState.QUOTE;
                current.append(nextTok);
            } else if ("\"".equals(nextTok)) {
                state = ParserState.DOUBLE_QUOTE;
                current.append(nextTok);
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == ParserState.QUOTE || state == ParserState.DOUBLE_QUOTE) {
            throw new ParseException("Unbalanced quotes in " + toProcess, toProcess.length());
        }
        return result;
    }

    static enum ParserState {
        NORMAL,
        QUOTE,
        DOUBLE_QUOTE;

    }
}

