/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.statistics;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class FailurePeriod {
    private static final Logger log = Logger.getLogger(FailurePeriod.class);
    private List<ResultsSummary> alsoFailingInBuilds = new ArrayList<ResultsSummary>();
    private ResultsSummary fixingBuild;
    private ResultsSummary breakingBuild;
    private ResultsSummary removedInBuild;
    private final ImmutablePlan plan;

    public FailurePeriod(ImmutablePlan plan) {
        this.plan = plan;
    }

    public boolean includesBuild(Integer buildNumber) {
        if (buildNumber == null) {
            return false;
        }
        if (buildNumber.equals(this.breakingBuild.getBuildNumber())) {
            return true;
        }
        return this.alsoFailingInBuilds.stream().mapToInt(ResultStatisticsProvider::getBuildNumber).anyMatch(buildNumber::equals);
    }

    public long getElapsedTime() {
        if (this.getBreakingBuild() == null) {
            return 0L;
        }
        long start = this.getBreakingBuild().getStatDate().getTime();
        long end = this.getFixingBuild() != null ? this.getFixingBuild().getStatDate().getTime() : (this.getRemovedInBuild() != null ? this.getRemovedInBuild().getStatDate().getTime() : System.currentTimeMillis());
        return end - start;
    }

    public int getElapsedBuilds() {
        ResultsSummary fixingBuild = this.getFixingBuild();
        if (fixingBuild != null) {
            return fixingBuild.getBuildNumber() - this.getBreakingBuild().getBuildNumber();
        }
        ResultsSummary removedInBuild = this.getRemovedInBuild();
        if (removedInBuild != null) {
            return removedInBuild.getBuildNumber() - this.getBreakingBuild().getBuildNumber();
        }
        return this.plan.getLastBuildNumber() - this.getBreakingBuild().getBuildNumber();
    }

    public void addFailingBuild(ResultsSummary build) {
        if (this.breakingBuild == null) {
            this.breakingBuild = build;
        } else {
            this.alsoFailingInBuilds.add(build);
        }
    }

    public ResultsSummary getBreakingBuild() {
        return this.breakingBuild;
    }

    public void setBreakingBuild(ResultsSummary breakingBuild) {
        this.breakingBuild = breakingBuild;
    }

    public List getAlsoFailingInBuilds() {
        return this.alsoFailingInBuilds;
    }

    public void setAlsoFailingInBuilds(List<ResultsSummary> alsoFailingInBuilds) {
        this.alsoFailingInBuilds = alsoFailingInBuilds;
    }

    public ResultsSummary getFixingBuild() {
        return this.fixingBuild;
    }

    public void setFixingBuild(ResultsSummary fixingBuild) {
        this.fixingBuild = fixingBuild;
    }

    public ResultsSummary getRemovedInBuild() {
        return this.removedInBuild;
    }

    public void setRemovedInBuild(ResultsSummary removedInBuild) {
        this.removedInBuild = removedInBuild;
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 79).append((Object)this.getBreakingBuild()).append((Object)this.getFixingBuild()).append((Object)this.getRemovedInBuild()).append((Object)this.getAlsoFailingInBuilds()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FailurePeriod)) {
            return false;
        }
        FailurePeriod rhs = (FailurePeriod)o;
        return new EqualsBuilder().append((Object)this.getBreakingBuild(), (Object)rhs.getBreakingBuild()).append((Object)this.getFixingBuild(), (Object)rhs.getFixingBuild()).append((Object)this.getRemovedInBuild(), (Object)rhs.getRemovedInBuild()).append((Object)this.getAlsoFailingInBuilds(), (Object)rhs.getAlsoFailingInBuilds()).isEquals();
    }

    public int compareTo(Object obj) {
        FailurePeriod o = (FailurePeriod)obj;
        return new CompareToBuilder().append(this.getBreakingBuild().getBuildNumber(), o.getBreakingBuild().getBuildNumber()).toComparison();
    }
}

