/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.DoubleThrowingPredicate;
import com.atlassian.bamboo.util.ThrowingPredicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BambooIterables {
    private BambooIterables() {
    }

    @Nullable
    public static <T, E extends Throwable> T find(@NotNull Iterable<T> iterable, @NotNull ThrowingPredicate<? super T, E> predicate, @Nullable T defaultValue) throws E {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    @Nullable
    public static <T, E extends Throwable, F extends Throwable> T find(@NotNull Iterable<T> iterable, @NotNull DoubleThrowingPredicate<? super T, E, F> predicate, @Nullable T defaultValue) throws E, F {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    @Deprecated
    public static <T> T find(Iterable<T> iterable, com.google.common.base.Predicate<? super T> predicate, @Nullable String exceptionMessage) {
        return (T)BambooIterables.find(iterable, arg_0 -> predicate.apply(arg_0), exceptionMessage);
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate, @Nullable String exceptionMessage) {
        return BambooIterables.stream(iterable).filter(predicate).findFirst().orElseThrow(() -> new NoSuchElementException(exceptionMessage));
    }

    @Deprecated
    public static <T> boolean none(@NotNull Iterable<T> iterable, @NotNull com.google.common.base.Predicate<? super T> predicate) {
        return BambooIterables.none(iterable, arg_0 -> predicate.apply(arg_0));
    }

    public static <T> boolean none(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        return BambooIterables.stream(iterable).noneMatch(predicate);
    }

    public static <T> Iterable<T> concat(@NotNull Iterable<? extends T> iterable, @NotNull T object) {
        return () -> Stream.concat(BambooIterables.stream(iterable), Stream.of(object)).iterator();
    }

    public static <T> Iterable<T> concat(@NotNull T object, @NotNull Iterable<? extends T> iterable) {
        return () -> Stream.concat(Stream.of(object), BambooIterables.stream(iterable)).iterator();
    }

    @Deprecated
    @Nullable
    public static <T> T removeFirst(@NotNull Iterable<T> iterable, @NotNull com.google.common.base.Predicate<T> predicate) {
        return (T)BambooIterables.removeFirst(iterable, arg_0 -> predicate.apply(arg_0));
    }

    @Nullable
    public static <T> T removeFirst(@NotNull Iterable<T> iterable, @NotNull Predicate<T> predicate) {
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T object = iterator.next();
            if (!predicate.test(object)) continue;
            iterator.remove();
            return object;
        }
        return null;
    }

    public static boolean hasSize(@NotNull Iterable<?> iterable, int size) {
        Iterator<?> iterator = iterable.iterator();
        int numSkipped = Iterators.advance(iterator, (int)size);
        return numSkipped == size && !iterator.hasNext();
    }

    @NotNull
    public static <T> Stream<T> stream(@NotNull Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NotNull
    public static <T> T getFirst(@NotNull Iterable<? extends T> iterable) {
        return iterable.iterator().next();
    }

    @NotNull
    public static <T> T getFirstOrElse(@Nullable Iterable<T> iterable, @NotNull Supplier<T> supplier) {
        return (T)Optional.ofNullable(iterable).map(Iterable::iterator).filter(Iterator::hasNext).map(Iterator::next).orElseGet(supplier);
    }

    @NotNull
    public static <T> Iterable<T> iterable(@NotNull Supplier<Iterator<T>> supplier) {
        return supplier::get;
    }

    public static <T> boolean removeAll(@NotNull Iterable<T> iterable, @Nullable T o) {
        boolean modified = false;
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next(), o)) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public static <T> Iterable<T> filter(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        return () -> BambooIterables.stream(iterable).filter(predicate).iterator();
    }

    public static <T, U> Iterable<U> transform(@NotNull Iterable<T> iterable, @NotNull Function<? super T, U> function) {
        return () -> BambooIterables.stream(iterable).map(function).iterator();
    }
}

