/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.commit.UnassociatedCommit;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ExpiryCriteria;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCreationException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.Range;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.variable.VariableContext;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface ResultsSummaryManager {
    public <T extends ResultsSummary> T createResultsSummary(@NotNull BuildContext var1, @NotNull Class<T> var2) throws ResultsSummaryCreationException;

    @Nullable
    public ResultsSummary getResultsSummary(@NotNull PlanResultKey var1);

    @Nullable
    public ResultsSummary getResultsSummary(long var1);

    @Nullable
    public ResultsSummary getResultsSummary(@NotNull PlanResultKey var1, ResultDataRead var2);

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey var1, @NotNull Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey var1, @NotNull Class<T> var2, ResultDataRead var3);

    public void updateLifeCycleState(@NotNull ResultsSummary var1, @NotNull LifeCycleState var2, @NotNull BuildState var3);

    public void updateLifeCycleState(@NotNull BuildIdentifier var1, @NotNull LifeCycleState var2, @NotNull BuildState var3);

    public void updatePlanCompletedDate(@NotNull ChainResultsSummary var1, @NotNull Date var2);

    public void calculateAndSetDeltaState(ResultsSummary var1);

    public void saveResultSummary(@NotNull ResultsSummary var1);

    public void addVariableContextSnapshotToResultSummary(@NotNull ResultsSummary var1, @NotNull VariableContext var2);

    public void updateVariablesOnContinuedBuild(@NotNull ResultsSummary var1, @NotNull VariableContext var2);

    public void clearVariablesOnRerunBuild(@NotNull ResultsSummary var1);

    public void postBuildVariableSnapshotUpdate(@NotNull ResultsSummary var1, @NotNull VariableContext var2);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllPendingResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllQueuedResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllInProgressResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllActiveResultSummariesForPlan(PlanKey var1, Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getFinalizedResultSummariesForPlan(PlanKey var1, Class<T> var2, int var3, int var4);

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(Plan var1, int var2);

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(@NotNull ImmutablePlan var1, int var2, int var3);

    @NotNull
    public List<ResultsSummary> getBeforeSummaries(@NotNull ImmutablePlan var1, int var2, int var3);

    @NotNull
    public List<ResultsSummary> getAfterSummaries(@NotNull ImmutablePlan var1, int var2, int var3);

    public int getNumberOfConcurrentlyRunningBuilds(PlanKey var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInUnknownState(Class<T> var1);

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(@NotNull PlanResultKey var1, Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(@NotNull PlanResultKey var1, Class<T> var2, boolean var3);

    @Nullable
    public ChainStageResult getChainStageResultById(@NotNull Long var1);

    public long getNumberOfResults();

    public long getNumberOfFinishedResults(@NotNull Plan var1);

    public long getNumberOfFinalizedResults(@NotNull ImmutablePlan var1);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlan(@NotNull ImmutablePlan var1, int var2, int var3);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlanByLifeCycleState(@NotNull Plan var1, @NotNull LifeCycleState var2, int var3, int var4);

    public long getAveragePlanExecutionDuration(@NotNull ImmutablePlan var1, int var2);

    public <T extends ResultsSummary> T getLastResultsSummary(@NotNull String var1, Class<T> var2);

    @Nullable
    public ResultsSummary getLastSuccessfulResultSummary(@NotNull PlanKey var1);

    public int removeResultsSummariesForPlan(@NotNull Plan var1);

    public int removeAllOrphanedResultSummaries();

    @Nullable
    public ResultsSummary findFirstFailedBuildResultAfter(@NotNull String var1, int var2);

    @Nullable
    public ResultsSummary findFirstSuccessfulBuildResultAfter(@NotNull PlanResultKey var1);

    @Nullable
    public ResultsSummary findLastSuccessfulBuildResultBefore(@NotNull PlanResultKey var1);

    @Nullable
    public ResultsSummary findLastFailingBuildResultBefore(@NotNull ImmutablePlan var1, int var2);

    @Nullable
    public ResultsSummary findFirstFailedBuildResultBetween(@NotNull ImmutablePlan var1, int var2, int var3);

    @Nullable
    public ResultsSummary findLastBuildResultBefore(@NotNull String var1, int var2);

    @Nullable
    public <T extends ResultsSummary> T findLastBuildResultBeforeWithTests(@NotNull PlanResultKey var1, @NotNull Class<T> var2, boolean var3);

    @Nullable
    public ResultsSummary getBreakingBuild(ResultsSummary var1);

    @Nullable
    public ResultsSummary getFixingBuild(ResultsSummary var1);

    public List<ResultsSummary> getLatestResultSummaries();

    public List<ResultsSummary> getLatestFailedResultSummaries();

    @NotNull
    public List<ResultsSummary> getLastNResultsSummaries(@NotNull ImmutablePlan var1, int var2);

    @NotNull
    public List<ResultsSummary> getLastNFailedResultsSummaries(@NotNull Plan var1, int var2);

    @NotNull
    public <T extends ResultsSummary> T getAnyResultSummary(@NotNull ResultsSummaryCriteria var1, ResultDataRead var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummaries(@NotNull ResultsSummaryCriteria var1);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForExpiry(@NotNull ExpiryCriteria var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForResults(@NotNull List<ResultsSummary> var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForPlanKey(@NotNull PlanKey var1);

    @NotNull
    public List<? extends ResultsSummary> findResultsSummariesByJiraIssues(@Nullable List<String> var1);

    @NotNull
    public List<? extends ResultsSummary> findResultsSummariesByProjectKey(@Nullable String var1);

    @Nullable
    public ChainResultsSummary getParentResultSummary(ResultsSummary var1);

    @Nullable
    public ChainStageResult getStageForResult(ResultsSummary var1);

    public void removeResultSummary(@NotNull ImmutablePlan var1, int var2);

    public void removeResultSummary(@NotNull ImmutablePlan var1, @NotNull ResultsSummary var2);

    public void removeArtifacts(@NotNull ImmutablePlan var1, int var2) throws IOException;

    public void removeArtifacts(@NotNull ResultsSummary var1) throws IOException;

    public void removeMatchingArtifacts(@NotNull ResultsSummary var1, @NotNull Predicate<ArtifactLink> var2) throws IOException;

    public void removeBuildLogs(ImmutablePlan var1, int var2);

    public void removeBuildLogs(@NotNull ResultsSummary var1);

    public void removeBuildLogs(ImmutablePlan var1, int var2, long var3);

    public void removeBuildLogs(@NotNull ResultsSummary var1, long var2);

    public List<ChainResultsSummary> findChainResultsWithJobLabelled(ResultsSummaryCriteria var1, List<Label> var2);

    public void moveResultSummaries(@NotNull Plan var1, @NotNull PlanKey var2, @NotNull PlanKey var3);

    public long scrollResultSummaries(@NotNull String var1, @NotNull Function<ResultsSummary, Void> var2);

    public long scrollResultSummaries(@NotNull String var1, ResultDataRead var2, @NotNull Function<ResultsSummary, Void> var3);

    @Nullable
    public <T extends ResultsSummary> T findFirstResultAfter(@NotNull PlanResultKey var1, Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T findLastResultSummaryWithState(@NotNull PlanKey var1, @NotNull BuildState var2, @NotNull Class<T> var3);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetId(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByCheckoutChangesetId(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIdAndRepository(long var1, @NotNull String var3, @NotNull Class<T> var4);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIds(@NotNull List<String> var1, Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIds(@NotNull Iterable<Pair<String, RepositoryData>> var1, Class<T> var2);

    @NotNull
    public List<UnassociatedCommit> getCommitsForUser(@NotNull String var1, int var2);

    public int countResultsWithState(@NotNull PlanKey var1, int var2, int var3, @NotNull BuildState var4);

    @Deprecated
    public void logVariablesForSubstitution(@NotNull BuildContext var1, @NotNull ResultsSummary var2);

    @Deprecated
    public void logSubstitutedVariables(@NotNull BuildContext var1, @NotNull ResultsSummary var2);

    public void updateProcessingDuration(ChainResultsSummary var1);

    public int markResultSummariesForDeletion(@NotNull PlanKey var1);

    public void updateResultSummaryWithBuildChanges(@NotNull BuildContext var1) throws ResultsSummaryCreationException;

    public ResultsSummary resetResultSummary(@NotNull BuildResultsSummary var1) throws IOException;

    public void removeMergeResultSummary(@NotNull MergeResultSummary var1);

    @Internal
    @NotNull
    public List<PlanKey> getPlanKeysSortedByNumberOfFinalizedResultSummaries();

    @Nullable
    public Long calculateQueueDuration(@NotNull ChainResultsSummary var1);

    @Nullable
    public Long calculateVcsUpdateDuration(@NotNull ChainResultsSummary var1);

    @NotNull
    public List<Integer> findAllBuildResultsNumbers(PlanKey var1);

    public void invalidateLogSize(@NotNull PlanResultKey var1);

    @NotNull
    public Range<Integer> findBuildResultNumbersRange(@NotNull PlanKey var1);
}

