/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.tests;

import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.results.tests.TestDurationConverter;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.DurationUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestResults
implements Serializable,
Comparable<TestResults> {
    private static final long UNKNOWN_DURATION = -1L;
    private static final Interner<String> TEST_CLASS_NAMES = Interners.newWeakInterner();
    private static final String UNNAMED_TEST_SUITE = "unnamed test suite";
    private final String myName;
    private final String myClassName;
    @XStreamConverter(value=TestDurationConverter.class)
    private final long myDuration;
    private FinalArrayList<TestCaseResultError> myErrors = new FinalArrayList();
    private transient String prettyDuration;
    private String systemOut;
    private TestState state;
    private long testCaseId;

    @Deprecated
    public TestResults(String className, String methodName, String duration) {
        this(className, methodName, TestResults.toMilliseconds(duration));
    }

    @Nullable
    private static Long toMilliseconds(@Nullable String durationInSeconds) {
        Double durationDouble = NumberUtils.createDoubleQuietly(durationInSeconds);
        if (durationDouble == null) {
            return null;
        }
        return (long)(durationDouble * 1000.0);
    }

    public TestResults(String className, String methodName, @Nullable Long durationMs) {
        this.myClassName = StringUtils.isEmpty((CharSequence)className) ? UNNAMED_TEST_SUITE : (String)TEST_CLASS_NAMES.intern((Object)className);
        this.myDuration = durationMs != null ? durationMs : -1L;
        this.myName = methodName;
    }

    public String getActualMethodName() {
        return this.myName;
    }

    @Nullable
    public String getMethodName() {
        String TEST_PREFIX = "test";
        if (this.myName == null || this.myName.length() < 2) {
            return this.myName;
        }
        String lowerCase = this.myName.toLowerCase();
        if ("test".equals(lowerCase)) {
            return this.myName;
        }
        String prefixRemoved = StringUtils.removeStartIgnoreCase((String)this.myName, (String)"test");
        String wordsSeparated = prefixRemoved.replaceAll("[A-Z]", " $0").replace('_', ' ').replaceAll("\\s+", " ").toLowerCase().trim();
        if (StringUtils.isBlank((CharSequence)wordsSeparated)) {
            return this.myName.trim();
        }
        return Character.toUpperCase(wordsSeparated.charAt(0)) + wordsSeparated.substring(1);
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public String getShortClassName() {
        if (StringUtils.contains((CharSequence)this.myClassName, (CharSequence)".")) {
            return StringUtils.substringAfterLast((String)this.myClassName, (String)".");
        }
        return this.myClassName;
    }

    public long getDurationMs() {
        return this.myDuration == -1L ? 0L : this.myDuration;
    }

    public void addError(TestCaseResultError error) {
        this.getMyErrors().add(error);
    }

    public List<TestCaseResultError> getErrors() {
        return this.getMyErrors();
    }

    public void setSystemOut(String systemOut) {
        this.systemOut = systemOut;
    }

    public String getSystemOut() {
        return this.systemOut;
    }

    public boolean hasErrors() {
        return !this.myErrors.isEmpty();
    }

    @Deprecated
    public String getPrettyDuration() {
        if (this.prettyDuration == null) {
            this.prettyDuration = DurationUtils.getPrettyPrint(this.myDuration, false);
        }
        return this.prettyDuration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("classname", (Object)this.getClassName()).add("methodname", (Object)this.getActualMethodName()).add("duration", this.myDuration).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestResults)) {
            return false;
        }
        TestResults rhs = (TestResults)o;
        return new EqualsBuilder().append((Object)this.getClassName(), (Object)rhs.getClassName()).append((Object)this.getActualMethodName(), (Object)rhs.getActualMethodName()).isEquals();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClassName(), this.getActualMethodName()});
    }

    @Override
    public int compareTo(TestResults o) {
        return new CompareToBuilder().append((Object)this.getClassName(), (Object)o.getClassName()).append((Object)this.getActualMethodName(), (Object)o.getActualMethodName()).toComparison();
    }

    public TestState getState() {
        return this.state;
    }

    public void setState(TestState state) {
        this.state = state;
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }

    private List<TestCaseResultError> getMyErrors() {
        return this.myErrors;
    }
}

