/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.PreparedStatementProvider;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface DbmsBean {
    @NotNull
    public String getQuery(@NotNull SqlQueryProvider var1);

    @NotNull
    public String getConcat(String ... var1);

    @NotNull
    public Collection<ConstraintDefinition> getConstraints(Connection var1, @NotNull String var2, @Nullable String var3) throws SQLException;

    public Set<String> getIndexNames(Connection var1, @NotNull String var2, @Nullable String var3) throws SQLException;

    @NotNull
    public PreparedStatement prepareStatement(@NotNull Connection var1, @NotNull PreparedStatementProvider var2) throws SQLException;

    public boolean isColumnPresent(@NotNull Connection var1, @NotNull String var2, @NotNull String var3) throws SQLException;

    public boolean isColumnPresent(@NotNull Statement var1, @NotNull String var2, @NotNull String var3) throws SQLException;

    public boolean dropColumn(@NotNull Connection var1, @NotNull String var2, @NotNull String var3) throws SQLException;

    public void migrateColumnType(Connection var1, String var2, String var3, int var4, @Nullable Integer var5) throws SQLException;

    public void changeColumnType(Connection var1, String var2, String var3, int var4, @Nullable Integer var5, boolean var6) throws SQLException;

    public void dropIndex(Connection var1, String var2, String var3) throws SQLException;

    public boolean dropIndexIfExists(Connection var1, String var2, @NotNull String var3) throws SQLException;

    public void createIndex(Connection var1, String var2, String var3, String var4) throws SQLException;

    public void createUniqueConstraint(Connection var1, String var2, String var3, String ... var4) throws SQLException;

    public boolean isTablePresent(@NotNull Connection var1, @NotNull String var2) throws SQLException;

    public void resizeVarcharColumn(@NotNull Connection var1, String var2, String var3, int var4, boolean var5, @Nullable String var6) throws SQLException;

    public boolean isMySql();

    public boolean isOracle();

    @Nullable
    public String getSchema(Connection var1) throws SQLException;

    @Nullable
    default public String getCatalog(Connection c) throws SQLException {
        return c.getCatalog();
    }

    public boolean isHsqldb();

    public boolean isPostgreSql();

    public boolean isMsSqlServer();

    public DatabaseType getDatabaseType();

    public void dropPrimaryKey(Connection var1, String var2) throws SQLException;

    public void changeTableNameToUpperCase(Connection var1, String var2) throws SQLException;

    public void renameColumn(Connection var1, String var2, String var3, String var4) throws SQLException;

    public void addColumn(Connection var1, String var2, String var3, int var4, @Nullable Integer var5) throws SQLException;

    public void dropConstraint(Connection var1, String var2, String var3) throws SQLException;

    public void dropForeignKeyConstraint(Connection var1, String var2, String var3) throws SQLException;

    public void changeColumnToNotNull(Connection var1, String var2, String var3) throws SQLException;

    public Collection<IndexDefinition> getIndices(Connection var1, @NotNull String var2) throws SQLException;

    public List<ColumnDefinition> getColumns(Connection var1, @NotNull String var2, @Nullable String var3) throws SQLException;

    public void dropTable(Connection var1, String var2) throws SQLException;

    public List<String> getTables(@NotNull Connection var1) throws SQLException;

    public static class ColumnDefinition {
        private final OptionalInt columnSize;
        private final Optional<Boolean> isNullable;
        private final String dataTypeName;
        private final String columnName;
        private final int dataType;

        public ColumnDefinition(String columnName, int dataType, @NotNull String dataTypeName, @NotNull OptionalInt columnSize, @NotNull Optional<Boolean> isNullable) {
            this.columnName = columnName;
            this.dataType = dataType;
            this.dataTypeName = dataTypeName;
            this.columnSize = columnSize;
            this.isNullable = isNullable;
        }

        public String getDataTypeName() {
            return this.dataTypeName;
        }

        public OptionalInt getColumnSize() {
            return this.columnSize;
        }

        public int getDataType() {
            return this.dataType;
        }

        public Optional<Boolean> isNullable() {
            return this.isNullable;
        }

        @NotNull
        public String getSqlType() {
            if (this.columnSize.isPresent()) {
                return String.format("%s(%s)", this.dataTypeName, this.columnSize.getAsInt());
            }
            return this.dataTypeName;
        }

        public String toString() {
            return "ColumnDefinition{columnSize=" + this.columnSize + ", isNullable=" + this.isNullable + ", dataTypeName='" + this.dataTypeName + '\'' + ", columnName='" + this.columnName + '\'' + ", dataType=" + this.dataType + '}';
        }

        public String getName() {
            return this.columnName;
        }

        public String getSqlNullability() {
            if (!this.isNullable.orElse(true).booleanValue()) {
                return "not null";
            }
            return "";
        }
    }

    public static class ConstraintDefinition {
        private final String name;
        private final ConstraintType constraintType;
        private final Collection<String> columns;

        public ConstraintDefinition(String name) {
            this(name, StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"fk") ? ConstraintType.FOREIGN_KEY : ConstraintType.UNDEFINED, Collections.emptyList());
        }

        public ConstraintDefinition(String name, ConstraintType constraintType, @Nullable Collection<String> columns) {
            this.name = name;
            this.constraintType = constraintType;
            this.columns = columns != null ? new ArrayList<String>(columns) : Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public ConstraintType getConstraintType() {
            return this.constraintType;
        }

        public Collection<String> getColumns() {
            return this.columns;
        }

        public boolean isForeignKey() {
            return this.constraintType == ConstraintType.FOREIGN_KEY;
        }

        public boolean isPrimaryKey() {
            return this.constraintType == ConstraintType.PRIMARY_KEY;
        }

        public boolean isUniqueKey() {
            return this.constraintType == ConstraintType.UNIQUE;
        }

        public String toString() {
            return this.name + ":" + (Object)((Object)this.constraintType) + ":" + this.columns;
        }

        public static enum ConstraintType {
            FOREIGN_KEY,
            PRIMARY_KEY,
            UNIQUE,
            CHECK,
            UNDEFINED;

        }
    }

    public static class IndexDefinition {
        private final String name;
        private final Collection<String> columns;

        public IndexDefinition(String name, Collection<String> columns) {
            this.name = name;
            this.columns = columns;
        }

        public Collection<String> getColumns() {
            return this.columns;
        }

        public String getName() {
            return this.name;
        }
    }
}

