/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import org.jetbrains.annotations.NotNull;

public enum DatabaseType {
    HSQL("hsql", "jdbc:hsqldb", "org.hsqldb.jdbcDriver", 0){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s:%2$s/database/defaultdb", this.getProtocol(), "${bambooHome}");
        }
    }
    ,
    MSSQL("mssql", "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", 1433){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d;databaseName=%4$s", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    MYSQL("mysql", "jdbc:mysql", "com.mysql.jdbc.Driver", 3306){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s?characterEncoding=utf8&useUnicode=true", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    ORACLE("oracle", "jdbc:oracle:thin", "oracle.jdbc.OracleDriver", 1521){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String service, int port) {
            return String.format("%1$s:@//%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, service);
        }
    }
    ,
    POSTGRESQL("postgres", "jdbc:postgresql", "org.postgresql.Driver", 5432){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, database);
        }
    };

    private String key;
    private String protocol;
    private String driverClassName;
    private int defaultPort;

    private DatabaseType(String key, String protocol, String driverClassName, int defaultPort) {
        this.key = key;
        this.protocol = protocol;
        this.driverClassName = driverClassName;
        this.defaultPort = defaultPort;
    }

    public String getKey() {
        return this.key;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @NotNull
    public String generateUrl(@NotNull String hostName, @NotNull String database) {
        return this.generateUrl(hostName, database, this.defaultPort);
    }

    @NotNull
    public abstract String generateUrl(@NotNull String var1, @NotNull String var2, int var3);
}

