/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.HtmlAnsiColorsOutputStream;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUtils {
    private static final Logger log = Logger.getLogger(HtmlUtils.class);
    public static final String WBR = "&#8203;";
    public static final String BSLASH = "&#92;";
    private static final HtmlUtils instance = new HtmlUtils();

    private HtmlUtils() {
    }

    @NotNull
    public static String getAsPreformattedText(@Nullable Object o) {
        if (o == null) {
            return "";
        }
        String s = StringEscapeUtils.escapeHtml4((String)o.toString());
        s = s.replaceAll("(\\n|\\r\\n)", "<br\\>$1");
        s = HtmlUtils.whiteSpacePreWrap(s);
        return s;
    }

    private static String whiteSpacePreWrap(String s) {
        return s.replaceAll("  ", "&nbsp; ").replaceAll("  ", " &nbsp;").replaceAll("(\\t)", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").replaceAll("\\\\", BSLASH);
    }

    public static String getTextAsHtml(Object o) {
        if (o == null) {
            return "";
        }
        String s = o instanceof String ? (String)o : o.toString();
        s = TextUtils.plainTextToHtml((String)s);
        s = HtmlUtils.whiteSpacePreWrap(s);
        return s;
    }

    public static String getFirstNLines(String s, int lines) {
        if (s == null) {
            return "";
        }
        s = StringUtils.replace((String)s, (String)"\r\n", (String)"\n");
        int numberOfLines = 0;
        int newlineChar = 0;
        int lastValidIndex = s.length();
        while (numberOfLines < lines && newlineChar != -1) {
            if ((newlineChar = StringUtils.indexOf((CharSequence)s, (CharSequence)"\n", (int)newlineChar)) == -1) continue;
            lastValidIndex = newlineChar++;
            ++numberOfLines;
        }
        if (numberOfLines < lines) {
            return s;
        }
        return s.substring(0, lastValidIndex);
    }

    public static String getFirstNLinesWithTrailer(String s, int lines) {
        int totalNumberOfLines = StringUtils.countMatches((CharSequence)s, (CharSequence)"\n");
        if (!s.endsWith("\n")) {
            ++totalNumberOfLines;
        }
        String showingLines = HtmlUtils.getFirstNLines(s, lines);
        if (totalNumberOfLines > lines) {
            int difference = totalNumberOfLines - lines;
            return showingLines + "\n(" + difference + " more lines...)";
        }
        return showingLines;
    }

    public static String getFirstNCharactersWithTrailer(@Nullable String s, int chars) {
        if (s == null || chars < 0) {
            return s;
        }
        if (s.length() <= chars) {
            return s;
        }
        String subString = s.substring(0, chars);
        return subString + "...";
    }

    public static String appendUrls(String url1, String url2) {
        if (url1.endsWith("/") && url2.startsWith("/")) {
            return url1 + url2.substring(1);
        }
        return url1 + url2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String colorizeAnsiToHtml(String line) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HtmlAnsiColorsOutputStream hos = new HtmlAnsiColorsOutputStream(os);
        try {
            hos.writeLine(line);
            String string = new String(os.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            log.warn((Object)"Can not convert the log line to a Colorize Html output, returning the original log line", (Throwable)e);
            String string = line;
            return string;
        }
        finally {
            try {
                hos.close();
            }
            catch (IOException e) {
                log.warn((Object)"Can not close the OutputStream for the log line to a Colorize Html output, returning the original log line", (Throwable)e);
                return line;
            }
        }
    }

    @Deprecated
    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String addPrefixToLines(String prefix, String input) {
        return prefix + input.replaceAll("\n", "\n" + prefix);
    }

    public static HtmlUtils getInstanceForFreemarker() {
        return instance;
    }
}

