/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooStringUtils {
    private static final Logger log = Logger.getLogger(BambooStringUtils.class);
    private static final Pattern INVALID_CHARACTERS_REGEX = Pattern.compile("[^-A-Za-z0-9_:.]");
    public static final char CHAR_NONE = '\u0000';
    public static final char CHAR_APOSTROPHE = '\'';
    public static final char CHAR_BACKSLASH = '\\';
    public static final char CHAR_DOUBLE_QUOTE = '\"';
    public static final char CHAR_ELLIPSIS = '\u2026';
    public static final char[] XSS_RELATED_CHARACTERS = com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils.XSS_RELATED_CHARACTERS;
    public static final String XSS_RELATED_CHARACTERS_FIND_STR = "'\"\\\\<\\>";
    private static final char[] RELAXED_XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>'};
    private static final char[] SHELL_INJECTION_RELATED_CHARACTERS = com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils.SHELL_INJECTION_RELATED_CHARACTERS;
    private static final String SHELL_INJECTION_DOLLAR_PARENTHESIS = "$(";
    private static final Pattern FULLY_ENCLOSED_IN_DOUBLE_QUOTES = Pattern.compile("\"(.*)\"");
    private static final Pattern FULLY_ENCLOSED_IN_SINGLE_QUOTES = Pattern.compile("'(.*)'");
    private static final Pattern LINE_SPLITTER = Pattern.compile("\r?\n");
    private static final Pattern HREF_PATTERN = Pattern.compile("a\\s+href\\s*=\\s*\"([\\w\\$\\-\\+\\(\\):/\\.!\\?#=]*(&[a-zA-Z])*)*\"(\\s+rel\\s*=\\s*\"[\\w]*\")*\\s*");
    private static final Pattern htmlWhiteListPattern = Pattern.compile("(/?+ *(p|i|b|div) *)|(/ *a *)|( *br */?+)");

    private BambooStringUtils() {
    }

    @NotNull
    public static String forceAlphaNumeric(@Nullable String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (char aChar : charArray) {
            if (!CharUtils.isAsciiAlphanumeric((char)aChar)) continue;
            builder.append(aChar);
        }
        return builder.toString();
    }

    public static boolean containsXssRelatedCharacters(@Nullable String string) {
        return com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils.containsXssRelatedCharacters((String)string);
    }

    @NotNull
    public static String getFirstXssRelatedCharacter(@Nullable String string) {
        return BambooStringUtils.getFirstRelatedCharacter(string, XSS_RELATED_CHARACTERS);
    }

    public static boolean containsRelaxedXssRelatedCharacters(@Nullable String string) {
        return com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils.containsRelaxedXssRelatedCharacters((String)string);
    }

    @NotNull
    public static String getFirstRelaxedXssRelatedCharacter(@Nullable String string) {
        return BambooStringUtils.getFirstRelatedCharacter(string, RELAXED_XSS_RELATED_CHARACTERS);
    }

    public static boolean containsShellInjectionRelatedCharacters(@Nullable String string) {
        return com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils.containsShellInjectionRelatedCharacters((String)string);
    }

    public static String getFirstShellInjectionRelatedCharacters(@Nullable String string) {
        String relatedChar = BambooStringUtils.getFirstRelatedCharacter(string, SHELL_INJECTION_RELATED_CHARACTERS);
        if ("".equals(relatedChar) && StringUtils.indexOf((CharSequence)string, (CharSequence)SHELL_INJECTION_DOLLAR_PARENTHESIS) != -1) {
            relatedChar = SHELL_INJECTION_DOLLAR_PARENTHESIS;
        }
        return relatedChar;
    }

    @Deprecated
    public static boolean containsDefinedXssRelatedCharacters(@Nullable String string, @NotNull char[] characters) {
        return com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils.containsRelatedCharacters((String)string, (char[])characters);
    }

    @Deprecated
    public static boolean containsRelatedCharacters(@Nullable String string, @NotNull char[] characters) {
        return string != null && StringUtils.containsAny((CharSequence)string, (char[])characters);
    }

    @Deprecated
    public static String getFirstDefinedXssRelatedCharacter(@Nullable String string, @NotNull char[] characters) {
        return BambooStringUtils.getFirstRelatedCharacter(string, characters);
    }

    @NotNull
    public static String getFirstRelatedCharacter(@Nullable String string, @NotNull char[] characters) {
        if (string == null) {
            return "";
        }
        int unsafeCharIndex = StringUtils.indexOfAny((CharSequence)string, (char[])characters);
        if (unsafeCharIndex == -1) {
            return "";
        }
        return string.substring(unsafeCharIndex, unsafeCharIndex + 1);
    }

    @NotNull
    public static String forceValidHtmlId(@NotNull String id) {
        return INVALID_CHARACTERS_REGEX.matcher(id).replaceAll("_");
    }

    public static Iterable<String> lineIterator(String string) {
        return Splitter.onPattern((String)"\r?\n").split((CharSequence)string);
    }

    public static Stream<String> lineStream(String input) {
        return LINE_SPLITTER.splitAsStream(input);
    }

    @Deprecated
    public static Predicate<String> containsString(@NotNull String string) {
        return input -> input.contains(string);
    }

    public static int indexOf(String haystack, String needle, int n) {
        Pattern compile = Pattern.compile(needle, 16);
        return BambooStringUtils.indexOf(haystack, n, compile);
    }

    public static int indexOfRegex(String haystack, String needle, int occurence) {
        Pattern compile = Pattern.compile(needle);
        return BambooStringUtils.indexOf(haystack, occurence, compile);
    }

    private static int indexOf(String string, int occurence, Pattern compile) {
        Matcher matcher = compile.matcher(string);
        while (matcher.find()) {
            if (occurence <= 0) {
                return matcher.start();
            }
            --occurence;
        }
        return -1;
    }

    public static boolean startsWithAny(String string, Collection<String> searchStrings) {
        return StringUtils.startsWithAny((CharSequence)string, (CharSequence[])searchStrings.toArray(new String[searchStrings.size()]));
    }

    @Nullable
    public static String nullIfBlank(@Nullable String string) {
        return StringUtils.isBlank((CharSequence)string) ? null : string;
    }

    public static String encodeHtmlWithTagWhiteList(String string) {
        StringTokenizer st = new StringTokenizer(string, "<>", true);
        StringBuilder sb = new StringBuilder();
        String tagContent = null;
        EncoderState state = EncoderState.START;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case START: {
                    if (token.equals("<")) {
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml4((String)token));
                    break;
                }
                case AFTER_LT: {
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml4((String)"<"));
                        break;
                    }
                    if (token.equals(">")) {
                        sb.append(StringEscapeUtils.escapeHtml4((String)">"));
                        state = EncoderState.START;
                        break;
                    }
                    tagContent = token;
                    state = EncoderState.AFTER_TAG_CONTENT;
                    break;
                }
                case AFTER_TAG_CONTENT: {
                    if (token.equals(">") && htmlWhiteListPattern.matcher(tagContent).matches()) {
                        sb.append("<").append(tagContent).append(">");
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals(">") && tagContent.startsWith("a ")) {
                        sb.append(BambooStringUtils.sanitizeLink(tagContent));
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml4((String)"<"));
                        sb.append(StringEscapeUtils.escapeHtml4((String)tagContent));
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml4((String)"<"));
                    sb.append(StringEscapeUtils.escapeHtml4((String)tagContent));
                    sb.append(StringEscapeUtils.escapeHtml4((String)token));
                    state = EncoderState.START;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case AFTER_LT: {
                sb.append(StringEscapeUtils.escapeHtml4((String)"<"));
                break;
            }
            case AFTER_TAG_CONTENT: {
                sb.append(StringEscapeUtils.escapeHtml4((String)"<"));
                sb.append(StringEscapeUtils.escapeHtml4(tagContent));
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static Function<String, String> encodeHtmlWithTagWhiteListFunction() {
        return BambooStringUtils::encodeHtmlWithTagWhiteList;
    }

    @NotNull
    public static String unquote(@NotNull String quotedVarValue, boolean processBackslashes) {
        char[] unquoted = new char[quotedVarValue.length()];
        int ui = 0;
        char quotedBy = '\u0000';
        boolean backslash = false;
        for (int i = 0; i < quotedVarValue.length(); ++i) {
            char lookingAt = quotedVarValue.charAt(i);
            if (backslash) {
                unquoted[ui++] = lookingAt;
                backslash = false;
                continue;
            }
            if (quotedBy != '\'' && lookingAt == '\\' && processBackslashes) {
                backslash = true;
                continue;
            }
            if (quotedBy == '\u0000' && BambooStringUtils.in(lookingAt, '\"', '\'')) {
                quotedBy = lookingAt;
                continue;
            }
            if (lookingAt == quotedBy) {
                quotedBy = '\u0000';
                continue;
            }
            unquoted[ui++] = lookingAt;
        }
        return new String(unquoted, 0, ui);
    }

    private static boolean in(char needle, char ... haystack) {
        for (char c : haystack) {
            if (needle != c) continue;
            return true;
        }
        return false;
    }

    public static boolean in(String needle, String ... haystacks) {
        for (String haystack : haystacks) {
            if (!needle.equals(haystack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String remove(@NotNull String quotedVarValue, int index) {
        if (index == -1) {
            return quotedVarValue;
        }
        String firstPart = quotedVarValue.substring(0, index);
        if (index == quotedVarValue.length()) {
            return firstPart;
        }
        return firstPart + quotedVarValue.substring(index + 1);
    }

    @Nullable
    public static String truncateAndAddEllipsis(@Nullable String string, int maxLength) {
        if (string != null && string.length() > maxLength) {
            return StringUtils.left((String)string, (int)(maxLength - 1)) + '\u2026';
        }
        return string;
    }

    private static String sanitizeLink(String string) {
        if (HREF_PATTERN.matcher(string).matches()) {
            return "<" + string + ">";
        }
        return StringEscapeUtils.escapeHtml4((String)"<") + StringEscapeUtils.escapeHtml4((String)string) + StringEscapeUtils.escapeHtml4((String)">");
    }

    public static String stripFullyEnclosingQuotes(String input) {
        if (input == null) {
            return input;
        }
        Matcher matcherDoubleQuotes = FULLY_ENCLOSED_IN_DOUBLE_QUOTES.matcher(input);
        if (matcherDoubleQuotes.matches()) {
            return matcherDoubleQuotes.group(1);
        }
        Matcher matcherSingleQuotes = FULLY_ENCLOSED_IN_SINGLE_QUOTES.matcher(input);
        if (matcherSingleQuotes.matches()) {
            return matcherSingleQuotes.group(1);
        }
        return input;
    }

    @Deprecated
    public static Function<String, String> stripFullyEnclosingQuotes() {
        return BambooStringUtils::stripFullyEnclosingQuotes;
    }

    @Deprecated
    public static Function<String, String> toUpperCase() {
        return StringUtils::upperCase;
    }

    public static Function<String, String> replaceAll(Pattern pattern, String replacement) {
        return new ReplaceAll(pattern, replacement);
    }

    public static Function<String, String> replaceAll(String regex, String replacement) {
        return new ReplaceAll(Pattern.compile(regex), replacement);
    }

    @NotNull
    public static String dos2unix(@NotNull String s) {
        return s.replaceAll("\r\n", "\n");
    }

    public static String toCamelCase(@NotNull String string, char separator) {
        StringBuilder camelCase = new StringBuilder();
        for (String word : Splitter.on((char)separator).omitEmptyStrings().split((CharSequence)string)) {
            if (camelCase.length() != 0) {
                camelCase.append(StringUtils.capitalize((String)word));
                continue;
            }
            camelCase.append(StringUtils.uncapitalize((String)word));
        }
        return camelCase.toString();
    }

    public static String toCommandLineString(@NotNull Iterable<String> commandArgs) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> commandArgsIterator = commandArgs.iterator();
        while (commandArgsIterator.hasNext()) {
            String commandArg = commandArgsIterator.next();
            if (commandArg.contains(" ")) {
                sb.append('\'').append(commandArg).append('\'');
            } else {
                sb.append(commandArg);
            }
            if (!commandArgsIterator.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String formatTemplate(String urlTemplate, Map<String, String> variableValues) {
        Preconditions.checkNotNull(variableValues);
        String out = urlTemplate;
        for (Map.Entry<String, String> item : variableValues.entrySet()) {
            out = out.replace("${" + item.getKey() + "}", item.getValue());
        }
        return out;
    }

    public static String preventInlining(String constant) {
        return constant;
    }

    @Nullable
    public static String firstNotBlank(String ... strings) {
        if (strings != null) {
            return Arrays.stream(strings).filter(StringUtils::isNotBlank).findFirst().orElse(null);
        }
        return null;
    }

    public static boolean isMixedCase(@NotNull String value) {
        return value.chars().anyMatch(Character::isUpperCase) && value.chars().anyMatch(Character::isLowerCase);
    }

    public static boolean smartContains(@Nullable String haystack, @Nullable String needle) {
        if (needle == null || haystack == null) {
            return false;
        }
        if (StringUtils.isAllLowerCase((CharSequence)needle)) {
            return StringUtils.containsIgnoreCase((CharSequence)haystack, (CharSequence)needle);
        }
        return haystack.contains(needle);
    }

    public static class AffixFilteringTree {
        private final PrefixTree prefixTree;
        private final PrefixTree suffixTree;

        public AffixFilteringTree(@NotNull Iterable<String> iterable) {
            this.prefixTree = new PrefixTree(iterable);
            this.suffixTree = new PrefixTree(this.reverse(iterable));
        }

        @NotNull
        public Iterable<String> getWithPrefix(@NotNull String prefix) {
            return this.prefixTree.withPrefix(prefix);
        }

        @NotNull
        public Iterable<String> getWithSuffix(@NotNull String suffix) {
            return this.reverse(this.suffixTree.withPrefix(StringUtils.reverse((String)suffix)));
        }

        @NotNull
        private Iterable<String> reverse(@NotNull Iterable<String> iterable) {
            return Iterables.transform(iterable, StringUtils::reverse);
        }

        private static class PrefixTree {
            private final TreeSet<String> prefixSet = new TreeSet();

            void add(String s) {
                this.prefixSet.add(s);
            }

            private PrefixTree(Iterable<String> iterable) {
                iterable.forEach(s -> this.add((String)s));
            }

            public Iterable<String> withPrefix(String prefix) {
                SortedSet<String> tailSet = this.prefixSet.tailSet(prefix);
                return io.atlassian.fugue.Iterables.takeWhile(tailSet, s -> s.startsWith(prefix));
            }
        }
    }

    private static class ReplaceAll
    implements Function<String, String> {
        private final Pattern pattern;
        private final String replacement;

        private ReplaceAll(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String apply(@Nullable String input) {
            return input == null ? null : this.pattern.matcher(input).replaceAll(this.replacement);
        }
    }

    static enum EncoderState {
        START,
        AFTER_LT,
        AFTER_TAG_CONTENT;

    }
}

