/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.comment;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.CreationDateProvider;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Date;
import javax.annotation.Nullable;

public interface Comment
extends BambooObject,
CreationDateProvider {
    public static final Function<Comment, Long> getEntityId = new Function<Comment, Long>(){

        public Long apply(@Nullable Comment comment) {
            return comment != null ? Long.valueOf(comment.getEntityId()) : null;
        }
    };
    public static final Ordering<Comment> orderingByMostRecentFirst = Ordering.from((Comparator)new Comparator<Comment>(){

        @Override
        public int compare(Comment o1, Comment o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            Date lmd1 = o1.getLastModificationDate();
            Date lmd2 = o2.getLastModificationDate();
            if (lmd1 == null || lmd2 == null) {
                return lmd1 == lmd2 ? 0 : (lmd1 == null ? -1 : 1);
            }
            return lmd2.compareTo(lmd1);
        }
    });

    public String getContent();

    public void setContent(String var1);

    @Deprecated
    public ResultsSummary getResultsSummary();

    @Deprecated
    public void setResultsSummary(ResultsSummary var1);

    public long getEntityId();

    public void setEntityId(long var1);

    public Date getLastModificationDate();

    @Override
    public Date getCreationDate();

    public User getUser();

    public String getUserName();

    public void setUserName(String var1);
}

