/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.google.common.base.Predicate;
import java.util.Collection;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BambooPermissionManager {
    public static final PrincipalAcegiUserToken SYSTEM_AUTHORITY = new PrincipalAcegiUserToken("SYSTEM", "SYSTEM", "SYSTEM", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM"), new GrantedAuthorityImpl("ROLE_ADMIN")}, null);

    public boolean hasPermission(@NotNull Permission var1, @NotNull Object var2, @Nullable Authentication var3);

    public Predicate<Object> hasPermission(@NotNull BambooPermission var1, @Nullable Authentication var2);

    public boolean hasPermission(@NotNull String var1, @NotNull Permission var2, @NotNull Object var3);

    public boolean hasPermissionForAuthority(@NotNull Permission var1, @NotNull Object var2, @NotNull GrantedAuthority var3);

    public boolean hasPlanPermission(@NotNull Permission var1, @NotNull PlanKey var2);

    public boolean hasPlanPermission(@NotNull Permission var1, @NotNull ImmutablePlan var2);

    public boolean hasProjectPermission(@NotNull Permission var1, @NotNull String var2);

    public boolean hasProjectPermission(@NotNull Permission var1, @NotNull Project var2);

    public boolean canCreatePlanInProject(@NotNull String var1);

    public boolean canCreatePlanInProject(@NotNull Project var1);

    public boolean canCreateProject();

    public boolean canCreatePlan();

    public boolean canCreateDeploymentProject();

    public boolean hasGlobalPermission(@NotNull Permission var1);

    @Deprecated
    public boolean hasProjectEditPermission(@Nullable Project var1);

    public boolean isEnableSignup();

    public Collection<Permission> getPermissionsForPlan(@NotNull PlanKey var1);

    public Collection<String> getAdminGroups();

    @NotNull
    public Collection<String> getRestrictedAdminGroups();

    @NotNull
    public Collection<String> getUsePermissionGroups();

    @NotNull
    public Collection<String> getAdminUsers();

    @NotNull
    public Collection<String> getRestrictedAdminUsers();

    @NotNull
    public Collection<String> getUsePermissionUsers();

    @NotNull
    public String getDefaultUsersGroup();

    public boolean isAdmin(String var1);

    public boolean isSystemAdmin(String var1);

    public boolean isAllowedToSetGlobalPermission(@NotNull Permission var1);

    public boolean canManageElasticBamboo();

    public boolean canManageAgents();

    public Acl getAcl(@NotNull Object var1);

    public boolean canRunCustomBuild(@NotNull PlanKey var1);
}

