/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ExpiryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

public class MutableExpiryCriteria
implements ExpiryCriteria {
    public static final int DEFAULT_BATCH_SIZE = 500;
    protected PlanKey planKey;
    protected Class<? extends ResultsSummary> resultsSummaryClass = ResultsSummary.class;
    protected boolean requireArtifactLinks;
    protected Long maxIgnoredLogSize;
    protected Integer maxBuildNumber;
    protected Integer minBuildNumberToKeep;
    protected DateTime maxBuildCompletedDate;
    protected ImmutableSet<String> labelsToExclude = ImmutableSet.of();
    protected int maxResults = 500;

    public MutableExpiryCriteria(@NotNull PlanKey planKey) {
        this.planKey = planKey;
        if (PlanKeys.isChainKey(planKey)) {
            this.resultsSummaryClass = ChainResultsSummary.class;
        } else if (PlanKeys.isJobKey(planKey)) {
            this.resultsSummaryClass = BuildResultsSummary.class;
        } else {
            throw new IllegalArgumentException("Couldn't create expiry criteria - unknown plan key type: " + planKey);
        }
    }

    @Override
    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @Override
    @NotNull
    public Class<? extends ResultsSummary> getResultsSummaryClass() {
        return this.resultsSummaryClass;
    }

    @Override
    public boolean isRequireArtifactLinks() {
        return this.requireArtifactLinks;
    }

    @Override
    @Nullable
    public Long getMaxIgnoredLogSize() {
        return this.maxIgnoredLogSize;
    }

    @Override
    @Nullable
    public Integer getMaxBuildNumber() {
        return this.maxBuildNumber;
    }

    @Override
    @Nullable
    public DateTime getMaxBuildCompletedDate() {
        return this.maxBuildCompletedDate;
    }

    @Override
    @NotNull
    public Set<String> getLabelsToExclude() {
        return this.labelsToExclude;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    public void setRequireArtifactLinks(boolean requireArtifactLinks) {
        this.requireArtifactLinks = requireArtifactLinks;
    }

    public void setMaxIgnoredLogSize(@Nullable Long maxIgnoredLogSize) {
        this.maxIgnoredLogSize = maxIgnoredLogSize;
    }

    public void setMaxBuildNumber(@Nullable Integer maxBuildNumber) {
        this.maxBuildNumber = maxBuildNumber;
    }

    public void setMaxBuildCompletedDate(@Nullable DateTime maxBuildCompletedDate) {
        this.maxBuildCompletedDate = maxBuildCompletedDate;
    }

    public void setLabelsToExclude(@NotNull Iterable<String> labelsToExclude) {
        this.labelsToExclude = ImmutableSet.copyOf(labelsToExclude);
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public Integer getMinBuildNumberToKeep() {
        return this.minBuildNumberToKeep;
    }

    public void setMinBuildNumberToKeep(Integer minBuildNumberToKeep) {
        this.minBuildNumberToKeep = minBuildNumberToKeep;
    }
}

