/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum PlanBranchWorkflow {
    BRANCH_WORKFLOW("branches", EnumSet.of(BranchIntegrationStrategy.BRANCH_UPDATER, BranchIntegrationStrategy.GATE_KEEPER)),
    MANUAL_WORKFLOW("manual", EnumSet.of(BranchIntegrationStrategy.BRANCH_UPDATER, BranchIntegrationStrategy.GATE_KEEPER)),
    PULL_REQUEST_WORKFLOW("pullRequests", EnumSet.of(BranchIntegrationStrategy.BRANCH_UPDATER));

    private static final Map<String, PlanBranchWorkflow> KEYS_TO_WORKFLOWS;
    private final String key;
    private final FinalHashSet<BranchIntegrationStrategy> integrationStrategies;

    private PlanBranchWorkflow(String key, Set<BranchIntegrationStrategy> integrationStrategies) {
        this.key = key;
        this.integrationStrategies = FinalHashSet.copyOf(integrationStrategies);
    }

    public static PlanBranchWorkflow defaultValue() {
        return MANUAL_WORKFLOW;
    }

    @NotNull
    public static PlanBranchWorkflow fromKey(@NotNull String key) {
        return Optional.of(key).map(KEYS_TO_WORKFLOWS::get).orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a valid key of %s", key, PlanBranchWorkflow.class.getSimpleName())));
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public Set<BranchIntegrationStrategy> getIntegrationStrategies() {
        return Collections.unmodifiableSet(this.integrationStrategies);
    }

    static {
        KEYS_TO_WORKFLOWS = Arrays.stream(PlanBranchWorkflow.values()).collect(Collectors.toMap(PlanBranchWorkflow::getKey, UnaryOperator.identity()));
    }
}

